/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifndef CORTST_CFG_H
#define CORTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "Dem_Cfg.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CORTST_VENDOR_ID_CFG                      (180)
#define CORTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CORTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CORTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CORTST_SW_MAJOR_VERSION_CFG               (2)
#define CORTST_SW_MINOR_VERSION_CFG               (0)
#define CORTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/

/*==================================================================================================
 *                                        CorTstPrecompile
==================================================================================================*/
/**
 * @brief   Pre-compile configuration constants.
 */
#define CORTST_PRECOMPILE_SUPPORT           (STD_ON)

/*==================================================================================================
 *                                   CorTstDemEventParameterRefs
==================================================================================================*/
/**
 * @brief   Switch to enable the extended production error report.
 */
#define CORTST_DEM_EVENT_REPORT             (STD_ON)

/**
 * @brief   Dem Event Id for CORTST_E_CORE_FAILURE.
 */
#define CORTST_E_CORE_FAILURE_DEM_EVENT_ID  DemConf_DemEventParameter_CORTST_E_CORE_FAILURE

/*==================================================================================================
 *                                          CorTstGeneral
==================================================================================================*/

/**
 * @brief   Switch to indicate that the SchM is supported.
 */
#define CORTST_SCHM_SUPPORT                 (STD_ON)

/**
 * @brief   Switch to enable the development error detection.
 */
#define CORTST_DEV_ERROR_DETECT             (STD_ON)

/**
 * @brief   Switch to indicate that the notification is supported.
 */
#define CORTST_NOTIFICATION_SUPPORT         (STD_ON)

/**
 * @brief   This parameter holds the number of test configurations available for the foreground
 *          tests as defined in this configuration.
 */
#define CORTST_FGND_TEST_NUMBER             (1U)

/**
 * @brief   Defines the end value of the Test Interval Id.
 */
#define CORTST_TEST_INTERVAL_ID_END_VALUE   (1U)

/**
 * @brief   Specifies the InstanceId of this module instance. If only one instance is present it
 *          shall have the Id 0.
 */
#define CORTST_INDEX                        (0U)

/*==================================================================================================
 *                                     CorTstConfigApiServices
==================================================================================================*/
/**
 * @brief   Adds / removes the service CorTst_Abort() from the code.
 */
#define CORTST_ABORT_API                    (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_GetFgndResult() from the code.
 */
#define CORTST_GET_FGND_RESULT              (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_GetCurrentStatus() from the code.
 */
#define CORTST_GET_CURRENT_STATUS           (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_GetFgndSignature() from the code.
 */
#define CORTST_GET_FGND_SIGNATURE           (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_GetSignature() from the code.
 */
#define CORTST_GET_SIGNATURE                (STD_ON)


/**
 * @brief   Adds / removes the service CorTst_GetState() from the code.
 */
#define CORTST_GET_STATE_API                (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_Start() from the code.
 */
#define CORTST_START_API                    (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_GetVersionInfo() from the code.
 */
#define CORTST_VERSION_INFO_API             (STD_ON)

/**
 * @brief   Adds / removes the service CorTst_GetDetailsResult() from the code.
 */
 #define CORTST_GET_DETAIL_RESULT_API       (STD_OFF)

/*==================================================================================================
 *                                    CorTstBackgroundConfigSet
==================================================================================================*/
/**
 * @brief   The maximum number of background test configurations.
 */
#define CORTST_BGND_TEST_NUMBER (1U)

/*==================================================================================================
 *                                    CorTstForegroundConfigSet
==================================================================================================*/
/**
 * @brief   Symbolic names of configured foreground tests.
 */
#define CorTstConf_CorTstForegroundConfigSet_All   (0U)

#ifdef __cplusplus
}
#endif

#endif /* CORTST_CFG_H */

