/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file CorTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "CorTst_Cfg.h"
#include "CorTst_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CORTST_VENDOR_ID_CFG_C                      (180)
#define CORTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define CORTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define CORTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define CORTST_SW_MAJOR_VERSION_CFG_C               (2)
#define CORTST_SW_MINOR_VERSION_CFG_C               (0)
#define CORTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* CorTst_Cfg.h version check */
#if (CORTST_VENDOR_ID_CFG_C != CORTST_VENDOR_ID_CFG)
#error "CorTst_Cfg.c and CorTst_Cfg.h have different vendor ids"
#endif
#if ((CORTST_AR_RELEASE_MAJOR_VERSION_CFG_C != CORTST_AR_RELEASE_MAJOR_VERSION_CFG) || \
     (CORTST_AR_RELEASE_MINOR_VERSION_CFG_C != CORTST_AR_RELEASE_MINOR_VERSION_CFG) || \
     (CORTST_AR_RELEASE_REVISION_VERSION_CFG_C != CORTST_AR_RELEASE_REVISION_VERSION_CFG) \
    )
#error "AutoSar Version Numbers of CorTst_Cfg.c and CorTst_Cfg.h are different"
#endif
#if ((CORTST_SW_MAJOR_VERSION_CFG_C != CORTST_SW_MAJOR_VERSION_CFG) || \
     (CORTST_SW_MINOR_VERSION_CFG_C != CORTST_SW_MINOR_VERSION_CFG) || \
     (CORTST_SW_PATCH_VERSION_CFG_C != CORTST_SW_PATCH_VERSION_CFG) \
    )
#error "Software Version Numbers of CorTst_Cfg.c and CorTst_Cfg.h are different"
#endif

/* CorTst_Types.h version check */
#if (CORTST_VENDOR_ID_CFG_C != CORTST_TYPES_VENDOR_ID)
#error "CorTst_Cfg.c and CorTst_Types.h have different vendor ids"
#endif
#if ((CORTST_AR_RELEASE_MAJOR_VERSION_CFG_C != CORTST_TYPES_AR_RELEASE_MAJOR_VERSION) || \
     (CORTST_AR_RELEASE_MINOR_VERSION_CFG_C != CORTST_TYPES_AR_RELEASE_MINOR_VERSION) || \
     (CORTST_AR_RELEASE_REVISION_VERSION_CFG_C != CORTST_TYPES_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of CorTst_Cfg.c and CorTst_Types.h are different"
#endif
#if ((CORTST_SW_MAJOR_VERSION_CFG_C != CORTST_TYPES_SW_MAJOR_VERSION) || \
     (CORTST_SW_MINOR_VERSION_CFG_C != CORTST_TYPES_SW_MINOR_VERSION) || \
     (CORTST_SW_PATCH_VERSION_CFG_C != CORTST_TYPES_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of CorTst_Cfg.c and CorTst_Types.h are different"
#endif

#define CORTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "CorTst_MemMap.h"

/**
 * @brief   Foreground Configuration
 */
CORTST_CONST static const CorTst_FgndConfigType CorTst_FgndConfigs[CORTST_FGND_TEST_NUMBER] = 
{
    /* Foreground Configuration of All */
    {
        {
            TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, /* CorTstInterrupt */
            TRUE, TRUE, TRUE, /* CorTstBranch */
            TRUE, /* CorTstRegister */
            TRUE, TRUE, TRUE, TRUE, /* CorTstForward */
            TRUE, TRUE, TRUE, TRUE, /* CorTstAlu */
            TRUE, TRUE, /* CorTstStatus */
            TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, /* CorTstLoadstore */
            TRUE, /* CorTstFetch */
            TRUE, /* CorTstMac */
            TRUE, /* CorTstDivider */
            TRUE, TRUE, TRUE, TRUE, /* CorTstSimdsat */
            TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, /* CorTstFpu */
        }
    },
};

/**
 * @brief   Background Configuration
 */
CORTST_CONST static const CorTst_BgndConfigType CorTst_BgndConfigs[CORTST_BGND_TEST_NUMBER] = 
{
    /* Background Configuration of All */
    {
        {
            TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, /* CorTstInterrupt */
            TRUE, TRUE, TRUE, /* CorTstBranch */
            TRUE, /* CorTstRegister */
            TRUE, TRUE, TRUE, TRUE, /* CorTstForward */
            TRUE, TRUE, TRUE, TRUE, /* CorTstAlu */
            TRUE, TRUE, /* CorTstStatus */
            TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, /* CorTstLoadstore */
            TRUE, /* CorTstFetch */
            TRUE, /* CorTstMac */
            TRUE, /* CorTstDivider */
            TRUE, TRUE, TRUE, TRUE, /* CorTstSimdsat */
            TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, /* CorTstFpu */
        }
    },
};

/**
 * @brief   CorTst Configuration
 */
CORTST_CONST const CorTst_ConfigType CorTst_Config = 
{
    .FgndConfigNum = CORTST_FGND_TEST_NUMBER,
    .BgndConfigNum = CORTST_BGND_TEST_NUMBER,
    .FgndConfig = CorTst_FgndConfigs,
    .BgndConfig = CorTst_BgndConfigs,
};

#define CORTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "CorTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

