/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file ClkTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CLKTST_VENDOR_ID_CFG_C                      (180)
#define CLKTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define CLKTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define CLKTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define CLKTST_SW_MAJOR_VERSION_CFG_C               (2)
#define CLKTST_SW_MINOR_VERSION_CFG_C               (0)
#define CLKTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                          INCLUDE FILES
==================================================================================================*/
#include "ClkTst_Types.h"
/*==================================================================================================
 *                                        FILE VERSION CHECKS
==================================================================================================*/
/**
 * @file     ClkTst_Cfg.c
 */
#if (CLKTST_VENDOR_ID_CFG_C != CLKTST_TYPES_VENDOR_ID)
#error "ClkTst_Cfg.c and ClkTst_Types.h have different vendor ids"
#endif

#if ((CLKTST_AR_RELEASE_MAJOR_VERSION_CFG_C != CLKTST_TYPES_AR_REL_MAJOR_VER) || \
     (CLKTST_AR_RELEASE_MINOR_VERSION_CFG_C != CLKTST_TYPES_AR_REL_MINOR_VER) || \
     (CLKTST_AR_RELEASE_REVISION_VERSION_CFG_C != CLKTST_TYPES_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of ClkTst_Cfg.c and ClkTst_Types.h are different"
#endif

#if ((CLKTST_SW_MAJOR_VERSION_CFG_C != CLKTST_TYPES_SW_MAJOR_VER) || \
     (CLKTST_SW_MINOR_VERSION_CFG_C != CLKTST_TYPES_SW_MINOR_VER) || \
     (CLKTST_SW_PATCH_VERSION_CFG_C != CLKTST_TYPES_SW_PATCH_VER))
#error "Software Version Numbers of ClkTst_Cfg.c and ClkTst_Types.h are different"
#endif
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
extern void SafLib_TestError_Notification(uint16 ModuleId); /**< Failed callback Notifaction */

/*==================================================================================================
 *                                          VARIATES
==================================================================================================*/
#define CLKTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "ClkTst_MemMap.h"

#ifdef CPU_YTM32B1MC0
CLKTST_CONST const boolean ClkTst_CMUConfig[CLKTST_CMU_CHANNEL_NUMS] = 
{
    TRUE,
    TRUE,


};
#else
CLKTST_CONST const boolean ClkTst_CMUConfig[CLKTST_CMU_CHANNEL_NUMS] = 
{
    TRUE,
    TRUE,
    TRUE,
    TRUE,


};
#endif

CLKTST_CONST const ClkTst_ConfigType ClkTst_Config = {

    .ClkTstCMUConfig = ClkTst_CMUConfig,
    .ClkTstFailedNotification = SafLib_TestError_Notification
};
#define CLKTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "ClkTst_MemMap.h"

#ifdef __cplusplus
}
#endif


