/* USER CODE BEGIN Header */
/* you can remove the copyright */
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * @file main.c
 * @brief
 *
*/

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

#include "StartupTest.h"
#include "RuntimeTest.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */



/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
uint32 Test_FailedFlag_Ecc = 0U;
uint32 Test_FailedFlag_Clk = 0U;
uint32 Test_FailedFlag_Ram = 0U;
uint32 Test_FailedFlag_Fls = 0U;
uint32_t SafTstFail_Flag = 0;
uint32 Test_CompleteFlag_Core = 0U;
uint32 Test_CompleteFlag_Ram = 0U;

uint32 FlsTst_FgndErrCnt = 0;
uint32 FlsTst_BgndErrCnt = 0;
uint32 FlsTst_BgndCount = 0;
boolean FlsTst_BgndTaskFlag = FALSE;
uint32 FlsTst_TimerCnt = 0;

boolean FlsTst_DemoAbortEn = FALSE;
boolean FlsTst_DemoSuspendEn = FALSE;
boolean FlsTst_DemoResumeEn = FALSE;
FlsTst_ErrorDetailsType FlsTst_DemoErrorDetails;

/* Flag to indicate if the background RAM test is completed */
volatile boolean RamTstBackGroundCompleted = FALSE;

/* Flag to indicate if the runtime test error occur */
volatile boolean RuntimeTest_ErrorFlag = FALSE;

/* MouduleId for Test Failed */
uint16 ErrorMouduleId = 0U;

/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void Delay_10ms(uint32 DelayCnt)
{
    uint32 i;
    volatile uint32 j;
    for (i = 0; i < DelayCnt; i++)
    {
        /* Assuming a clock frequency of 120MHz, this will create a delay of approximately 10ms */
        for (j = 0; j < 200000; j++)
        {
            /* Do nothing, just wait */
        }
    }
}

void SafLib_TestError_Notification(uint16 ModuleId)
{
    RuntimeTest_ErrorFlag = TRUE; /* Set the error flag to indicate a test error */
    ErrorMouduleId = ModuleId; /* Store the module ID that caused the error */
    switch(ModuleId)
    {
        case CLKTST_MODULE_ID:
            Test_FailedFlag_Clk = 1U;
            break;
        case ECCTST_MODULE_ID:
            Test_FailedFlag_Ecc = 1U;
            break;
        case FLSTST_MODULE_ID:
            Test_FailedFlag_Ram = 1U;
            break;
        case RAMTST_MODULE_ID:
            Test_FailedFlag_Fls = 1U;
            break;
        default:
            break;
    } 
    /* stop here for debug purpose */
    // while(1);
    /*TODO: remove the above while(1) and add failure handling code here, such as:
    * 1. enter Safe State of the system, for example: SW reset
    * 2. add SafLib test failure record, such as add UDS DTC
    */
}
/**
 * @brief  Callback function for the Fls test completion.
 *         This function is called when the Fls test is completed.
 *         It can be used to set a flag to indicate that the Fls test is completed.
 */
void FlsTst_ComplteNotification(void)
{
}
/**
 * @brief  Callback function for the CorTst test completion.
 *         This function is called when the CorTst test is completed.
 *         It can be used to handle the result of the CorTst run.
 * @param  ResultOfLastCorTstRun: The result of the last CorTst run, indicating whether it was successful or not.
 */
void CorTst_TestCompletedNotification(CorTst_ErrOkType ResultOfLastCorTstRun)
{
    Test_CompleteFlag_Core = 1U;
}

/**
 * @brief  Callback function for the background test.
 *         This function is called periodically to check the background test results.
 *         It increments the background test count and checks if the test result is not OK.
 *         If the test result is not OK, it increments the error count and retrieves error details.
 */
void FlsTst_Bgnd_CallBack(void)
{
    FlsTst_TestResultBgndType TempResultBgnd;
    FlsTst_TestSignatureBgndType TempSignatureBgnd;
    /* USER CODE BEGIN Bgnd_CallBack */
    FlsTst_BgndCount++;
    TempResultBgnd = FlsTst_GetTestResultBgnd();
    TempSignatureBgnd =  FlsTst_GetTestSignatureBgnd();
    if ((TempResultBgnd.BgndTestResult == FLSTST_RESULT_NOT_OK) || \
            (TempResultBgnd.BgndTestIntervalId != TempSignatureBgnd.BgndTestIntervalId))
    {
        FlsTst_BgndErrCnt++;
        FlsTst_DemoErrorDetails = FlsTst_GetErrorDetails();
    }
}

/**
 * @brief  Callback function for the RAM test completion.
 *         This function is called when the RAM test is completed.
 *         It sets a flag to indicate that the background RAM test is completed.
 * @param  ModuleId: The ID of the module that completed the RAM test.
 */
void RamTst_CompletedCallback(uint16 ModuleId)
{
    (void)ModuleId; /* Suppress unused parameter warning */
    RamTstBackGroundCompleted = TRUE;
}


/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
void Saflib_StarUptst(void)
{
    /* USER CODE BEGIN 1 */
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0U);
    /* Initialize SafLib modules for startup tests */
    if (MCU_POWER_ON_RESET == Mcu_GetResetReason())
//    if (MCU_SW_RESET == Mcu_GetResetReason())//east to test 
    {
        SafLib_StartupTest_Init();
        /* Run SafLib startup tests */
        SafLib_StartupTest_Run();
    } 
    else
    {
        SafTstFail_Flag=2;
    }
    /* USER CODE END 1 */ 
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */
