/**
 * @file    SchM_WdgTst.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR SchM_WdgTst module interface
 * @details API implementation for WDGTST driver
 *
 * @addtogroup SCHM_WDGTST_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : WDG, EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_WDGTST_H
#define SCHM_WDGTST_H

#ifdef __cplusplus
extern "C" {
#endif

/*
* @page misra_violations MISRA-C:2012 violations list
* PRQA S 0777 Rule 5.1: External identifiers shall be distinct
* PRQA S 0779 Rule 5.2: Identifiers declared in the same scope and name space shall be distinct
* PRQA S 0787 Rule 5.5: Identifiers shall be distinct from macro names. it's required when "MCAL_SCHM_LITE" is defined
*/
/* MR12 RULE 5.1 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit follows the AUTOSAR_SWS_RTE documentation
* standards but does not comply with M3CM Rule-5.1 (0777).
*/
/* MR12 RULE 5.2 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit follows the AUTOSAR_SWS_RTE documentation
* standards but does not comply with M3CM Rule-5.2 (0779).
*/
/* MR12 RULE 5.5 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit implemented
* with the macro define to reuse the code and reduce size, it's full tested and verified with no risks.
* standards but does not comply with M3CM Rule-5.5 (0787).
*/
/* PRQA S 0777,0779,0787 EOF */
/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/

#include "WdgTst_Cfg.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_WDGTST_VENDOR_ID                      (180)
#define SCHM_WDGTST_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_WDGTST_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_WDGTST_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_WDGTST_SW_MAJOR_VERSION               (2)
#define SCHM_WDGTST_SW_MINOR_VERSION               (0)
#define SCHM_WDGTST_SW_PATCH_VERSION               (0)

/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and WDGTST Configure header file are of the same vendor */
#if (SCHM_WDGTST_VENDOR_ID != WDGTST_VENDOR_ID_CFG)
#error "SchM_WdgTst.h and WdgTst_Cfg.h have different vendor ids"
#endif

/* Check if source file and WDGTST Configure header file are of the same Autosar version */
#if (( SCHM_WDGTST_AR_RELEASE_MAJOR_VERSION != WDGTST_AR_RELEASE_MAJOR_VERSION_CFG) || \
     ( SCHM_WDGTST_AR_RELEASE_MINOR_VERSION != WDGTST_AR_RELEASE_MINOR_VERSION_CFG) || \
     ( SCHM_WDGTST_AR_RELEASE_REVISION_VERSION != WDGTST_AR_RELEASE_REVISION_VERSION_CFG))
#error "AutoSar Version Numbers of SchM_WdgTst.h and WdgTst_Cfg.h are different"
#endif

/* Check if source file and WDGTST Configure header file are of the same Software version */
#if (( SCHM_WDGTST_SW_MAJOR_VERSION != WDGTST_SW_MAJOR_VERSION_CFG) || \
     ( SCHM_WDGTST_SW_MINOR_VERSION != WDGTST_SW_MINOR_VERSION_CFG) || \
     ( SCHM_WDGTST_SW_PATCH_VERSION != WDGTST_SW_PATCH_VERSION_CFG))
#error "Software Version Numbers of SchM_WdgTst.h and WdgTst_Cfg.h are different"
#endif

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES (1U)
#endif

/*==================================================================================================
 *                                       FUNCTION PROTOTYPES
==================================================================================================*/
#if (STD_ON == WDGTST_SCHM_SUPPORT)

#ifdef MCAL_SCHM_LITE

extern void SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA(void);
extern void SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA(void);

#define SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA_00() SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA()
#define SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA_00() SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA()

#define SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA_01() SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA()
#define SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA_01() SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA()

#else

#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

RTE_FUNC extern void SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA_00(void);
RTE_FUNC extern void SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA_00(void);

RTE_FUNC extern void SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA_01(void);
RTE_FUNC extern void SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA_01(void);

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

#endif /* MCAL_SCHM_LITE */

#else

#define SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA_00()
#define SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA_00()

#define SchM_Enter_WdgTst_WDGTST_EXCLUSIVE_AREA_01()
#define SchM_Exit_WdgTst_WDGTST_EXCLUSIVE_AREA_01()

#endif /* STD_ON == WDGTST_SCHM_SUPPORT */

#ifdef __cplusplus
}
#endif

#endif /* SCHM_WDGTST_H */

/** @} */

