/*
* @file    StkTst_Types.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : StkTst_Types
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef STKTST_TYPES_H
#define STKTST_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*=================================================================================================
 *                                        INCLUDE FILES
=================================================================================================*/
#include "Std_Types.h"
/*==================================================================================================
 *                                   FILE VERSION INFORMATION
==================================================================================================*/
#define STKTST_TYPES_VENDOR_ID                      (180)
#define STKTST_TYPES_AR_RELEASE_MAJOR_VERSION       (4)
#define STKTST_TYPES_AR_RELEASE_MINOR_VERSION       (4)
#define STKTST_TYPES_AR_RELEASE_REVISION_VERSION    (0)
#define STKTST_TYPES_SW_MAJOR_VERSION               (2)
#define STKTST_TYPES_SW_MINOR_VERSION               (0)
#define STKTST_TYPES_SW_PATCH_VERSION               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/
/**
 * @brief  This enumerated type will contain the possible states of the StkTst driver.
 * @sw_type sw_arch
 *
 */
typedef enum
{
    STKTST_UNINIT               = 0x00U,    /**< The stack test is not initialized */
    STKTST_INIT                 = 0x01U,     /**< The stack test is initialized */
    STKTST_TESTING              = 0x02U,     /**< The stack test  is running   */
    STKTST_TESTED               = 0x03U,     /**< The stack test  is completed   */
} StkTst_StateType;

/**
 * @brief  This enumerated type will contain the possible results of all tests.
 * @sw_type sw_arch
 *
 */
typedef enum
{
    STKTST_RESULT_NOT_TESTED    = 0x00U,    /**< Test not executed */
    STKTST_RESULT_OK            = 0x01U,    /**< Test passed */
    STKTST_RESULT_NOT_OK        = 0x02U     /**< Test failed */
} StkTst_TestResultType;

/*==================================================================================================
 *                                             TYPEDEF
==================================================================================================*/
/**
 * @brief   The type specifies the stack address.
 * @sw_type sw_arch
 *
 */
typedef uint32 StkTst_AddrType;

/**
 * @brief   The type specifies the stack pad value.
 * @sw_type sw_arch
 *
 */
typedef uint32 StkTst_PadType;

/**
 * @brief   The type specifies the stack size.
 * @sw_type sw_arch
 *
 */
typedef uint32 StkTst_SizeType;

/**
 * @brief   The type specifies the stack signature.
 * @sw_type sw_arch
 *
 */
typedef uint32 StkTst_SignType;

/**
 * @brief   The type specifies the notification.
 * @sw_type sw_arch
 *
 */
typedef void (*StkTst_FailedNotificationType)(uint16 MoudleId);

/**
 * @brief   Definition of the configuration structure for the StkTst driver.
 * @sw_type sw_arch
 *
 */
typedef struct
{
    StkTst_AddrType BotAddr;    /**< Stack bottom address */
    StkTst_PadType PadValue;    /**< Stack pad value */
    StkTst_SizeType DetSize;    /**< Stack detection region size */
    StkTst_SignType OrgSign;    /**< Stack pad original signature */
#if (STKTST_NOTIFICATION_SUPPORTED == STD_ON)
    StkTst_FailedNotificationType OvfCbk;   /**< Stack overflow notification */
#endif /* STKTST_NOTIFICATION_SUPPORTED == STD_ON */
} StkTst_ConfigType;

#ifdef __cplusplus
}
#endif

#endif /* End of file StkTst_Types.h */


