/*
* @file    RamTst_Lld.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : RamTst_Lld
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef RAMTST_LLD_H
#define RAMTST_LLD_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "RamTst_Types.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define RAMTST_LLD_VENDOR_ID                     (180)
#define RAMTST_LLD_AR_REL_MAJOR_VER              (4)
#define RAMTST_LLD_AR_REL_MINOR_VER              (4)
#define RAMTST_LLD_AR_REL_REVISION_VER           (0)
#define RAMTST_LLD_SW_MAJOR_VER                  (2)
#define RAMTST_LLD_SW_MINOR_VER                  (0)
#define RAMTST_LLD_SW_PATCH_VER                  (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if RamTst_Lld.h and RamTst_Types.h are of the same vendor */
#if (RAMTST_LLD_VENDOR_ID != RAMTST_TYPES_VENDOR_ID)
#error "RamTst_Lld.h and RamTst_Types.h have different vendor ids"
#endif

/* Check if RamTst_Lld.h and RamTst_Types.h are of the same Autosar version */
#if ((RAMTST_LLD_AR_REL_MAJOR_VER != RAMTST_TYPES_AR_REL_MAJOR_VER) || \
     (RAMTST_LLD_AR_REL_MINOR_VER != RAMTST_TYPES_AR_REL_MINOR_VER) || \
     (RAMTST_LLD_AR_REL_REVISION_VER != RAMTST_TYPES_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of RamTst_Lld.h and RamTst_Types.h are different"
#endif

/* Check if RamTst_Lld.h and RamTst_Types.h are of the same software version */
#if ((RAMTST_LLD_SW_MAJOR_VER != RAMTST_TYPES_SW_MAJOR_VER) || \
     (RAMTST_LLD_SW_MINOR_VER != RAMTST_TYPES_SW_MINOR_VER) || \
     (RAMTST_LLD_SW_PATCH_VER != RAMTST_TYPES_SW_PATCH_VER))
#error "Software Version Numbers of RamTst_Lld.h and RamTst_Types.h are different"
#endif

/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
/**
 * @brief           This function initializes the RamTst_Lld module.
 * @details
 *
 * @table            @is_reentrant:     false  \n
 *                   @is_synchronous:   true   \n
 *                   @autosar_api:      false  \n
 *
 * @param[in]        ConfigPtr Pointer to the configuration set.
 * @return           void
 * @sw_type          sw_detail
 */
void RamTst_Lld_Init(const RamTst_ConfigType *ConfigPtr);

/**
 * @brief           This function de-initializes the RamTst_Lld module.
 * @details
 *
 * @table            @is_reentrant:     false  \n
 *                   @is_synchronous:   true   \n
 *                   @autosar_api:      false  \n
 *
 * @param[in]        void
 * @return           void
 * @sw_type          sw_detail
 */
void RamTst_Lld_DeInit(void);

/**
 * @brief           This function is used to perform a specific RAM test based on the current state of the RAM test algorithm.
 * @details
 *
 * @table            @is_reentrant:     false  \n
 *                   @is_synchronous:   true   \n
 *                   @autosar_api:      false  \n
 *
 * @param[in]        TestedCells Number of cells to be tested.
 * @return           Std_ReturnType
 * @retval           E_OK:     The current RAM cells tested successfully.
 * @retval           E_NOT_OK: The function has not been successfully executed or error occurs during RAM test.
 * @sw_type          sw_detail
 */
Std_ReturnType RamTst_Lld_BlockTest(RamTst_NumberOfTestedCellsType TestedCells);

#ifdef __cplusplus
}
#endif

#endif /* End of file RamTst_Lld.h */

