/*
* @file    IntTst_Lld_Ptmr.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : IntTst_Lld_Ptmr
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef INTTST_LLD_PTMR_H
#define INTTST_LLD_PTMR_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/

#include "pSIP_Ptmr.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define INTTST_LLD_PTMR_VENDOR_ID                     (180)
#define INTTST_LLD_PTMR_AR_REL_MAJOR_VER              (4)
#define INTTST_LLD_PTMR_AR_REL_MINOR_VER              (4)
#define INTTST_LLD_PTMR_AR_REL_REVISION_VER           (0)
#define INTTST_LLD_PTMR_SW_MAJOR_VER                  (2)
#define INTTST_LLD_PTMR_SW_MINOR_VER                  (0)
#define INTTST_LLD_PTMR_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/

#define INTTST_PTMR            pTMR0           /*!< use pTMR0 for the IntTst test */

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

/* declare the extern functions defined in the IntTst_Lld_Ptmr.c */
/**
 * @brief   Initialize the pTMR module
 *
 * @param[in]   Base       The pTMR module register base address
 * @table       @service_id:       --  \n
 *              @is_reentrant:     false  \n
 *              @is_synchronous:   true  \n
 *              @autosar_api:      false  \n
 *              @memory_map:       .mcal_text \n
 * @return    void
 * @sw_type   sw_detail
 */
void IntTst_LLd_Ptmr_Init(volatile pTMR_Type *Base);
/**
 * @brief   Start the pTMR channel with the start value
 *
 * @param[in]   Base        The pTMR module register base address
 * @param[in]   Channel     The pTMR channel number
 * @param[in]   StartValue  The start value of the pTMR channel
 * @table       @service_id:       --  \n
 *              @is_reentrant:     false  \n
 *              @is_synchronous:   true  \n
 *              @autosar_api:      false  \n
 *              @memory_map:       .mcal_text \n
 * @return    void
 * @sw_type   sw_detail
 */
void IntTst_Lld_Ptmr_StartChannel(volatile pTMR_Type *Base, uint8 Channel, uint32 StartValue);
/**
 * @brief   Stop the pTMR channel with channel disabled and interrupt disabled
 *
 * @param[in]   Base        The pTMR module register base address
 * @param[in]   Channel     The pTMR channel number
 * @table       @service_id:       --  \n
 *              @is_reentrant:     false  \n
 *              @is_synchronous:   true  \n
 *              @autosar_api:      false  \n
 *              @memory_map:       .mcal_text \n
 * @return    void
 * @sw_type   sw_detail
 */
void IntTst_Lld_Ptmr_StopChannel(volatile pTMR_Type *Base, uint8 Channel);
/**
 * @brief Process the pTMR channel interrupt, double the channel interrupt flag with the channel interrupt enable configuration
 *        clean the interrupt flag via write 1 clear
 *
 * @param[in] Base        The pTMR module register base address
 * @param[in] Channel     The pTMR channel number
 *
 * @table       @service_id:       --  \n
 *              @is_reentrant:     false  \n
 *              @is_synchronous:   true  \n
 *              @autosar_api:      false  \n
 *              @memory_map:       .mcal_text \n
 * @return void
 * @sw_type sw_detail
 */
void IntTst_Lld_Ptmr_ChannelIrqProcess(volatile pTMR_Type *Base, uint8 Channel);
/**
 * @brief   Deinitialize the pTMR module
 *
 * @param[in]   Base       The pTMR module register base address
 * @table       @service_id:       --  \n
 *              @is_reentrant:     false  \n
 *              @is_synchronous:   true  \n
 *              @autosar_api:      false  \n
 *              @memory_map:       .mcal_text \n
 * @return    void
 * @sw_type   sw_detail
 */
void IntTst_LLd_Ptmr_DeInit(volatile pTMR_Type *Base);

#ifdef __cplusplus
}
#endif

#endif /* End of file IntTst_Lld_Ptmr.h */
