/*
* @file    IntTst_Lld_Intm.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : IntTst_Lld_Intm
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef INTTST_LLD_INTM_H
#define INTTST_LLD_INTM_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/

#include "pSIP_Intm.h"
#include "Platform_Mld_TypesDef.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define INTTST_LLD_INTM_VENDOR_ID                     (180)
#define INTTST_LLD_INTM_AR_REL_MAJOR_VER              (4)
#define INTTST_LLD_INTM_AR_REL_MINOR_VER              (4)
#define INTTST_LLD_INTM_AR_REL_REVISION_VER           (0)
#define INTTST_LLD_INTM_SW_MAJOR_VER                  (2)
#define INTTST_LLD_INTM_SW_MINOR_VER                  (0)
#define INTTST_LLD_INTM_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

/* declare the extern functions defined in the IntTst_Lld_Intm.c */

/**
 * @brief   Initialize the INTM module
 *
 * @param[in]  Base       The INTM module register base address
 * @table       @service_id:       --  \n
                @is_reentrant:     false  \n
                @is_synchronous:   true  \n
                @autosar_api:      false  \n
                @memory_map:      .mcal_text \n
 * @return void
 * @sw_type sw_detail
 */
void IntTst_LLd_Intm_Init(volatile INTM_Type *Base);
/**
 * @brief   Acknowledge the INTM channel interrupt
 *
 * @param[in]  Base       The INTM module register base address
 * @param[in]  Channel    The INTM channel number
 * @table       @service_id:       --  \n
                @is_reentrant:     false  \n
                @is_synchronous:   true  \n
                @autosar_api:      false  \n
                @memory_map:      .mcal_text \n
 * @return void
 * @sw_type sw_detail
 */
void IntTst_Lld_Intm_AckIrq(volatile INTM_Type *Base, uint8 Channel);
/**
 * @brief   Configure the INTM channel
 *
 * @param[in]  Base          The INTM module register base address
 * @param[in]  Channel       The INTM channel number
 * @param[in]  IrqNumber    The INTM channel monitor peripheral IRQ interrupt number
 * @param[in]  Irq_Latency   The INTM channel monitor peripheral IRQ interrupt latency
 * @table       @service_id:       --  \n
                @is_reentrant:     false  \n
                @is_synchronous:   true  \n
                @autosar_api:      false  \n
                @memory_map:      .mcal_text \n
 * @return void
 * @sw_type sw_detail
 */
void IntTst_Lld_Intm_ChannelConfig(volatile INTM_Type *Base, uint8 Channel, IRQn_Type IrqNumber, uint32 Irq_Latency);
/**
 * @brief   Reset the INTM monitor channel configuration
 *
 * @param[in]  Base         The INTM module register base address
 * @param[in]  Channel      The INTM channel number
 * @table       @service_id:       --  \n
                @is_reentrant:     false  \n
                @is_synchronous:   true  \n
                @autosar_api:      false  \n
                @memory_map:      .mcal_text \n
 * @return void
 * @sw_type sw_detail
 */
void IntTst_Lld_Intm_ResetChannelConfig(volatile INTM_Type *Base, uint8 Channel);
/**
 * @brief   Get the INTM channel status
 *
 * @param[in]  Base       The INTM module register base address
 * @param[in]  Channel    The INTM channel number
 * @table       @service_id:       --  \n
                @is_reentrant:     false  \n
                @is_synchronous:   true  \n
                @autosar_api:     false  \n
                @memory_map:      .mcal_text \n
* @return boolean
* @retval TRUE  The monitor channel is interrupt enabled and the interrupt flag is set
* @retval FALSE The monitor channel is interrupt disabled or the interrupt flag is not set
* @sw_type sw_detail
*/
boolean IntTst_Lld_Intm_GetChannelStatus(const volatile INTM_Type *Base, uint8 Channel);
/**
 * @brief   De-initialize the INTM module
 *
 * @param[in]  Base       The INTM module register base address
 * @table       @service_id:       --  \n
                @is_reentrant:     false  \n
                @is_synchronous:   true  \n
                @autosar_api:      false  \n
                @memory_map:     .mcal_text \n
* @return void
* @sw_type sw_detail
*/
void IntTst_LLd_Intm_DeInit(volatile INTM_Type *Base);

#ifdef __cplusplus
}
#endif

#endif /* End of file IntTst_Lld_Intm.h */
