/*
* @file    EfmTst_Lld.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : EfmTst_Lld
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef EFMTST_LLD_H
#define EFMTST_LLD_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "EfmTst_Types.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define EFMTST_LLD_VENDOR_ID                     (0xB4)
#define EFMTST_LLD_AR_RELEASE_MAJOR_VERSION              (4)
#define EFMTST_LLD_AR_RELEASE_MINOR_VERSION              (4)
#define EFMTST_LLD_AR_RELEASE_REVISION_VERSION           (0)
#define EFMTST_LLD_SW_MAJOR_VERSION                  (2)
#define EFMTST_LLD_SW_MINOR_VERSION                  (0)
#define EFMTST_LLD_SW_PATCH_VERSION                  (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and EFMTST TYPES header file are of the same vendor */
#if (EFMTST_LLD_VENDOR_ID != EFMTST_TYPES_VENDOR_ID)
#error "EfmTst_Lld.h and EfmTst_Types.h have different vendor ids"
#endif

/* Check if source file and EFMTST TYPES header file are of the same Autosar version */
#if ((EFMTST_LLD_AR_RELEASE_MAJOR_VERSION != EFMTST_TYPES_AR_RELEASE_MAJOR_VERSION) || \
     (EFMTST_LLD_AR_RELEASE_MINOR_VERSION != EFMTST_TYPES_AR_RELEASE_MINOR_VERSION) || \
     (EFMTST_LLD_AR_RELEASE_REVISION_VERSION != EFMTST_TYPES_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of EfmTst_Lld.h and EfmTst_Types.h are different"
#endif

/* Check if source file and EFMTST TYPES header file are of the same software version */
#if ((EFMTST_LLD_SW_MAJOR_VERSION != EFMTST_TYPES_SW_MAJOR_VERSION) || \
     (EFMTST_LLD_SW_MINOR_VERSION != EFMTST_TYPES_SW_MINOR_VERSION) || \
     (EFMTST_LLD_SW_PATCH_VERSION != EFMTST_TYPES_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of EfmTst_Lld.h and EfmTst_Types.h are different"
#endif

/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/* Error flag mask */
#if defined (CPU_YTM32B1MC0)
#define EFMTST_ERR_FLAGS_MASK                (EFM_STS_CMD_FAIL_MASK|\
                                            EFM_STS_ACCERR_MASK|\
                                            EFM_STS_UNRECOVERR_MASK|\
                                            EFM_STS_RECOVERR_MASK)
#elif defined (CPU_YTM32B1HA0)
#define EFMTST_ERR_FLAGS_MASK                (EFM_STS_FAIL_MASK|\
                                            EFM_STS_ACCERR_MASK|\
                                            EFM_STS_UNRECOVERR_MASK|\
                                            EFM_STS_RECOVERR_MASK|\
                                            EFM_STS_CI_UNRECOVERR_MASK|\
                                            EFM_STS_CI_RECOVERR_MASK)
#else
#define EFMTST_ERR_FLAGS_MASK                (EFM_STS_FAIL_MASK|\
                                            EFM_STS_ACCERR_MASK|\
                                            EFM_STS_UNRECOVERR_MASK|\
                                            EFM_STS_RECOVERR_MASK)
#endif
/* Addr selected flag */
#if defined (CPU_YTM32B1HA0)
#define EFMTST_ADDR_SELECTED_FLAG_MASK           (EFM_STS_SET_ADDR_MASK)
#elif defined (CPU_YTM32B1MC0)
#define EFMTST_ADDR_SELECTED_FLAG_MASK           (EFM_STS_ARRAY_SELECTED_MASK)
#else
#endif
/* Sector Erase Command and Error Command Unlock Key */
#define EFMTST_SECTOR_ERASE_COMMAND_CODE     (0x10u)
#define EFMTST_ERROR_CMDUNLOCK_KEY           (0xED9573F5U)
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
/**
 * @brief This function will set flash protect register according to the configuration
 * @param[in]  SectorProtCfg  Pointer to the EFM test flash protection configuration data
 *
 * @table            @service_id:       --  \n
                     @is_reentrant:     false  \n
                     @is_synchronous:   true  \n
                     @autosar_api:      false  \n
 *
 * @return     void
 * @sw_type sw_detail
 * @private
*/
void EfmTst_Lld_Init(EfmTst_SectorProtCfgType const *SectorProtCfg);

#if (EFMTST_ENABLE_CMD_UNLOCK_TEST == STD_ON)
/**
 * @brief Service for starting the Command Unlock test.
 * @details The function initializes the test by clearing the status register, executing a NOP command, setting the Write Enable bit,
 *          and writing a test value to a protected sector. It then clears the Write Enable bit and checks if the address is set.
 *          If the address is not set, it loads a sector erase command and verifies the Command Error flag.
 *
 * @table            @service_id:       --  \n
                     @is_reentrant:     false \n
                     @is_synchronous:   true  \n
                     @autosar_api:      false  \n
 * @return     void
 * @sw_type sw_detail
 * @private
 */
Std_ReturnType EfmTst_Lld_CommandUnlock_Start(void);
#endif /* #if (EFMTST_ENABLE_CMD_UNLOCK_TEST == STD_ON) */

#if (EFMTST_ENABLE_WRITE_ENABLE_TEST == STD_ON)
/**
 * @brief Service for starting the Write Enable test.
 * @details The function initializes the test by clearing the status register, executing a NOP command, setting the exception handler,
 *          and writing a test value to a protected sector. It then checks if the address is set and verifies the Write Error flag.
 *
 * @table            @service_id:       --  \n
                     @is_reentrant:     false \n
                     @is_synchronous:   true  \n
                     @autosar_api:      false  \n
 * @return     void
 * @sw_type sw_detail
 * @private
 */
Std_ReturnType EfmTst_Lld_WriteEnable_Start(void);
#endif /* #if (EFMTST_ENABLE_WRITE_ENABLE_TEST == STD_ON) */

#ifdef __cplusplus
}
#endif

#endif /* End of file EfmTst_Lld.h */
