/**
 * @file    CorTst_Shell.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR CorTst module shell
 * @details API implementation for CorTst driver
 *
 * @addtogroup CORTST_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Core
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef CORTST_SHELL_H
#define CORTST_SHELL_H

#ifdef __cplusplus
extern "C" {
#endif

/*=================================================================================================
 *                                        INCLUDE FILES
=================================================================================================*/
#include "CorTst_Types.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CORTST_SHELL_VENDOR_ID                      (180)
#define CORTST_SHELL_AR_RELEASE_MAJOR_VERSION       (4)
#define CORTST_SHELL_AR_RELEASE_MINOR_VERSION       (4)
#define CORTST_SHELL_AR_RELEASE_REVISION_VERSION    (0)
#define CORTST_SHELL_SW_MAJOR_VERSION               (2)
#define CORTST_SHELL_SW_MINOR_VERSION               (0)
#define CORTST_SHELL_SW_PATCH_VERSION               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* CorTst_Types.h version check */
#if (CORTST_SHELL_VENDOR_ID != CORTST_TYPES_VENDOR_ID)
#error "CorTst_Shell.h and CorTst_Types.h have different vendor ids"
#endif
#if ((CORTST_SHELL_AR_RELEASE_MAJOR_VERSION != CORTST_TYPES_AR_RELEASE_MAJOR_VERSION) || \
     (CORTST_SHELL_AR_RELEASE_MINOR_VERSION != CORTST_TYPES_AR_RELEASE_MINOR_VERSION) || \
     (CORTST_SHELL_AR_RELEASE_REVISION_VERSION != CORTST_TYPES_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of CorTst_Shell.h and CorTst_Types.h are different"
#endif
#if ((CORTST_SHELL_SW_MAJOR_VERSION != CORTST_TYPES_SW_MAJOR_VERSION) || \
     (CORTST_SHELL_SW_MINOR_VERSION != CORTST_TYPES_SW_MINOR_VERSION) || \
     (CORTST_SHELL_SW_PATCH_VERSION != CORTST_TYPES_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of CorTst_Shell.h and CorTst_Types.h are different"
#endif

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
#define CORTST_WRONG_RANGE                      0xFF030303U
#define CORTST_TEST_WAS_INTERRUPTED             0xFF121212U
#define CORTST_TEST_FAULT_INJECT                0x53481521U
#define CORTST_DEFAULT_FAULT_INJECT_TEST_INDEX  0xFFFFFFFFU
#define CORTST_ACCUMULATED_SIGNATURE_ALL_IDS    0xDA02850BU

/*==================================================================================================
 *                                      GLOBAL VARIABLES
==================================================================================================*/
extern uint32 CorTst_FaultInjectValue;
extern volatile uint32 CorTst_AccumulatedSignature;
extern uint32 CorTst_FaultInjectTestIndex;

/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/
/**
 * @brief       Service for executing the Atomic Core Test.
 * @param[in]   AtomicTestId Id of the atomic test.
 * @param[out]  Signature Address to store the calculated signature.
 * @return      E_OK if the test was executed successfully, E_NOT_OK otherwise.
 * @table       @is_reentrant:     false       \n
 *              @is_synchronous:   true        \n
 *              @autosar_api:      false       \n
 *              @memory_map:       .mcal_text  \n
 * @sw_type     sw_detail
 *
 * @trace       YTDT_CorTst_860
 */
Std_ReturnType CorTst_Execute(uint32 AtomicTestId, uint32 *Signature);

#ifdef __cplusplus
}
#endif

#endif /* CORTST_SHELL_H */

/** @} */

