/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests cm33fpu_rf.v module registers memory for stuck-at, short, stuck-open,
* open faults, as well as interferences between registers.
*
* Test procedure:
* --------------
* 1) Test registers addressing and interferences between registers.
*     a) Initialize all bits in all registers to all ones or all zeros.
*     b) Write test value into the dedicated register.
*     c) Compute the checksum over all registers.
*     d) Repeat steps above for all S0-S31 FPU registers.
*
* 2) Test SIMD&FP regbank registers memory.
*     a) Initialize all S0-S31 registers with randomly generated 32bit test vectors.
*     b) Compute the checksum over all registers.
*
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_FPU_ENABLE==1)

    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_SpfpuRegbankTest1

    /* Symbols defined outside but to be used in current module */
    CST_EXTERN m33_cst_test_tail_fpu_end
    CST_EXTERN m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    CST_EXTERN m33_cst_write_fpu_regs_from_r0
    
    /* Pre-signature */
    CST_SET(PRESIGNATURE_SEED_0, 0x13BB)
    CST_SET(PRESIGNATURE_SEED_1, 0x6877)
    
    /* Values stored in registers:
       - R1  ... accumulated signature
       - R12 ... FPSCR register
    */

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_SpfpuRegbankTest1" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_TYPE(M33_Cst_SpfpuRegbankTest1, function)
    CST_THUMB2
M33_Cst_SpfpuRegbankTest1:

    PUSH    {R4-R12,R14}
    MRS     R1,CONTROL  /* Store CONTROL prior first FPU instruction */
    PUSH    {R1}
    VPUSH   {S16-S31}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    MOV     R1,#PRESIGNATURE_SEED_0
    MOVT    R1,#PRESIGNATURE_SEED_1
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0
    VMRS    R12,FPSCR   /* Store FPSCR register */
    VMSR    FPSCR,R0    /* Clear FPSR register */
    
    /**************************************************************************/
    /* 1) Test FP registers addressing and interferences between registers    */
    /**************************************************************************/
    MOV     R5,#0xAAAAAAAA
    MOV     R0,#0x0 /* All bits in SIMD&FP registers will be set to 0   */
    BL      m33_cst_fpu_regbank_test1_common_1
    MVN     R0,#0x0 /* All bits in SIMD&FP registers will be set to 1   */
    BL      m33_cst_fpu_regbank_test1_common_1

    MOV     R5,#0x55555555
    MOV     R0,#0x0 /* All bits in SIMD&FP registers will be set to 0   */
    BL      m33_cst_fpu_regbank_test1_common_1
    MVN     R0,#0x0 /* All bits in SIMD&FP registers will be set to 1   */
    BL      m33_cst_fpu_regbank_test1_common_1

    /**************************************************************************/
    /* 2) Test SIMD&FP regbank registers                                      */
    /**************************************************************************/
    /* Load all registers with the following randomly generated values */
    LDR     R0,=0xBEEACA5F
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0xDB442D04
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x0E4DB795
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x80775C42
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x21C3D3F9
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x534EF7C7
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x578C49EE
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x9B710899
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0x15DA0296
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2
    LDR     R0,=0xD5118800
    BL      m33_cst_fpu_regbank_test1_common_2
    MVN     R0,R0
    BL      m33_cst_fpu_regbank_test1_common_2


    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
m33_cst_spfpu_regbank_test1_end:
    VMSR    FPSCR,R12   /* Restore FPSCR register */
    /* Test result is returned in R0, according to the conventions */
    MVN     R0,R1 
    B       m33_cst_test_tail_fpu_end 


m33_cst_fpu_regbank_test1_common_1:
    /* Store LR to R4 it will be destroyed later */
    MOV     R4,LR  /* Do not use R4 !! */
    
    /* S0 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S0,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S1 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S1,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S2 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S2,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S3 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S3,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S4 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S4,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S5 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S5,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S6 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S6,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S7 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S7,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S8 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S8,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S9 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S9,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S10 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S10,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S11 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S11,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S12 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S12,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S13 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S13,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S14 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S14,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S15 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S15,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S16 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S16,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* V17 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S17,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S18 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S18,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S19 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S19,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S20 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S20,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S21 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S21,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S22 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S22,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S23 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S23,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S24 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S24,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S25 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S25,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S26 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S26,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S27 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S27,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S28 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S28,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S29 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S29,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S30 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S30,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    /* S31 */
    BL      m33_cst_write_fpu_regs_from_r0
    VMOV    S31,R5
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2

    BX     R4      /* Return from subroutine */


m33_cst_fpu_regbank_test1_common_2:
    /* Store LR to R4 it will be destroyed later */
    MOV     R4,LR  /* Do not use R4 !! */
    /* Write all registers */
    BL      m33_cst_write_fpu_regs_from_r0
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2

    BX     R4      /* Return from subroutine */
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_FPU_ENABLE */

    CST_FILE_END

