/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests ALU EXTRACT module and BARREL SHIFTER which provides the appropriate 
* right rotate of 0, 8, 16 or 24.
* SIMD packing unpacking instructions are tested with at least two sets of 
* inverted input operands, causing also all bits in the result be '1' and '0'.  
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:  
*  - UXTB, UXTH, SXTB, SXTH
*
* Thumb (32-bit) DECODER:
*  - UXTB, UXTH, SXTB, SXTH 
*  - UXTB16, SXTB16
*  - UXTAB, UXTAH, UXTAB16, SXTAB, SXTAH, SXTAB16
*  - PKHBT, PKHT, 
*  - SEL 
******************************************************************************/

#include "CorTst_Compiler.h"   
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_SIMDSAT_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside    */
    CST_EXPORT M33_Cst_SimdsatTest4
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

  
    CST_SET(PRESIGNATURE,0xC451C546)
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_SimdsatTest4" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_SimdsatTest4, function)
M33_Cst_SimdsatTest4:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R0,=PRESIGNATURE
    
    /* Initialize C-flag beacause ADCS is used for signature update !! */
    MOV     R1,#0
    MSR     APSR_nzcvq,R1 
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /* SXTB,UXTB            - 16bit Encoding T1                               */
    /* SXTB,UXTB{rotation}  - 32bit Encoding T2                               */
    /**************************************************************************/
    MOV     R10,R0              /* Load test vector */
    MOV     R2,R0
    UXTB    R6,R10,ROR #0       /* 32bit Encoding T2 */
    SXTB    R7,R10,ROR #8       /* 32bit Encoding T2 */
    UXTB    R8,R10,ROR #16      /* 32bit Encoding T2 */
    SXTB    R10,R10,ROR #24     /* 32bit Encoding T2 */
    UXTB.N  R1,R0               /* 16bit Encoding T1 */
    SXTB.N  R2,R2               /* 16bit Encoding T1 */
    
    MVN     R5,R0               /* Load inverted test vector */
    SXTB    R11,R5,ROR #8       /* 32bit Encoding T2 */
    UXTB    R9,R5,ROR #0        /* 32bit Encoding T2 */
    SXTB    R4,R5,ROR #24       /* 32bit Encoding T2 */
    UXTB    R12,R5,ROR #16      /* 32bit Encoding T2 */
    SXTB.N  R3,R5               /* 16bit Encoding T1 */
    UXTB.N  R5,R5               /* 16bit Encoding T1 */

    
    /* !! Update Signature !! */
    BL      m33_cst_simdsat_test4_sum_r1_r12    /* R0=0xA44FDC51 */
        
    /**************************************************************************/
    /* SXTH, UXTH           - 16bit Encoding T1                               */
    /* SXTH,UXTH{rotation}  - 32bit Encoding T2                               */
    /**************************************************************************/
    MOV     R6,R0               /* Load test vector */
    SXTH    R5,R6,ROR #0        /* 32bit Encoding T2 */    
    UXTH    R7,R6,ROR #8        /* 32bit Encoding T2 */
    SXTH    R8,R6,ROR #16       /* 32bit Encoding T2 */
    UXTH    R2,R6,ROR #24       /* 32bit Encoding T2 */
    SXTH.N  R1,R6               /* 16bit Encoding T1 */
    UXTH.N  R6,R6               /* 16bit Encoding T1 */
    
    MVN     R9,R0               /* Load inverted test vector */
    MVN     R3,R0
    SXTH    R10, R9,ROR #0      /* 32bit Encoding T2 */
    UXTH    R11,R9,ROR #8       /* 32bit Encoding T2 */
    SXTH    R12,R9,ROR #16      /* 32bit Encoding T2 */
    UXTH    R9,R9,ROR #24       /* 32bit Encoding T2 */
    SXTH.N  R4,R3               /* 16bit Encoding T1 */
    UXTH.N  R3,R3               /* 16bit Encoding T1 */
    
    /* !! Update Signature !! */
    BL      m33_cst_simdsat_test4_sum_r1_r12    /* R0=0x0B468947 */
    
    /**************************************************************************/
    /* SEL                                                                    */
    /**************************************************************************/
    MOV     R3,R0               /* Load test vector */
    MVN     R12,R0              /* Load inverted test vector */
    
    MOV     R5,#0x000F0000      /* APSR[GE] bits '0b1111' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF385)  /* MSR APSR_g, R5 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
   
    SEL     R5,R3,R12
    
    MOV     R2,#0x00000000      /* APSR[GE] bits '0b0000' */ 
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF382)  /* opcode for MSR APSR_g, R2 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R6,R3,R12
   
    MOV     R7,#0x000A0000      /* APSR[GE] bits '0b1010' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF387)  /* opcode for MSR APSR_g, R7 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R7,R12,R3
    
    MOV     R8,#0x00050000      /* APSR[GE] bits '0b0101' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF388)  /* opcode for MSR APSR_g, R8 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R8,R12,R3
    
    MOV     R9,#0x000C0000      /* APSR[GE] bits '0b1100' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF389)  /* opcode for MSR APSR_g, R9 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R9,R3,R12
    
    MOV     R10,#0x00030000     /* APSR[GE] bits '0b0011' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF38A)  /* opcode for MSR APSR_g, R10 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R10,R3,R12
    
    MOV     R11,#0x00070000     /* APSR[GE] bits '0b0111' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF38B)  /* opcode for MSR APSR_g, R11 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R11,R12,R3
    
    
    MOV     R12,#0x00080000     /* APSR[GE] bits '0b1000' */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
	CST_OPCODE32_HIGH(0xF38C)  /* opcode for MSR APSR_g, R12 */
	CST_OPCODE32_LOW(0x8400)
	CST_OPCODE_END
    
    SEL     R12,R12,R3
    
    /* !! Update Signature !! */
    BL      m33_cst_simdsat_test4_sum_r5_r12    /* R0=0x0B518A46 */
    
   
    /**************************************************************************/
    /* DSP extension instructions                                             */
    /**************************************************************************/
    /* SXTB16,UXTB16                                                          */
    /**************************************************************************/
    MOV     R3,R0               /* Load test vector */
    UXTB16  R5,R3,ROR #0
    SXTB16  R6,R3,ROR #8
    UXTB16  R7,R3,ROR #16
    SXTB16  R8,R3,ROR #24
    
    MVN     R12,R0              /* Load inverted test vector */
    UXTB16  R9,R12,ROR #0
    SXTB16  R10,R12,ROR #8
    UXTB16  R11,R12,ROR #16
    SXTB16  R12,R12,ROR #24
    
    /* !! Update Signature !! */
    BL      m33_cst_simdsat_test4_sum_r5_r12    /* R0=0x7FDF15B8 */
    
    /**************************************************************************/
    /* UXTAB16,SXTAB16                                                        */
    /* UXTAB,SXTAB                                                            */
    /* UXTAH,SXTAH                                                            */  
    /**************************************************************************/
    MOV     R5,R0               /* Load test vector */
    SXTAB16 R1,R5,R0,ROR #16
    UXTAB   R2,R5,R5,ROR #0 
    SXTAB   R3,R0,R5,ROR #8
    UXTAB16 R4,R5,R5,ROR #24
    SXTAH   R6,R5,R0,ROR #16
    UXTAH   R5,R5,R5,ROR #8
    
    MVN     R10,R0              /* Load inverted test vector */
    SXTAB16 R7,R10,R10,ROR #16
    UXTAB   R8,R10,R10,ROR #8
    SXTAB   R9,R10,R10,ROR #8    
    UXTAB16 R11,R10,R10,ROR #0
    SXTAH   R12,R10,R10,ROR #24
    UXTAH   R10,R10,R10,ROR #16
    
    /* !! Update Signature !! */
    BL      m33_cst_simdsat_test4_sum_r1_r12    /* R0=0x7BECD944 */
    
    /**************************************************************************/
    /* PKHTB, PKHBT                                                           */
    /**************************************************************************/
    MOV     R2,R0               /* Load test vector */
    MVN     R12,R0              /* Load inverted test vector */
    
    PKHTB   R1,R2,R12,ASR #10
    PKHBT   R3,R2,R12,LSL #1
    PKHTB   R4,R2,R12,ASR #24
    PKHBT   R5,R2,R12,LSL #4
    PKHTB   R6,R2,R12,ASR #2
    PKHBT   R7,R2,R12,LSL #16
    PKHTB   R8,R12,R2,ASR #8
    PKHBT   R9,R12,R2,LSL #20
    PKHTB   R10,R12,R2,ASR #27
    PKHBT   R11,R12,R2
    PKHTB   R12,R12,R2,ASR #31
    PKHBT   R2,R12,R2,LSL #5
    
    /* !! Update Signature !! */
    BL      m33_cst_simdsat_test4_sum_r1_r12    /* R0=0x17416263 */
    
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_simdsat_test4_end:
    /* Test result is returned in R0, according to the conventions */       
    B       m33_cst_test_tail_end
    
    
    /*------------------------------------------------------------------------*/
    /* Test - internal routines                                               */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /* !! Updates Signature !!                                                */
    /**************************************************************************/
m33_cst_simdsat_test4_sum_r1_r12:
    ADCS    R0,R0,R1
    ADCS    R0,R0,R2
    ROR     R0,R0,#8
    ADCS    R0,R0,R3
    ADCS    R0,R0,R4
    ROR     R0,R0,#8
m33_cst_simdsat_test4_sum_r5_r12:
    ADCS    R0,R0,R5
    ADCS    R0,R0,R6
    ROR     R0,R0,#8
    ADCS    R0,R0,R7
    ADCS    R0,R0,R8
    ROR     R0,R0,#8
    ADCS    R0,R0,R9
    ADCS    R0,R0,R10
    ROR     R0,R0,#8
    ADCS    R0,R0,R11
    ADCS    R0,R0,R12
    ROR     R0,R0,#8
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_SIMDSAT_ENABLE */
    
    CST_FILE_END

