/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests general purpose saturation instructions SSAT, SSAT16, USAT and USAT16 
* with various saturation conditions as well as their decoding.
* Tests condition flag Q.
* 
* Decoder coverage:
* ----------------
* Thumb (32-bit) DECODER:
*   - SSAT, SSAT16, USAT, USAT16
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_SIMDSAT_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside    */
    CST_EXPORT M33_Cst_SimdsatTest3
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    
    
    CST_SET(PRESIGNATURE,0x4CA43F32)

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_SimdsatTest3" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_SimdsatTest3, function)
M33_Cst_SimdsatTest3:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R8,=PRESIGNATURE
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0   /* Use R0 for flags clearing */
    
    CST_OPCODE_START
    CST_OPCODE16(0xF380)       /* MSR     APSR,R0 */     
    CST_OPCODE16(0x8C00)       /* Clears APSR_nzcvq, APSR_ge */    
    CST_OPCODE_END

    
    /**************************************************************************/
    /* SSAT with negative numbers                                             */
    /* Note: Tested in loop, first iteration is saturating,                   */
    /*       second iteration is non-saturating                               */
    /**************************************************************************/
    MOV     R3,#0x80000000      /* Test value */
    MOV     R5,#0x48000000      /* Expected flags - Z==1 and Q==1 */
    
m33_cst_simdsat_test3_ssat:
    MOV     R12,#0xFFFFFFFF
    SSAT    R4,#1,R3,ASR #30
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#1
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#2,R3,ASR #29
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#1
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#3,R3,ASR #28
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#2
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#5,R3,ASR #26
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#4
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#9,R3,ASR #22
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#8
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#17,R3,ASR #14
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#8
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#25,R3,ASR #6
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    LSL     R12,R12,#6
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#31,R3
    TEQ     R4,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end

    MOV     R5,#0x40000000      /* Expected flags - Z==1 and Q==0 */

    /* Perform always non-saturating operation */
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R4,#32,R3
    TEQ     R4,R3               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,R5               /* Check flags */
    BNE     m33_cst_simdsat_test3_end
    
    ASR     R3,R3,#1            /* Modify test value */
    
    /* Update signature */
    ROR     R8,R8,#1            /* 1. run: R8=0x26521F99 */
                                /* 2. run: R8=0x93290FCC */
    
    CMP     R3,#0xE0000000
    BNE     m33_cst_simdsat_test3_ssat


    /**************************************************************************/
    /* SSAT with positive numbers                                             */
    /**************************************************************************/
    /* Perform non-saturating operations */
    MVN     R1,#0x80000000      /* R1=0x7FFFFFFF */
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    SSAT    R2,#32,R1
    TEQ     R2,R1               /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R1,#0               /* Destroy value in R1 */
    
    LSR     R12,R2,#7
    SSAT    R3,#25,R2,ASR #7
    TEQ     R3,R12              /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R3,R2
    MOV     R2,#0
    
    LSR     R12,R12,#8
    SSAT    R4,#17,R3,ASR #15
    TEQ     R4,R12              /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R4,R3
    MOV     R3,#0
    
    SSAT    R5,#9,R4,ASR #23
    TEQ     R5,#0x000000FF      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R5,R4
    MOV     R4,#0
    
    SSAT    R6,#5,R5,ASR #27
    TEQ     R6,#0x0000000F      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R6,R5
    MOV     R5,#0
    
    SSAT    R7,#3,R6,ASR #29
    TEQ     R7,#0x00000003      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R0,R6
    MOV     R6,R8
    
    SSAT    R8,#2,R0,ASR #30
    TEQ     R8,#0x00000001      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R7,R0
    MOV     R0,#0xAAAAAAAA
    
    SSAT    R0,#1,R7,ASR #31
    TEQ     R0,#0               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(1<<30)         /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test3_end
    
    ROR     R6,R6,#1            /* Update signature -> R6=0x499487E6 */
    
    /* Perform saturating operations */
    LSR     R10,R7,#1
    SSAT    R1,#31,R8,LSL #30
    TEQ     R1,R10             /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R10,R8
    LSR     R8,R7,#7
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R11,#25,R10,LSL #24
    TEQ     R11,R8              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R11,R10
    MOV     R10,#0
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R14,#17,R11,LSL #16
    TEQ     R14,R12              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R14,R11
    MOV     R11,#0
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R12,#9,R14,LSL #8
    TEQ     R12,#0x000000FF     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R12,R14
    MOV     R14,#0
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R9,#5,R12,LSL #4
    TEQ     R9,#0x0000000F     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MOV     R8,R12
    MOV     R12,#0
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R10,#3,R8,LSL #2
    TEQ     R10,#0x00000003     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R12,#2,R8,LSL #1
    TEQ     R12,#0x00000001     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT    R12,#1,R8
    TEQ     R12,#0x0            /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end

    ROR     R8,R6,#1            /* Update signature -> R8=0x24CA43F3 */
    
    
    /**************************************************************************/
    /* SSAT16                                                                 */
    /**************************************************************************/
    MOV     R5,#0xAAAAAAAA  
    MOV     R10,#0x55555555

    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#16,R5
    TEQ     R3,R5               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(1<<30)         /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x3D0FCCA3 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#16,R10
    TEQ     R12,R10             /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(1<<30)         /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0xF3DD3BA6 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#15,R5
    TEQ     R3,#0xC000C000      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x39EF5DD3 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#15,R10
    MVN     R2,R3               /* R2=0x3FFF3FFF */     
    TEQ     R12,R2              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0xDCF6EEE8 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#14,R5
    TEQ     R3,#0xE000E000      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x4E7C5774 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#14,R10
    MVN     R2,R3               /* R2=0x1FFF1FFF */
    TEQ     R12,R2              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x473D4BB9 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#13,R5
    TEQ     R3,#0xF000F000      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x939F95DC */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#13,R10
    MVN     R2,R3               /* R2=0x0FFF0FFF */
    TEQ     R12,R2              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x59CEDAED */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#12,R5
    TEQ     R3,#0xF800F800      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xA4E86576 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#12,R10
    MVN     R2,R3               /* R2=0x07FF07FF */
    TEQ     R12,R2              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x5A733ABA */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#11,R5
    TEQ     R3,#0xFC00FC00
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x293A995D */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#11,R10
    MVN     R2,R3               /* R2=0x03FF03FF */
    TEQ     R12,R2              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x989C50AD */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#10,R5
    TEQ     R3,#0xFE00FE00
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xCA4F2656 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#10,R10
    MVN     R2,R3               /* R2=0x01FF01FF */
    TEQ     R12,R2              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x6726952A */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#9,R5
    TEQ     R3,#0xFF00FF00      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x32944995 */ 
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#9,R10       
    TEQ     R12,#0x00FF00FF     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end

    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x9A4925C9 */    
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#8,R10
    TEQ     R12,#0x007F007F     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0xCDA39363 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#8,R5
    MVN     R1,R12              /* R1=0xFF80FF80 */
    TEQ     R3,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xE652C931 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#7,R10       
    TEQ     R12,#0x003F003F     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0xF36864D7 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#7,R5
    MVN     R1,R12              /* R1=0xFFC0FFC0 */
    TEQ     R3,R1
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xF975322B */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#6,R10
    TEQ     R12,#0x001F001F     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0xFCD99934 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#6,R5
    MVN     R1,R12              /* R1=0xFFE0FFE0 */
    TEQ     R3,R1
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x7E4DCC7A */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#5,R10
    TEQ     R12,#0x000F000F     /* Check result - Set Z flag */        
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x3F35E64C */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#5,R5
    MVN     R1,R12              /* R1=0xFFF0FFF0 */
    TEQ     R3,R1
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x1F8BF316 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#4,R10
    TEQ     R12,#0x00070007     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x0FCCF992 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#4,R5
    MVN     R1,R12              /* R1=0xFFF8FFF8 */
    TEQ     R3,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0x07DF7CC1 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#3,R10
    TEQ     R12,#0x00030003     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0x83F2BE63 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#3,R5
    MVN     R1,R12              /* R1=0xFFFCFFFC */
    TEQ     R3,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xC1F65F2D */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#2,R10
    TEQ     R12,#0x00010001     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R12,R8,ROR #1    /* R8=0xE0FC2F97 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#2,R5
    MVN     R1,R12              /* R1=0xFFFEFFFE */
    TEQ     R3,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xF07D17C9 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R3,#1,R5
    TEQ     R3,#0xFFFFFFFF      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1     /* R8=0xF83E8BE3 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    SSAT16  R12,#1,R10       
    TEQ     R12,#0x00000000     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end


    /**************************************************************************/
    /* USAT                                                                   */
    /**************************************************************************/
    /* Perform non-saturating operations */
    MVN     R5,#0x80000000      /* R5=0x7FFFFFFF */
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    USAT    R3,#31,R5
    TEQ     R3,R5               /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    LSR     R12,R5,#7
    USAT    R3,#24,R5,ASR #7
    TEQ     R3,R12              /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    LSR     R12,R12,#8
    USAT    R3,#16,R5,ASR #15
    TEQ     R3,R12              /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    USAT    R3,#8,R5,ASR #23
    TEQ     R3,#0x000000FF      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    USAT    R3,#4,R5,ASR #27
    TEQ     R3,#0x0000000F      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    USAT    R3,#2,R5,ASR #29
    TEQ     R3,#0x00000003      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    USAT    R3,#1,R5,ASR #30
    TEQ     R3,#0x00000001      /* Check result - Set Z flag */
    BNE     m33_cst_simdsat_test3_end
    
    USAT    R3,#0,R5,ASR #31
    TEQ     R3,#0               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(1<<30)         /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R3,R8,ROR #1    /* R8=0xFC1F45F1 */
    
    /* Perform saturating operations */
    MOV     R3,#1
    USAT    R12,#31,R3,LSL #31
    TEQ     R12,#0              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    LSR     R10,R5,#7
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#24,R3,LSL #24
    TEQ     R12,R10             /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    LSR     R10,R10,#8
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#16,R3,LSL #16
    TEQ     R12,R10             /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#8,R3,LSL #8
    TEQ     R12,#0x000000FF     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#4,R3,LSL #4
    TEQ     R12,#0x0000000F     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#2,R3,LSL #2
    TEQ     R12,#0x00000003     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#1,R3,LSL #1
    TEQ     R12,#0x00000001     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT    R12,#0,R3
    TEQ     R12,#0x0            /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /**************************************************************************/
    /* USAT16                                                                 */
    /**************************************************************************/
    MOV     R3,#0x55555555
    MOV     R12,#0xAAAAAAAA
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#15,R3
    TEQ     R5,R3               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(1<<30)         /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x5364F84D */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R10,#15,R12
    TEQ     R10,#0x00000000     /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R10,R8,ROR #1    /* R8=0xA9B27C26 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R10,#14,R3
    MVN     R1,#0xC000C000      /* R1=0x3FFF3FFF */
    TEQ     R10,R1              /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R10,R8,ROR #1    /* R8=0x94D87E12 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#13,R3
    MVN     R1,#0xE000E000      /* R1=0x1FFF1FFF */
    TEQ     R5,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x6A6B5F08 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#12,R3
    MVN     R1,#0xF000F000      /* R1=0x0FFF0FFF */
    TEQ     R5,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x4534BF83 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */    
    USAT16  R5,#11,R3
    MVN     R1,#0xF800F800      /* R1,=0x07FF07FF */
    TEQ     R5,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0xAA9967C0 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#10,R3
    MVN     R1,#0xFC00FC00      /* R1=0x03FF03FF */
    TEQ     R5,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x594BB7DF */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#9,R3
    MVN     R1,#0xFE00FE00      /* R1=0x01FF01FF */
    TEQ     R5,R1               /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0xAEA4DDEE */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#8,R3
    TEQ     R5,#0x00FF00FF      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x58516FF6 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#7,R3
    TEQ     R5,#0x007F007F      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x2CA7B87A */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#6,R3
    TEQ     R5,#0x003F003F      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x1692DC7C */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#5,R3
    TEQ     R5,#0x001F001F      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x0B686E5D */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#4,R3
    TEQ     R5,#0x000F000F
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0x85C3373D */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#3,R3
    TEQ     R5,#0x00070007      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0xC2E89BA5 */
                
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#2,R3
    TEQ     R5,#0x00030003      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0xE1774DD5 */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#1,R3
    TEQ     R5,#0x00010001      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R8,R5,R8,ROR #1     /* R8=0xF0BCA6EB */
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    USAT16  R5,#0,R3
    TEQ     R5,#0x00000000      /* Check result - Set Z flag */
    MRS     R4,APSR             /* Load flags */
    TEQ     R4,#(9<<27)         /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test3_end
    
    /* !! Update signature !! */
    ADD     R0,R5,R8,ROR #1     /* R0=0xF85E5375 - Test result is returned in R0 */
    
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_simdsat_test3_end:
    /* Test result is returned in R0, according to the conventions */
    B       m33_cst_test_tail_end
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_SIMDSAT_ENABLE */
    
    CST_FILE_END

