/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests SIMDSAT module Parallel addition and subtraction instructions 
* as well as their decoding. 
* Tests APSR.GE bits logic (APSR.GE bits are explicitly tested for all 
* possible values).
*
* Decoder coverage:
* ----------------
* Thumb (32-bit) DECODER:
*   - SADD16, SHADD16, UADD16, UHADD16
*   - SASX, SHASX, UASX, UHASX
*   - SSAX, SHSAX, USAX, UHSAX
*   - SSUB16, SHSUB16, USUB16, UHSUB16
*   - SADD8, SHADD8, UADD8, UHADD8
*   - SSUB8, SHSUB8, USUB8, UHSUB8
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_SIMDSAT_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_SimdsatTest2

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
   
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_SimdsatTest2" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_SimdsatTest2, function)
M33_Cst_SimdsatTest2:

    PUSH.W  {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* R6 is used as intermediate result */
    MOV     R0,#0x00EF00EF
    MUL     R6,R0,R0    /* Prepare presignature */
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /* SADD16, UADD16                                                         */
    /**************************************************************************/
    MOV     R4,#0x00000000      /* R4= 0x00000000 */
    MOV     R5,#0xAAAAAAAA      /* R5= 0xAAAAAAAA */
    MOV     R10,#0x55555555     /* R10=0x55555555 */
    BIC     R2,R10,#0x00010001  /* R2= 0x55545554 */
  
    SADD16  R3,R5,R5
    CMP     R3,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    UADD16  R12,R5,R5
    CMP     R12,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature here !! */
    SADD16  R6,R6,R3    /* R6=0x13963475*/
    UADD16  R6,R12,R6   /* R6=0x68EA89C9 */
    
    UADD16  R12,R10,R10
    CMP     R12,R5
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge    
    SADD16  R3,R10,R10
    CMP     R3,R5
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SADD16  R6,R6,R12   /* R6=0x13943473 */   
    UADD16  R6,R3,R6    /* R6=0xBE3EDF1D */
    
    LSR     R9,R5,#16           /* R9=0x0000AAAA */
    LSR     R11,R2,#16          /* R9=0x00005554 */
    
    SADD16  R7,R9,R9
    CMP     R7,R11
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000C0000
    BL      m33_cst_simdsat_test2_check_ge
    UADD16  R8,R9,R9
    CMP     R8,R11
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00030000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SADD16  R6,R6,R7    /* R6=0xBE3E3471 */
    UADD16  R6,R8,R6    /* R6=0xBE3E89C5 */
    
    
    /**************************************************************************/
    /* SHADD16, UHADD16                                                       */
    /**************************************************************************/
    /* MOV     R4,#0x00000000      R4= 0x00000000 - See above */
    ORR     R12,R2,#0x00010001  /* R12=0x55555555 */
    ORR     R3,R10,#0x80008000  /* R3= 0xD555D555 */
    
    SHADD16 R10,R5,R4
    CMP     R10,R3
    BNE     m33_cst_test_tail_end
    UHADD16 R11,R5,R4
    CMP     R11,#0x55555555
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHADD16 R6,R10,R6   /* R6=0xC9C9AF8D */ 
    UHADD16 R6,R6,R11   /* R6=0x8F8F8271 */
    
    SHADD16 R10,R12,R12
    CMP     R10,#0x55555555
    BNE     m33_cst_test_tail_end
    UHADD16 R5,R12,R12
    CMP     R5,#0x55555555
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHADD16 R6,R6,R5    /* R6=0xF272EBE3 */ 
    UHADD16 R6,R10,R6   /* R6=0xA3E3A09C */
    
    
    /**************************************************************************/
    /* SHADD8, UHADD8                                                         */
    /**************************************************************************/
    /* MOV     R4,#0x00000000      R4=0x00000000 - See above */
    ORR     R9,R9,R9,LSL #16    /* R9=0xAAAAAAAA */
    ORR     R7,R3,#0x00800080   /* R7=0xD5D5D5D5 */
    
    SHADD8  R3,R9,R4
    CMP     R3,R7
    BNE     m33_cst_test_tail_end
    UHADD8  R2,R9,R4
    CMP     R2,#0x55555555
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHADD8  R6,R3,R6    /* R6=0xBCDCBAB8 */
    UHADD8  R6,R6,R2    /* R6=0x88988786 */
    
    SHADD8  R12,R9,R9
    CMP     R12,#0xAAAAAAAA
    BNE     m33_cst_test_tail_end
    UHADD8  R7,R9,R9
    CMP     R7,#0xAAAAAAAA
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHADD8  R6,R6,R12   /* R6=0x99A19898 */
    UHADD8  R6,R7,R6    /* R6=0xA1A5A1A1 */
    
    
    /**************************************************************************/
    /* SADD8, UADD8                                                           */
    /**************************************************************************/
    /* MOV     R7,#0xAAAAAAAA      R7=0xAAAAAAAA - See above */
    BIC     R2,R2,#0x01010101   /* R2=0x54545454 */
    
    UADD8   R11,R7,R7
    CMP     R11,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    SADD8   R9,R7,R7
    CMP     R9,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SADD8   R6,R6,R11   /* R6=0xF5F9F5F5  */   
    UADD8   R6,R9,R6    /* R6=0x494D4949*/
    
    MOV     R8,#0x000000AA      /* R8=0x000000AA */
    LSR     R7,R2,#24           /* R7=0x00000054 */
    
    SADD8   R9,R8,R8
    CMP     R9,R7
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000E0000
    BL      m33_cst_simdsat_test2_check_ge
    UADD8   R11,R8,R8
    CMP     R11,R7
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00010000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SADD8   R6,R6,R11   /* R6=0x494D499D */   
    UADD8   R6,R9,R6    /* R6=0x494D49F1 */
    
    LSL     R3,R8,#16           /* R3=0x00AA0000 */
    LSL     R8,R7,#16           /* R8=0x00540000 */
    
    SADD8   R9,R3,R3
    CMP     R9,R8
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000B0000
    BL      m33_cst_simdsat_test2_check_ge
    UADD8   R11,R3,R3
    CMP     R11,R8
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00040000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SADD8   R6,R6,R11   /* R6=0x49A149F1 */   
    UADD8   R6,R9,R6    /* R6=0x49F549F1 */
    
    ORR     R2,R3,R3,LSR #8     /* R2=0x00AAAA00 */
    ORR     R8,R8,R8,LSR #8     /* R8=0x00545400 */
    
    SADD8   R11,R2,R2
    CMP     R11,R8
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00090000
    BL      m33_cst_simdsat_test2_check_ge
    UADD8   R9,R2,R2
    CMP     R9,R8
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00060000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SADD8   R6,R6,R11   /* R6=0x49499DF1 */   
    UADD8   R6,R9,R6    /* R6=0x499DF1F1 */
    
    
    /**************************************************************************/
    /* SASX, UASX                                                             */
    /**************************************************************************/
    MOV     R11,#0x55555555      /* R11=0x55555555 */   
    ADD     R10,R11,R11,LSL #16
    ADD     R10,R10,#0x00010000  /* R10=0xAAAB5555 */
    ADD     R9,R11,R11, LSR #14  /* R9= 0x5556AAAA */
    
    SASX    R7,R11,R10
    CMP     R7,#0xAAAAAAAA
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    UASX    R2,R11,R9
    CMP     R2,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SASX    R6,R6,R7    /* R6=0xF4474747 */   
    UASX    R6,R2,R6    /* R6=0x47460BB8 */
    
    ROR     R11,R9,#16          /* R11=0xAAAA5556 */
    MOV     R9,#0xAAAAAAAA      /* R9= 0xAAAAAAAA */
    
    SASX    R8,R9,R11
    CMP     R8,#0x00000000
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    UASX    R3,R4,R10
    CMP     R3,#0x55555555
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SASX    R6,R6,R8    /* R6=0x47460BB8 */   
    UASX    R6,R3,R6    /* R6=0x610D0E0F */
    
    /* MOV  R4,#0x00000000         R4=0x00000000 - See above */
    MOV     R9,#0x00010001      /* R9=0x00010001 */
    
    SASX    R7,R4,R9
    CMP     R7,R2,LSR #15       /* R7=0x0001FFFF */
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000C0000
    BL      m33_cst_simdsat_test2_check_ge
    UASX    R8,R9,R9
    CMP     R8,#0x00020000
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00030000
    BL      m33_cst_simdsat_test2_check_ge 
    
    /* !! Update Signature !! */
    SASX    R6,R6,R7    /* R6=0x610C0E0E */   
    UASX    R6,R8,R6    /* R6=0x0E109EF4 */ 
    
    
    /**************************************************************************/
    /* SHASX, UHASX                                                           */
    /**************************************************************************/
    /* MOV     R2,0xFFFFFFFF       R2=0xFFFFFFFF - See above */
    MOV     R8,#0x55555555      /* R8=0x55555555 */
    ROR     R7,R11,#16          /* R7=0x5556AAAA */
    
    SHASX   R0,R8,R7
    CMP     R0,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    UHASX   R5,R8,R7
    CMP     R5,R2,LSR #1        /* R5=0x7FFFFFFF */
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHASX   R6,R6,R0    /* R6=0x0707CF7A */   
    UHASX   R6,R1,R6    /* R6=0xA7BC7C7C */
    
    ROR     R8,R7,#16           /* R8=0xAAAA5556 */
    MOV     R7,#0xAAAAAAAA      /* R7=0xAAAAAAAA */
    
    SHASX   R3,R7,R8
    CMP     R3,#0x00000000
    BNE     m33_cst_test_tail_end
    UHASX   R5,R7,R8
    CMP     R5,#0x80000000
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHASX   R6,R6,R3    /* R6=0xD3DE3E3E */   
    UHASX   R6,R5,R6    /* R6=0x5F1F9611 */
    
    /* MOV     R4,#0x00000000      R4=0x00000000 - See above */
    LSR     R2,R2,#16           /* R2=0x0000FFFF */
    MOV     R7,#0x00030003
       
    SHASX   R10,R4,R7           
    CMP     R10,R2,LSL #1       /* R10=0x0001FFFE */   
    BNE     m33_cst_test_tail_end
    UHASX   R9,R4,R7
    CMP     R9,R2,LSL #1        /* R9=0x0001FFFE */
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHASX   R6,R6,R10   /* R6=0xDF8EF307 */   
    UHASX   R6,R9,R6    /* R6=0x79841038 */
    
    
    /**************************************************************************/
    /* SSAX                                                                   */
    /**************************************************************************/
    MOV     R12,#0x55555555     /* R12=0x55555555 */
    MOV     R3,R8               /* R3= 0xAAAA5556 */
    
    SSAX    R10,R12,R3
    CMP     R10,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SSAX    R6,R10,R6   /* R6=0xEFC77983 */   
    
    ROR     R12,R3,#16          /* R12=0x5556AAAA */
    MOV     R3,#0xAAAAAAAA      /* R3= 0xAAAAAAAA */
    
    SSAX    R5,R3,R12
    CMP     R5,#0
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SSAX    R6,R5,R6    /* R6=0x867DEFC7 */   
    
    MOV     R3,#0x00000005
    RSB     R2,R3,#0
    ORR     R2,R3,R2,LSL #16    /* R2=0xFFFB0005 */
    ORR     R3,R3,R3,LSL #16    /* R3=0x00050005 */
    
    SSAX    R5,R4,R3
    CMP     R5,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00030000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    ADD     R6,R6,#5            /* R6=0x8678EFCC */
    SSAX    R6,R6,R5            /* R6=0x8678EFC7 */
    
    
    /**************************************************************************/
    /* USAX                                                                   */
    /**************************************************************************/
    MOV     R12,#0x55555555     /* R12=0x55555555 */
    MOV     R3,R8               /* R3 =0xAAAA5556 */
    
    USAX    R1,R12,R3           /* R1 =0xFFFFFFFF GE=0 */
    /* MOV  R10,#0x00000000        R10=0xFFFFFFFF - See above */
    CMP     R1,R10
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    USAX    R6,R3,R6            /* R6 =0xBAE3DBCE */
    
    MVN     R3,R12              /* R3 =0xAAAAAAAA */
    ROR     R12,R8,#16          /* R12=0x5556AAAA */
    
    USAX    R5,R3,R12           /* R5 =0x00000000 GE=F */
    /* MOV  R4,#0x00000000         R4 =0x00000000 - See above */
    CMP     R5,R4
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    USAX    R6,R12,R6           /* R6=0x7988658D */
    
    MOV     R2,#0x0000FFFF      /* R2=0x0000FFFF */
    EOR     R7,R3,R2            /* R7=0xAAAA5555 */
    MVN     R3,R3               /* R3=0x55555555 */
    
    USAX    R3,R3,R7            /* R3=0x0000FFFF GE=C */
    CMP     R3,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000C0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    ADD     R6,R6,#5            /* R6=0x79886592 */
    USAX    R6,R11,R6           /* R6=0x4518CEDE */
    
    MVN     R7,R7               /* R7=0x5555AAAA */
    AND     R2,R11,R2           /* R2=0x00005556 */
    ROR     R2,R2,#16           /* R2=0x55560000 */
    MVN     R5,R3               /* R5=0xFFFF0000 */
    USAX    R2,R2,R2            /* R2=0x55565556 GE=C*/
    BL      m33_cst_simdsat_test2_check_ge
    
    USAX    R9,R7,R2            /* R9=0xFFFF0000 GE=3 */
    CMP     R9,R5
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00030000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    USAX    R6,R12,R6           /* R6=0x8678EFC2 */
    
    
    /**************************************************************************/
    /* SHSAX, UHSAX                                                           */
    /**************************************************************************/
    MOV     R10,#0x55555555     /* R10=0x55555555 */
    ROR     R5,R12,#16          /* R5= 0xAAAA5556 */
    MOV     R2,#0xFFFFFFFF      /* R2= 0xFFFFFFFF */
    BIC     R7,R2,#0x00008000   /* R7= 0xFFFF7FFF */
    
    SHSAX   R3,R10,R5
    CMP     R3,R2
    BNE     m33_cst_test_tail_end
    UHSAX   R12,R10,R5
    CMP     R12,R7
    BNE     m33_cst_test_tail_end
    
     /* !! Update Signature !! */
    SHSAX   R6,R6,R3    /* R6=0xC33CF7E0 */   
    UHSAX   R6,R12,R6   /* R6=0x40FA19D */
    
    ROR     R10,R5,#16          /* R10=0x5556AAAA */
    MOV     R5,#0xAAAAAAAA      /* R5= 0xAAAAAAAA */        
    
    SHSAX   R12,R5,R10
    CMP     R12,#0x00000000
    BNE     m33_cst_test_tail_end
    UHSAX   R3,R5,R10
    CMP     R3,#0x00008000
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSAX   R6,R6,R12   /* R6=0x0207D0CE */   
    UHSAX   R6,R3,R6    /* R6=0x97994103 */
    
    MOV     R2,#0x00000002
    MVN     R3,R2
    ORR     R2,R2,R3,LSL#16     /* R2=0xFFFD0002 */
    MOV     R5,#0x00050005      /* R5=0x00050005 */
    
    SHSAX   R3,R4,R5
    CMP     R3,R2
    BNE     m33_cst_test_tail_end
    UHSAX   R12,R4,R5
    CMP     R12,R2
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSAX   R6,R6,R3    /* R6=0xCBCB2080 */   
    UHSAX   R6,R12,R6   /* R6=0x6FBE65E6 */
    
    
    /**************************************************************************/
    /* SSUB16, USUB16                                                         */
    /**************************************************************************/
    /* MOV     R4,#0x00000000      R4=0x00000000 - See above */
    MOV     R8,#0x55555555
    MOV     R7,#0xAAAAAAAA
    ADD     R8,R8,#0x00010001   /* R8=0x55565556 */
    ADD     R7,R7,#0x00010001   /* R7=0xAAABAAAB */
    
    USUB16  R10,R4,R8
    CMP     R10,#0xAAAAAAAA
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    SSUB16  R5, R4,R7
    CMP     R5,#0x55555555
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    USUB16  R6,R6,R10   /* R6=0xC514BB3C */   
    SSUB16  R6,R5,R6    /* R6=0x90419A19 */
    
    USUB16  R2,R4,R5
    CMP     R2,R7
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    SSUB16  R3,R4,R10
    CMP     R3,R8
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000F0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    USUB16  R6,R6,R2    /* R6=0xE596EF6E */   
    SSUB16  R6,R3,R6    /* R6=0x6FC065E8 */
    
    SUB     R8,R10,R5,LSL #16    /* R8=0x5555AAAA */        
    ADD     R2,R11,#0x00010000   /* R2=0xAAAB5556 */
    
    SSUB16  R5,R4,R8
    CMP     R5,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00030000
    BL      m33_cst_simdsat_test2_check_ge
    USUB16  R10,R4,R8
    CMP     R10,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SSUB16  R6,R6,R5    /* R6=0xC5151092 */   
    USUB16  R6,R10,R6   /* R6=0xE59644C4 */
    
    
    /**************************************************************************/
    /* SHSUB16, UHSUB16                                                       */
    /**************************************************************************/
    /* MOV     R4,#0x00000000      R4= 0x00000000 - See above */
    MOV     R11,#0x55555555     /* R11=0x55555555 */
    MOV     R9,#0xAAAAAAAA      /* R9= 0xAAAAAAAA */
    
    SHSUB16 R10,R11,R11
    CMP     R10,R4
    BNE     m33_cst_test_tail_end
    UHSUB16 R5,R11,R11
    CMP     R5,R4
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSUB16 R6,R6,R10   /* R6=0xF2CB2262 */   
    UHSUB16 R6,R5,R6    /* R6=0x869AEECF */
           
    MOV     R11,#0x00010001     
    
    SHSUB16 R5,R4,R11
    CMP     R5,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    UHSUB16 R10,R4,R11
    CMP     R10,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSUB16 R6,R6,R5    /* R6=0xC34DF768 */   
    UHSUB16 R6,R10,R6   /* R6=0x1E59044B */
    
    SHSUB16 R5,R9,R9
    CMP     R5,R4
    BNE     m33_cst_test_tail_end
    UHSUB16 R10,R9,R9
    CMP     R10,R4
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSUB16 R6,R6,R5    /* R6=0x0F2C0225 */   
    UHSUB16 R6,R10,R6   /* R6=0xF86AFEED */
    
    MOV     R11,R8              /* R11=0x5555AAAA */
    ORR     R2,R11,#0x80000000
    ORR     R2,R2,#0x00000001   /* R2=0xD555AAAB */   
    BIC     R7,R2,#0x00008000   /* R7=0xD5552AAB */
    
    UHSUB16 R10,R4,R11          
    CMP     R10,R2
    BNE     m33_cst_test_tail_end
    SHSUB16 R5,R4,R11
    CMP     R5,R7
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    UHSUB16 R6,R6,R5    /* R6=0x118A6A21 */   
    SHSUB16 R6,R10,R6   /* R6=0xE1E5A045 */
    
    
    /**************************************************************************/
    /* SHSUB8, UHSUB8                                                         */
    /**************************************************************************/
    /* MOV     R4,#0x00000000      R4=0x00000000 - See above */
    MOV     R8,#0x55555555      /* R8=0x55555555 */
    MOV     R7,#0xAAAAAAAA      /* R7=0xAAAAAAAA */
    
    SHSUB8  R12,R8,R8
    CMP     R12,#0x00000000
    BNE     m33_cst_test_tail_end
    UHSUB8  R3,R8,R8
    CMP     R3,#0x00000000
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSUB16 R6,R6,R12   /* R6=0xF0F2D022 */   
    UHSUB16 R6,R3,R6    /* R6=0x878797EF */
           
    /* !! Update Signature !! */
    MOV     R8,#0x01010101      /* R8=0x01010101 */
    MOV     R3,#0xFFFFFFFF      /* R3=0xFFFFFFFF */
    
    SHSUB8  R12,R4,R8
    CMP     R12,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    UHSUB8  R3,R4,R8
    CMP     R3,#0xFFFFFFFF
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSUB16 R6,R6,R3    /* R6=0xC3C4CBF8  */   
    UHSUB16 R6,R12,R6   /* R6=0x1E1D1A03 */
    
    SHSUB8  R3,R7,R7
    CMP     R3,#0x00000000
    BNE     m33_cst_test_tail_end
    UHSUB8  R12,R7,R7
    CMP     R12,#0x00000000
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    SHSUB16 R6,R6,R3    /* R6=0x0F0E0D01 */   
    UHSUB16 R6,R12,R6   /* R6=0xF879F97F */
    
    EOR     R8,R9,#0xFF00FF00   /* R8= 0x55AA55AA */
    ORR     R2,R8,#0x80008000
    ORR     R2,R2,#0x00010001   /* R2= 0xD5ABD5AB */
    BIC     R11,R2,#0x00800080  /* R11=0xD52BD52B */
    
    UHSUB8  R12,R4,R8
    CMP     R12,R2
    BNE     m33_cst_test_tail_end
    SHSUB8  R3,R4,R8
    CMP     R3,R11
    BNE     m33_cst_test_tail_end
    
    /* !! Update Signature !! */
    UHSUB8  R6,R6,R12   /* R6=0x11E712EA */   
    SHSUB8  R6,R3,R6    /* R6=0xE222E120 */
    
    
    /**************************************************************************/
    /* SSUB8, USUB8                                                           */
    /**************************************************************************/
    /* MOV     R4,#0x00000000      R4=0x00000000 - See above */
    ADD     R3,R8,#0x01010101
    ROR     R3,R3,#8            /* R3=0xAB56AB56*/
    ROR     R7,R8,#8            /* R7=0xAA55AA55 */
    ORR     R2,R8,#0x00010001   /* R3=0x55AB55AB */
    
    SSUB8   R5,R4,R8
    CMP     R5,R3
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00050000
    BL      m33_cst_simdsat_test2_check_ge
    USUB8   R10,R7,R8
    CMP     R10,R2
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000A0000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SSUB8   R6,R6,R5     /* R6=0x37CC36CA */   
    USUB8   R6,R10,R6    /* R6=0x1EDF1FE1 */
    
    AND     R8,R8,#0x00FFFFFF
    AND     R3,R5,#0x00FFFFFF 
    
    SSUB8   R10,R4,R8
    CMP     R10,R3
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x000D0000
    BL      m33_cst_simdsat_test2_check_ge
    USUB8   R5,R4,R8
    CMP     R5,R3
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00080000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SSUB8   R6,R6,R10   /* R6=0x1E89748B */   
    USUB8   R6,R5,R6    /* R6=0xE2CD37CB */
    
    ORR     R10,R10,R10,LSL #24 /* R10=0x5656AB56 */
    ORR     R8,R8,R8,LSL #24    /* R8= 0xAAAA55AA */
    LSL     R3,R3,#24           /* R3= 0x56000000 */
    
    SSUB8   R5,R4,R10
    CMP     R5,R8
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00020000
    BL      m33_cst_simdsat_test2_check_ge 
    USUB8   R10,R4,R3
    CMP     R10,#0xAA000000
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00070000
    BL      m33_cst_simdsat_test2_check_ge 
    
    /* !! Update Signature !! */
    SSUB8  R6,R6,R5     /* R6=0x3823E221 */   
    USUB8  R6,R10,R6    /* R6=0x72DD1EDF */
    
    AND     R12,R12,#0x00FF00FF /* R12=0x00AB00AB */
    ORR     R11,R12,R12,LSL #8  /* R11=0xABABABAB */
    
    SSUB8   R10,R7,R12
    CMP     R10,#0xAAAAAAAA
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00050000
    BL      m33_cst_simdsat_test2_check_ge 
    USUB8   R5,R4,R11           
    CMP     R5,#0x55555555
    BNE     m33_cst_test_tail_end
    MOV     R0,#0x00000000
    BL      m33_cst_simdsat_test2_check_ge
    
    /* !! Update Signature !! */
    SSUB8  R6,R6,R10   /* R6=0xC8337435 */   
    USUB8  R0,R5,R6    /* R0=0x8D22E120 - Test result is returned in R0 */
       
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_simdsat_test1_end:
    /* Test result is returned in R0, according to the conventions */
    B       m33_cst_test_tail_end
    
    
    /*------------------------------------------------------------------------*/
    /* Subroutine to test APSR.GE bits                                        */
    /*------------------------------------------------------------------------*/
m33_cst_simdsat_test2_check_ge:
    /* Expected APSR[GE] content passed in R0 */
    MRS     R1,APSR             /* Load all flags */
    BIC     R1,R1,#0xF8000000   /* Clear nzcvq flags */
    CMP     R0,R1
    BNE     m33_cst_test_tail_end
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG
    
#endif  /* CORTST_M33_SIMDSAT_ENABLE */

    CST_FILE_END

