/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Covers LSU operation type:
*   - load/store double
*
* Overall coverage:
* -----------------
* Covers LDRD, STRD instructions as well as logic processing its
* '<Rt>','<Rt2>','<Rn>' and '#<imm8>' as well as <data_to_store> 
* and <data_to_load>.
*
* Decoder coverage:
* ----------------
* Thumb (32-bit) DECODER:
*  - LDRD (immediate)
*  - STRD (immediate)
*  - LDRD (literal)
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_LOADSTORE_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_LoadstoreTest3

    /* Symbols defined outside but used within current module */
    CST_EXTERN CST_RAM_TARGET0
    CST_EXTERN CST_RAM_TARGET1
    CST_EXTERN m33_cst_test_tail_end

    CST_EXTERN VAL1
    CST_EXTERN VAL2
    CST_EXTERN VAL3
    CST_EXTERN VAL4
    CST_EXTERN VAL5
    CST_EXTERN VAL6
    CST_EXTERN VAL7
    CST_EXTERN VAL8

    CST_SET(PRESIGNATURE, 0x91AFC742)
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_LoadstoreTest3" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_LoadstoreTest3, function)
M33_Cst_LoadstoreTest3:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR.W   R1,=PRESIGNATURE    /* Load PRESIGNATURE */ 
    
  
    /*------------------------------------------------------------------------*/
    /* Dual issue test routine - start                                        */
    /*------------------------------------------------------------------------*/
    /***************************************************************************
    * Instructions:
    *   - STRD (immediate) - Dual issue
    *   - LDRD (immediate) - Dual issue
    *
    *   Note: Encoding T1 (32-bit)
    ***************************************************************************/
    /* Initialize registers and clear target memory */
    LDR.W   R5,  =CST_RAM_TARGET0
    LDR.W   R10, =CST_RAM_TARGET1
    
    MOV     R0, R5
    BL      m33_cst_loadstore_test3_clear_target_memory
    MOV     R0, R10
    BL      m33_cst_loadstore_test3_clear_target_memory
    
    MRS     R0, PRIMASK     /* Save PRIMASK - Do not overwrite R0 in test! */
    
    /* The following sequence is equivalent of:
     MOV     R11, R5
     MOV     R12, R10
     PUSH   {R1} */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STRD    R5,R1,[R13,#-8]!       /* Slot0 */    
    STRD    R5,R10,[R13,#-8]!      /* Slot1 */
    LDRD    R12,R11,[R13],#4       /* Slot0 */       
    LDRD    R12,R11,[R13],#8       /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test3_init

    /* Store R1, R2, R6, R7, R4, R3, R9, R8 to RAM0 (Slot0) */
    /* Store R3, R4, R8, R9, R2, R1, R7, R6 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STRD    R1, R2, [R5], #0x154    /* Slot0 */
    STRD    R3, R4, [R10],#0x2A8    /* Slot1 */
    STRD    R6, R7, [R5,  #-0x14C]  /* Slot0 */
    STRD    R8, R9, [R10, #-0x2A0]  /* Slot1 */
    STRD    R4, R3, [R5,  #-0x144]! /* Slot0 */
    STRD    R2, R1, [R10, #-0x298]! /* Slot1 */
    STRD    R9, R8, [R5,  #0x8]     /* Slot0 */
    STRD    R7, R6, [R10, #0x8]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* We need to check RAM0 address */
    SUB     R5, R5, #0x10
    CMP     R5, R11
    BNE     m33_cst_loadstore_test3_failed

    /* We need to check RAM1 address */
    SUB     R10, R10, #0x10
    CMP     R10, R12
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to load first half of RAM0&RAM1 data */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRD    R2, R1, [R5], #0x154    /* Slot0 */
    LDRD    R4, R3, [R10],#0x2A8    /* Slot1 */
    LDRD    R7, R6, [R5,  #-0x14C]  /* Slot0 */
    LDRD    R9, R8, [R10, #-0x2A0]  /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* We need to check data */
    CMP     R1,#0xAAAAAAAA
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2,#0x55555555
    BNE     m33_cst_loadstore_test3_failed
    CMP     R3,#0x33333333
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4,#0xCCCCCCCC
    BNE     m33_cst_loadstore_test3_failed
    CMP     R6,#0x66666666
    BNE     m33_cst_loadstore_test3_failed
    CMP     R7,#0x99999999
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8,#0xEEEEEEEE
    BNE     m33_cst_loadstore_test3_failed
    CMP     R9,#0x77777777
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to load second half of RAM0&RAM1 data */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRD    R4, R3, [R5,  #-0x144]! /* Slot0 */
    LDRD    R2, R1, [R10, #-0x298]! /* Slot1 */
    LDRD    R9, R8, [R5,  #0x8]     /* Slot0 */
    LDRD    R7, R6, [R10, #0x8]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* We need to check data */
    CMP     R2,#0xAAAAAAAA
    BNE     m33_cst_loadstore_test3_failed
    CMP     R1,#0x55555555
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4,#0x33333333
    BNE     m33_cst_loadstore_test3_failed
    CMP     R3,#0xCCCCCCCC
    BNE     m33_cst_loadstore_test3_failed
    CMP     R7,#0x66666666
    BNE     m33_cst_loadstore_test3_failed
    CMP     R6,#0x99999999
    BNE     m33_cst_loadstore_test3_failed
    CMP     R9,#0xEEEEEEEE
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8,#0x77777777
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM0 address */
    SUB     R5, R5, #0x10
    CMP     R5, R11
    BNE     m33_cst_loadstore_test3_failed

    /* We need to check RAM1 address */
    SUB     R10, R10, #0x10
    CMP     R10, R12
    BNE     m33_cst_loadstore_test3_failed
    
    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#2    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    
    /* Store R4, R3, R9, R8, R1, R2, R6, R7 to RAM1 (Slot0) */
    /* Store R2, R1, R7, R6, R3, R4, R8, R9 to RAM0 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STRD    R4, R3, [R10],#0x2A8    /* Slot0 */
    STRD    R2, R1, [R5], #0x154    /* Slot1 */
    STRD    R9, R8, [R10, #-0x2A0]  /* Slot0 */
    STRD    R7, R6, [R5,  #-0x14C]  /* Slot1 */
    STRD    R1, R2, [R10, #-0x298]! /* Slot0 */
    STRD    R3, R4, [R5,  #-0x144]! /* Slot1 */
    STRD    R6, R7, [R10, #0x8]     /* Slot0 */
    STRD    R8, R9, [R5,  #0x8]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* We need to check RAM0 address */
    SUB     R5, R5, #0x10
    CMP     R5, R11
    BNE     m33_cst_loadstore_test3_failed

    /* We need to check RAM1 address */
    SUB     R10, R10, #0x10
    CMP     R10, R12
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to load first half of RAM0&RAM1 data */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRD    R3, R4, [R10],#0x2A8    /* Slot0 */
    LDRD    R1, R2, [R5], #0x154    /* Slot1 */
    LDRD    R8, R9, [R10, #-0x2A0]  /* Slot0 */
    LDRD    R6, R7, [R5,  #-0x14C]  /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    /* We need to check data */
    CMP     R1,#0xAAAAAAAA
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2,#0x55555555
    BNE     m33_cst_loadstore_test3_failed
    CMP     R3,#0x33333333
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4,#0xCCCCCCCC
    BNE     m33_cst_loadstore_test3_failed
    CMP     R6,#0x66666666
    BNE     m33_cst_loadstore_test3_failed
    CMP     R7,#0x99999999
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8,#0xEEEEEEEE
    BNE     m33_cst_loadstore_test3_failed
    CMP     R9,#0x77777777
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to load second half of RAM0&RAM1 data */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRD    R1, R2, [R10, #-0x298]! /* Slot0 */
    LDRD    R3, R4, [R5,  #-0x144]! /* Slot1 */
    LDRD    R6, R7, [R10, #0x8]     /* Slot0 */
    LDRD    R8, R9, [R5,  #0x8]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* We need to check data */
    CMP     R2,#0xAAAAAAAA
    BNE     m33_cst_loadstore_test3_failed
    CMP     R1,#0x55555555
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4,#0x33333333
    BNE     m33_cst_loadstore_test3_failed
    CMP     R3,#0xCCCCCCCC
    BNE     m33_cst_loadstore_test3_failed
    CMP     R7,#0x66666666
    BNE     m33_cst_loadstore_test3_failed
    CMP     R6,#0x99999999
    BNE     m33_cst_loadstore_test3_failed
    CMP     R9,#0xEEEEEEEE
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8,#0x77777777
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM0 address */
    SUB     R5, R5, #0x10
    CMP     R5, R11
    BNE     m33_cst_loadstore_test3_failed

    /* We need to check RAM1 address */
    SUB     R10, R10, #0x10
    CMP     R10, R12
    BNE     m33_cst_loadstore_test3_failed
    
    
    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#2    /* !! Update Signature !! */
    STR     R14,[SP,#0]

    /***************************************************************************
    * Instructions:
    *   - LDRD / STRD pairs - Dual issue
	*
    *   Note: Encoding T1 (32-bit)
    ***************************************************************************/
    /* Store R3, R6, R9, R7 to RAM0 */
    STRD    R3, R6, [R11]
    STRD    R9, R7, [R11, #8]
    DSB
    
    /* Load from RAM0 to R1, R2, R4, R8 (Slot0) */
    /* Store R6, R9, R3, R7 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE    
    /*------------------------------------------------------------------------*/
    LDRD    R1, R2, [R11], #0x154   /* Slot0 */
    STRD    R6, R9, [R12], #0x330   /* Slot1 */
    LDRD    R4, R8, [R11,  #-0x14C] /* Slot0 */
    STRD    R3, R7, [R12,  #-0x328] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* We need to check RAM0 address */
    SUB     R11, R11, #0x154
    CMP     R11, R5
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM1 address */
    SUB     R12, R12, #0x330
    CMP     R12, R10
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM0 data */
    CMP     R1, R3
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2, R6
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4, R9
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8, R7
    BNE     m33_cst_loadstore_test3_failed
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test3_init
    
    /* Load from RAM1 to R2, R8, R1, R4 (Slot0) */
    /* Store R9, R3, R7, R6 to RAM0 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRD    R2, R8, [R12], #0x2A8   /* Slot0 */
    STRD    R9, R3, [R11], #0x0F0   /* Slot1 */
    LDRD    R1, R4, [R12,  #-0x2A0] /* Slot0 */
    STRD    R7, R6, [R11,  #-0x0E8] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* We need to check RAM0 address */
    SUB     R11, R11, #0x0F0
    CMP     R11, R5
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM1 address */
    SUB     R12, R12, #0x2A8
    CMP     R12, R10
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM1 data */
    CMP     R1, R3
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2, R6
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4, R7
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8, R9
    BNE     m33_cst_loadstore_test3_failed
    
    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#2    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test3_init

    /* Store R9, R3, R7, R6 to RAM1 (Slot0) */
    /* Load from RAM0 to R1, R2, R4, R8 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STRD    R9, R3, [R12], #0x330   /* Slot0 */
    LDRD    R1, R2, [R11], #0x154   /* Slot1 */
    STRD    R7, R6, [R12,  #-0x328] /* Slot0 */
    LDRD    R4, R8, [R11,  #-0x14C] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* We need to check RAM0 address */
    SUB     R11, R11, #0x154
    CMP     R11, R5
    BNE     m33_cst_loadstore_test3_failed

    /* We need to check RAM1 address */
    SUB     R12, R12, #0x330
    CMP     R12, R10
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM0 data */
    CMP     R1, R9
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2, R3
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4, R7
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8, R6
    BNE     m33_cst_loadstore_test3_failed
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test3_init
    
    /* Store R7, R9, R6, R3 to RAM0 (Slot0) */
    /* Load from RAM1 to R2, R1, R8, R4 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STRD    R7, R9, [R11], #0x0F0   /* Slot0 */
    LDRD    R2, R1, [R12], #0x2A8   /* Slot1 */
    STRD    R6, R3, [R11,  #-0x0E8] /* Slot0 */
    LDRD    R8, R4, [R12,  #-0x2A0] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R0     /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* We need to check RAM0 address */
    SUB     R11, R11, #0x0F0
    CMP     R11, R5
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM1 address */
    SUB     R12, R12, #0x2A8
    CMP     R12, R10
    BNE     m33_cst_loadstore_test3_failed
    
    /* We need to check RAM1 data */
    CMP     R1, R3
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2, R9
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4, R6
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8, R7
    BNE     m33_cst_loadstore_test3_failed
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test3_init
    
    /* Load from RAM0 to R1, R2, R4, R8 */
    LDRD    R1, R2, [R11]
    LDRD    R4, R8, [R11, #8]
    
    /* We need to check RAM0 data */
    CMP     R1, R7
    BNE     m33_cst_loadstore_test3_failed
    CMP     R2, R9
    BNE     m33_cst_loadstore_test3_failed
    CMP     R4, R6
    BNE     m33_cst_loadstore_test3_failed
    CMP     R8, R3
    BNE     m33_cst_loadstore_test3_failed  

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    DSB
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
m33_cst_loadstore_test3_failed:
    POP     {R1}
    /* Test result is returned in R0, according to the conventions */
    MVN     R0,R1
m33_cst_loadstore_test3_end:
    B       m33_cst_test_tail_end

    /* Data to be loaded by LDRD (literal) */
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_loadstore_test3_data3:
    CST_WORD(VAL5)
    CST_WORD(VAL6)
    
    /* Data to be loaded by LDRD (literal) */
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_loadstore_test3_data1:
    CST_WORD(VAL1)
    CST_WORD(VAL2)
    
    /**************************************************************************
    * Initialize {R1-R4, R6-R9} to default test values
    *
    * Instructions:
    *   - LDRD (literal)
    **************************************************************************/
    CST_THUMB2
m33_cst_loadstore_test3_init:
    LDRD    R1,R2,m33_cst_loadstore_test3_data1     /* PC value (-)offset */
    LDRD    R3,R4,m33_cst_loadstore_test3_data2     /* PC value (+)offset */
    LDRD    R6,R7,m33_cst_loadstore_test3_data3     /* PC value (-)offset */
    LDRD    R8,R9,m33_cst_loadstore_test3_data4     /* PC value (+)offset */
    
    BX      LR

    /*------------------------------------------------------------------------*/
    /* Clear 8 words starting from address in R0                              */
    /*------------------------------------------------------------------------*/
m33_cst_loadstore_test3_clear_target_memory:
    EORS    R2,R2   /* Clear R2 */
    
    STR     R2,[R0]
    STR     R2,[R0,#4]
    STR     R2,[R0,#8]
    STR     R2,[R0,#12]
    STR     R2,[R0,#16]
    STR     R2,[R0,#20]
    STR     R2,[R0,#24]
    STR     R2,[R0,#28]
    
    BX      LR

    /* Data to be loaded by LDRD (literal) */
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_loadstore_test3_data2:
    CST_WORD(VAL3)
    CST_WORD(VAL4)
    
    /* Data to be loaded by LDRD (literal) */
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_loadstore_test3_data4:
    CST_WORD(VAL7)
    CST_WORD(VAL8)
    
    CST_ALIGN_BYTES_4
    CST_LTORG  /* Marks the current location for dumping psuedoinstruction pools (literal pool)
                   (containing numeric values for used symbolic names used within LDR instruction).
                   It is 4-byte aligned, as 2-byte alignment causes incorrect work. */

#endif  /* CORTST_M33_LOADSTORE_ENABLE */
    
    CST_FILE_END

