/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests triggering of UsageFaults.
*
******************************************************************************/

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_ExcUsageFaultTest

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_store_registers_content
    CST_EXTERN m33_cst_set_cst_interrupt_vector_table
    CST_EXTERN m33_cst_set_user_interrupt_vector_table
    CST_EXTERN m33_cst_restore_registers_content
    CST_EXTERN m33_cst_test_tail_end
    CST_EXTERN m33_cst_ISR_address
    CST_EXTERN m33_cst_scb_registers_dump
    CST_EXTERN m33_cst_exception_timeout
    
    CST_SET(PRESIGNATURE,0x7ECAE428)
    
    /*------------------------------------------------------------------------*/    
    CST_SECTION_EXEC(mcal_text) 
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_ExcNmiTest" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_ExcUsageFaultTest, function)  
M33_Cst_ExcUsageFaultTest:
    
    PUSH    {R4-R12,R14}

    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R5,=PRESIGNATURE
    
    /*------------------------------------------------------------------------*/
    /* Store register content                                                 */
    /*------------------------------------------------------------------------*/
    /* !! Don't use R6, R7, R8, R9 for any other purpose until CONTROL, PRIMASK,
          FAULTMASK and BASEPRI are restored !! */
    BL      m33_cst_store_registers_content

    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    LDR     R4,=m33_cst_exc_usage_fault_test_ISR1
    ORR     R4,R4,#1        /* Set bit [0] as this address will be used within 
                               BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* Before vector table is changed to the CST-own one, set R2 to
       to the expected ISR number and R0 to the expected ISR address.
       
       Content of R0 and R2 will allow determining whether interrupt was 
       triggered by CST library or by alien SW.

    !! Don't use R0, R2 for any other purpose until vector table is changed 
       to a user one. !! */       
    MOV    R2,#0x6      /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 0x6 */
    LDR    R0,=m33_cst_exc_usage_fault_test_ISR1_addr
    BIC    R0,R0,#1     /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
                           
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    
    /* Enable UsageFault exception */
    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]             /* Load SHCSR register */
    ORR     R4,R4,#(1<<18)      /* Set SHCSR[USGFAULTENA] bit */
    STR     R4,[R3]             /* Modify SHCSR register */

    CPSIE   i   /* Clear PRIMASK   */
    CPSIE   f   /* Clear FAULTMASK */
   
m33_cst_exc_usage_fault_test_ISR1_addr:
    CST_QUA_FAULT_INJECTION(CST_ERROR_INJECT_USAGE_FAULT)
    UDF     #0  /* Undefined instruction -> Generate exception !! */
m33_cst_exc_usage_fault_timeout_addr:
    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_usage_fault_test_ISR5_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

m33_cst_exc_usage_fault_test_ISR1_ret_addr:
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /*------------------------------------------------------------------------*/
    /* Restore registers & Enable external interrupts                         */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_user_interrupt_vector_table
    #endif
   
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_usage_fault_test_ISR2
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    MOV     R2, #0x6    /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 6 */
    ADR.W   R0, m33_cst_exc_usage_fault_test_ISR2_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
    
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    #endif
    
    /* Enable UsageFault exception */
    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]         /* Load SHCSR register */
    ORR     R4,R4,#(1<<18)  /* Set SHCSR[USGFAULTENA] bit */
    STR     R4,[R3]         /* Modify SHCSR register */
    
    /* Enable Division by zero UsageFault exception */
    LDR     R3,=M33_CCR_REG
    LDR     R4,[R3]         /* Load CCR register */
    ORR     R4,R4,#(1<<4)   /* Set CCR[DIV_0_TRP] bit */
    STR     R4,[R3]         /* Write bits to the CCR register */
    
    MOV     R4, #0  /* Set R4 to 0 to prepare division by zero */
    
    CPSIE   i   /* Clear PRIMASK */
    CPSIE   f   /* Clear FAULTMASK */

m33_cst_exc_usage_fault_test_ISR2_addr:
    UDIV    R3,R3,R4    /* Division by zero - generate exception !*/

    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_usage_fault_test_ISR5_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

    
m33_cst_exc_usage_fault_test_ISR2_ret_addr:
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /*------------------------------------------------------------------------*/
    /* Restore registers & Enable external interrupts                         */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_user_interrupt_vector_table
    #endif
    
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_usage_fault_test_ISR3
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    MOV     R2, #0x6    /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 6 */
    ADR.W   R0, m33_cst_exc_usage_fault_test_ISR3_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
    
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    #endif
    
    /* Enable UsageFault exception */
    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]         /* Load SHCSR register */
    ORR     R4,R4,#(1<<18)  /* Set SHCSR[USGFAULTENA] bit */
    STR     R4,[R3]         /* Modify SHCSR register */
    
    /* Enable Unaligned access UsageFault exception */
    LDR     R3,=M33_CCR_REG
    LDR     R4,[R3]         /* Load CCR register */
    ORR     R4,R4,#(1<<3)   /* Set CCR[UNALIGN_TRP] bit */
    STR     R4,[R3]         /* Write bits to the CCR register */
    
    LDR     R4,=m33_cst_scb_registers_dump /* Load to R4 SRAM address */
    ORR     R4,R4,#1        /* Set bit[0] to have unaligned address */
    
    CPSIE   i   /* Clear PRIMASK */
    CPSIE   f   /* Clear FAULTMASK */
    
m33_cst_exc_usage_fault_test_ISR3_addr:
    LDR     R3,[R4]     /* Unaligned access  -> Generate exception ! */

    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_usage_fault_test_ISR5_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

    
m33_cst_exc_usage_fault_test_ISR3_ret_addr:
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /*------------------------------------------------------------------------*/
    /* Restore registers & Enable external interrupts                         */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_user_interrupt_vector_table
    #endif
    
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_usage_fault_test_ISR4
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    MOV     R2, #0x6    /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 6 */
    ADR.W   R0, m33_cst_exc_usage_fault_test_ISR4_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */

    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    #endif
    
    /* We need to enable UsageFault exception */
    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]         /* Load SHCSR register */
    ORR     R4,R4,#(1<<18)  /* Set SHCSR[USGFAULTENA] bit */
    STR     R4,[R3]         /* Modify SHCSR register */
    
    CPSIE   i   /* Clear PRIMASK */
    CPSIE   f   /* Clear FAULTMASK */

m33_cst_exc_usage_fault_test_ISR4_addr:
    BX      R0  /* This will   clear EPSR.T bit !! */
    
    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_usage_fault_test_ISR5_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

    
m33_cst_exc_usage_fault_test_ISR5_ret_addr:   
    /*------------------------------------------------------------------------*/
    /* Restore all registers & Enable external interrupts                     */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_restore_registers_content

    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
m33_cst_exc_usage_fault_test_end:    
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R5
    LDR     R5,=m33_cst_test_tail_end
    BX      R5    /* -> Exit test */
    
    
    /*------------------------------------------------------------------------*/
    /* Test - ISR routines                                                    */
    /*------------------------------------------------------------------------*/ 
m33_cst_exc_usage_fault_test_ISR1:
    
    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that UNDEFINSTR flag was set */
    LDR     R3,=M33_UFSR_REG
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<0)   /* Check UFSR[UNDEFINSTR] flag is set */ 
    ADD     R5,R5,R4        /* !! Update signature !! */
    ROR     R5,R5,R4
    
    /* We need to clear UNDEFINSTR flag */
    STRH    R4,[R3]         /* Clear UFSR[UNDEFINSTR](rc_w1) flag */
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<0)   /* Check UFSR[UNDEFINSTR] flag was cleared */ 
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
     
    /* We need to change return address that is stored in stack:
       it points again to the undefined instruction */
    ADR.W   R3,m33_cst_exc_usage_fault_test_ISR1_ret_addr
    STR     R3,[SP,#24]
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BX      LR
       
m33_cst_exc_usage_fault_test_ISR2:
    
    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that DIVBYZERO flag was set */
    LDR     R3,=M33_UFSR_REG
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<9)   /* Check UFSR[DIVBYZERO] flag is set */        
    ADD     R5,R5,R4        /* !! Update signature !! */
    
    /* We need to clear DIVBYZERO flag */
    STRH    R4,[R3]         /* Clear UFSR[DIVBYZERO](rc_w1) flag */
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<9)   /* Check UFSR[DIVBYZERO] flag was cleared */ 
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
    
    /* We need to change return address that is stored in stack:
       it points again to div-by-zero instruction */
    ADR.W   R3,m33_cst_exc_usage_fault_test_ISR2_ret_addr
    STR     R3,[SP,#24]
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BX      LR
        
m33_cst_exc_usage_fault_test_ISR3:
    
    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that UNALIGNED flag was set */
    LDR     R3,=M33_UFSR_REG
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<8)   /* Check UFSR[UNALIGNED] flag is set */   
    ADD     R5,R5,R4        /* !! Update signature !! */
    
    /* We need to clear UNALIGNED flag */
    STRH    R4,[R3]         /* Clear UFSR[UNALIGNED](rc_w1) flag */
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<8)   /* Check UFSR[UNALIGNED] flag was cleared */
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
    
    /* We need to change return address that is stored in stack:
       it points again to unaligned access instruction */
    ADR.W   R3,m33_cst_exc_usage_fault_test_ISR3_ret_addr
    STR     R3,[SP,#24]
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BX      LR
       
m33_cst_exc_usage_fault_test_ISR4:

    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that INVSTATE flag was set */
    LDR     R3,=M33_UFSR_REG
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<1)   /* Check UFSR[INVSTATE] flag is set */
    ADD     R5,R5,R4        /* !! Update signature !! */
    ROR     R5,R5,R4
    
    /* We need to clear INVSTATE flag */
    STRH    R4,[R3]         /* Clear UFSR[INVSTATE](rc_w1) flag */
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<1)   /* Check UFSR[INVSTATE] flag was cleared */
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
    
    /* We need to repair stacked xPSR value !*/
    LDR     R3,[SP,#28]
    ORR     R3,R3,#(1<<24)  /* Ensure Thumb bit is set !! */
    STR     R3,[SP,#28]
    
    /* We will generate another UsageFault exception !! */
    ADR.W   R4,m33_cst_exc_usage_fault_test_ISR5
    ORR     R4,R4,#1
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    DSB     /* Ensures that stacked value is updated before exception return */
    
    ORR     LR,LR,#0x47    /* Change EXC_RETURN value -  
                              This will generate invalid PC UsageFault */ 
                           
    ADR.W   R0,m33_cst_exc_usage_fault_test_ISR5_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */  
m33_cst_exc_usage_fault_test_ISR5_addr:
    BX      LR          /* Generate exception */

    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_usage_fault_test_ISR5_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

        
m33_cst_exc_usage_fault_test_ISR5:
    
    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that INVPC flag was set */
    LDR     R3,=M33_UFSR_REG
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<2)   /* Check UFSR[INVPC] bit is set */
    ADD     R5,R5,R4        /* !! Update signature !! */
    
    /* We need to clear INVPC flag */
    STRH    R4,[R3]         /* Clear UFSR[INVPC](rc_w1) flag */
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<2)   /* Check UFSR[INVPC] bit was cleared */ 
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
    
    /* We need to change return address that is stored in stack: */
    ADR.W   R3,m33_cst_exc_usage_fault_test_ISR5_ret_addr
    STR     R3,[SP,#24]
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BIC     LR,LR,#0x47    /* Restore EXC_RETURN value */    
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_INTERRUPT_ENABLE */
    
    CST_FILE_END

