/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests triggering of PendSV interrupts.
*
******************************************************************************/

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_ExcPendsvTest
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_store_registers_content
    CST_EXTERN m33_cst_set_cst_interrupt_vector_table
    CST_EXTERN m33_cst_restore_registers_content
    CST_EXTERN m33_cst_test_tail_end
    CST_EXTERN m33_cst_ISR_address
    CST_EXTERN m33_cst_exception_timeout
    
    CST_SET(PRESIGNATURE,0xA34D89E2)
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_ExcPendsvTest" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_ExcPendsvTest, function)
M33_Cst_ExcPendsvTest:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Load PRESIGNATURE to R5  */
    LDR     R5,=PRESIGNATURE
    
    #if ( (M33_CST_EXECUTION_MODE == M33_CST_HANDLER) \
           && (M33_CST_PENDSV_EXCEPTION_LOW == 1U) )
    /* !! PendSV exception is not triggered !! */ 
    MOV     R2,#0xE
    BL      m33_cst_exc_pendsv_test_ISR1
    #else
    
    /*------------------------------------------------------------------------*/
    /* Store register content                                                 */
    /*------------------------------------------------------------------------*/ 
    /* !! Don't use R6, R7, R8, R9 for any other purpose until CONTROL, PRIMASK,
          FAULTMASK and BASEPRI are restored !! */
    BL      m33_cst_store_registers_content
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    LDR     R4,=m33_cst_exc_pendsv_test_ISR1
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* Before vector table is changed to the CST-own one, set R2 to
       to the expected ISR number and R0 to the expected ISR address.
       
       Content of R0 and R2 will allow determining whether interrupt was 
       triggered by CST library or by alien SW.

    !! Don't use R0, R2 for any other purpose until vector table is changed 
       to a user one. !! */
    MOV     R2,#0xE     /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 0xE */
    LDR     R0,=m33_cst_exc_pendsv_test_ISR_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
                           
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
   
    LDR     R3,=M33_ICSR_REG
    LDR     R4,[R3]         /* Load ICSR register */
    ORR     R4,R4,#(1<<28)  /* Set ICSR[PENDSVSET] bit to initiate PendSV ISR */
    
    CPSIE   i   /* Clear PRIMASK   */
    CPSIE   f   /* Clear FAULTMASK */
    
    CST_QUA_FAULT_INJECTION(CST_ERROR_INJECT_PENDSV)
    MOV     R10,#0x5A
    STR     R4,[R3]     /* -> Generate exception and wait... */
    
m33_cst_exc_pendsv_test_ISR_addr:
    /**
    * The PendSv exception is generated when the ICSR.PENDSVSET bit is asserted.
    * Note: If a timeout mechanism is implemented, the exception entry point may become unpredictable.
    */

    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_pendsv_test_ISR_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

m33_cst_exc_pendsv_test_ISR_ret_addr:    
    /*------------------------------------------------------------------------*/
    /* Restore all registers & Enable external interrupts                     */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_restore_registers_content
    
    #endif
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
m33_cst_exc_pendsv_test_end:
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R5
    LDR     R5,=m33_cst_test_tail_end
    BX      R5    /* -> Exit test */
    

    /*------------------------------------------------------------------------*/
    /* Test - ISR routines                                                    */
    /*------------------------------------------------------------------------*/
m33_cst_exc_pendsv_test_ISR1:

    ROR     R3,R5,R2       /* !! Update signature !! */
    EOR     R5,R3,R5
    
    #if ( (M33_CST_EXECUTION_MODE != M33_CST_HANDLER) \
           || (M33_CST_PENDSV_EXCEPTION_LOW != 1U) )
    /* This is an ISR for PendSV exception which is asynchronous.
    We need to change the return address that is stored in stack:
    it points to the endless loop instruction */
    LDR     R3,=m33_cst_exc_pendsv_test_ISR_ret_addr
    STR     R3,[SP,#24]
    DSB     /* Ensures that stacked value is updated before exception return */
    #endif 
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_INTERRUPT_ENABLE */
                   
    CST_FILE_END

