/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests triggering of BusFault exception.
*
******************************************************************************/

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_ExcBusFaultTest

    /* Symbols defined outside but used within current module */
    CST_EXTERN CST_RAM_TARGET0
    
    CST_EXTERN m33_cst_test_tail_end
    CST_EXTERN m33_cst_store_registers_content
    CST_EXTERN m33_cst_restore_registers_content
    CST_EXTERN m33_cst_set_cst_interrupt_vector_table
    CST_EXTERN m33_cst_ISR_address
    CST_EXTERN m33_cst_exception_timeout

    CST_SET(PRESIGNATURE,0x40DE2938)
    
    /* This address is used to trigger both Precise and Imprecise BusFault 
       exceptions.  The address was chosen from device System Memory Map 
       reserved space, see -DM33_DEVICE_RESERVED_ADDR preprocessor macro 
       definition in the CST User Manual document. 
       Note that application must ensure that this memory is not protected 
       e.g by the MPU. In case of this address is protected another address 
       from the device Reserved address space has to be chosen. */
    CST_DEFINE(M33_RESERVED_ADDR, M33_DEVICE_RESERVED_ADDR) 
     
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_ExcBusFaultTest" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_ExcBusFaultTest, function)
M33_Cst_ExcBusFaultTest:
   
    PUSH    {R4-R12,R14}

    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R2,=PRESIGNATURE
    REV.N   R5,R2           /* Reverse byte order */
    
    /* Store test values to RAM to check LDM restoration after return from
       exception */
    LDR     R3,=CST_RAM_TARGET0
    MOV     R10,#0x55555555
    MOV     R11,#0xAAAAAAAA
    MOV     R12,#0xCCCCCCCC
    MOV     R14,#0x33333333

    STM     R3,{R10,R11,R12,R14}
    DSB

    /* Prepare test values in registers */
    MOV     R10,R12         /* Should not be modified by LDM */
    MOV     R11,R14         /* Should not be modified by LDM */
    MOV     R12,#0          /* Should be modified by LDM */
    MOV     R14,#0          /* Should be modified by LDM */
    
    /*------------------------------------------------------------------------*/
    /* Store register content                                                 */
    /*------------------------------------------------------------------------*/
    /* !! Don't use R6, R7, R8, R9 for any other purpose until CONTROL, PRIMASK,
          FAULTMASK and BASEPRI are restored !! */
    BL      m33_cst_store_registers_content

    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/    
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_bus_fault_test_ISR1
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* Before vector table is changed to the CST-own one, set R2 to
       to the expected ISR number and R0 to the expected ISR address.
       
       Content of R0 and R2 will allow determining whether interrupt was 
       triggered by CST library or by alien SW.

    !! Don't use R0, R2 for any other purpose until vector table is changed 
       to a user one. !! */    
    MOV     R2,#0x5     /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 0x5 */
    LDR     R0,=m33_cst_exc_bus_fault_test_ISR_addr1
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
                           
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    
    /* We need to enable BusFault exception */
    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]         /* Load SHCSR register */   
    ORR     R4,R4,#(1<<17)  /* Set SHCSR[BUSFAULTENA] bit */
    STR     R4,[R3]         /* Modify SHCSR register */
      
    /* Disable Unaligned access Usage fault exception */
    LDR     R3,=M33_CCR_REG
    LDR     R4,[R3]         /* Load CCR register */
    BFC     R4,#3,#1        /* Clear CCR[UNALIGN_TRP] bit */
    STR     R4,[R3]         /* Modify CCR register */
    
    CPSIE   i   /* Clear PRIMASK   */
    CPSIE   f   /* Clear FAULTMASK */
    
    LDR     R3,=M33_RESERVED_ADDR    /* Load R3 with reserved address !! */

   CST_QUA_FAULT_INJECTION(CST_ERROR_INJECT_BUS_FAULT)
m33_cst_exc_bus_fault_test_ISR_addr1:
    LDR     R2,[R3]     /* Precise data bus error -> Generate exception !! */

m33_cst_exc_bus_fault_timeout_addr:
    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_bus_fault_test_ISR_ret_addr1
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout
  
m33_cst_exc_bus_fault_test_ISR_ret_addr1:
    LDM     R3,{R10,R11,R12,R14} /* !! Only R12 and R14 should be loaded !! */
    
    /* !! Update signature !! */
    ADD     R5,R5,R10,ROR #3
    ADD     R5,R5,R11,ROR #4
    SUB     R5,R5,R12,ROR #3
    SUB     R5,R5,R14,ROR #4
    
    /*------------------------------------------------------------------------*/
    /* Restore all registers & Enable external interrupts                     */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_restore_registers_content
   
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/  
m33_cst_exc_bus_fault_test_end:
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R5
    LDR     R5,=m33_cst_test_tail_end
    BX      R5    /* -> Exit test */
    
    
    /*------------------------------------------------------------------------*/
    /* Test - ISR routines                                                    */
    /*------------------------------------------------------------------------*/     
m33_cst_exc_bus_fault_test_ISR1:
    
    ROR     R3,R5,R2    /* !! Update signature !! */
    EOR     R5,R3,R5
   
    /* We need to check the BFAR register was loaded by fault address */
    LDR     R3,=M33_BFAR_REG
    LDR     R4,[R3]                 /* Load R4 with faulty address */
    LDR     R3,=M33_RESERVED_ADDR    /* Load R3 with reserved address !! */ 
    SUB     R4,R4,R3    /* Compare addresses */
    ADD     R5,R5,R4    /* Destroy signature in case of error !! */
    
    /* We need to check that PRECISERR & BFARVALID flags are set */
    LDR     R3,=M33_BFSR_REG
    LDRB    R4,[R3]     /* Use byte access to BFSR */
    AND     R4,R4,#0x82 /* Check BFSR[PRECISERR]&[BFARVALID] flags are set */
    ADD     R5,R5,R4    /* !! Update signature !! */
    
    /* We need to clear PRECISERR & BFARVALID flags */
    STRB    R4,[R3]     /* Clear BFSR[PRECISERR] & BFSR[BFARVALID] flags */
    LDRB    R4,[R3]     /* Use byte access to BFSR */
    AND     R4,R4,#0x82 /* Check BFSR[PRECISERR]&[BFARVALID] were cleared */
    ADD     R5,R5,R4    /* Destroy signature in case of error !! */
             
    /* We need to change return address that is stored in stack:
       it points to instruction which causes PRECISERR BusFault */
    ADR.W   R3,m33_cst_exc_bus_fault_test_ISR_ret_addr1
    STR     R3,[SP,#24]
    
    /* We need to change R3 value that is stored in stack to RAM target 0
       address */
    LDR     R3,=CST_RAM_TARGET0
    STR     R3,[SP,#12]
    
    /* We need to change XPSR value that is stored in stack to force LDM
       instruction to continue loading from register R12 */
    LDR     R3,[SP,#0x1C]
    ADD     R3,R3,#0x0000C000 /* LDM will continue from R12 */
    STR     R3,[SP,#0x1C]
    
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_INTERRUPT_ENABLE */

    CST_FILE_END

