/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests DIVIDER module. Tests both unsigned/signed division.
*
* Note that DIV is never dual-issued and only executes from slot0.
*
* Decoder coverage:
* ---------------- 
* Thumb (32-bit) DECODER:
*   - SDIV, UDIV
******************************************************************************/

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

#if (CORTST_M33_DIVIDER_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_DivTest
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    
    CST_SET(PRESIGNATURE_SEED_0, 0x34E9) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0x8E61) /* 3412 */ 

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_DivTest" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_DivTest, function) 
M33_Cst_DivTest:

    PUSH.W  {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R5,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.W R7,R5                   /* FFFF7856 */
    MOV     R4,#0xFFFFFFFF          /* FFFFFFFF */
    MOVT    R4,#PRESIGNATURE_SEED_1 
    LSR     R2,R4,#1                /* 3412FFFF */
    AND     R9,R2,R7                /* 34127856 */
    RBIT    LR,R9                   /* 65872143 */
    REV16.W R0,LR                   /* 87654321 -> PRESIGNATURE = 0x972CE20C */
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MRS     R1,PRIMASK                  /* Save PRIMASK                       */
    
    /**************************************************************************/
    /* Check the divider with the set of test vectors in a form:              */
    /*  rotate(X)/shift_right(Y)                                              */
    /**************************************************************************/
    MVN     R5,R0
    MVN     R6,R5
m33_cst_div_test_loop1:
    RSB     R10,R6,#0   /* Prepare reversed value !! */
    /* Execute tested DIV operations ! */
    SDIV    R7,R5,R6
    UDIV    R8,R5,R6
    SDIV    R9,R5,R10
    /* Update Signature !! */
    ADD     R0,R0,R7
    ROR     R0,R0,#1
    ADD     R0,R0,R8
    ROR     R0,R0,#1
    ADD     R0,R0,R9
    /* Prepare new test vectors */
    ROR     R5,R5,#1    
    LSRS    R6,R6,#1
    BNE     m33_cst_div_test_loop1  /* 32-times */
    
    /**************************************************************************/
    /* Check the divider with the set of test vectors in a form:              */
    /*  shift_right(X)/(rotate(Y) & 0x0000000F)                               */
    /**************************************************************************/
    MVN     R7,R5
    MOV     R2,R5
m33_cst_div_test_loop2:
    RSB     R10,R7,#0   /* Prepare reversed value !! */
    AND     R12,R2,#0xF
    RSB     R9,R12,#0   /* Prepare reversed value !! */
    /* Execute tested DIV operations ! */
    SDIV    R3,R7,R9     
    UDIV    R4,R7,R12    
    SDIV    R5,R10,R9
    /* Update Signature */
    ADD     R0,R0,R3
    ROR     R0,R0,#1
    ADD     R0,R0,R4
    ROR     R0,R0,#1
    ADD     R0,R0,R5
    /* Prepare new test vectors */
    ROR     R2,R2,#1
    LSRS    R7,R7,#1
    BNE     m33_cst_div_test_loop2  /* 32-times */
    
    /**************************************************************************/
    /* Check division by zero !!                                              */
    /*  div-by-zero trap is disabled !!                                       */ 
    /**************************************************************************/
    MVN     R12,R7
    LDR     R2,=M33_CCR_REG
    LDR     R3,[R2]     /* Load CCR to R3 */
    MOV     R4,#0x10    
    BIC     R4,R3,R4    /* Clear CCR.DIV_0_TRP */
    /*------------------------------------------------------------------------*/    
    CPSID   i           /* !! Disables all interrupts !! */
    /*------------------------------------------------------------------------*/
    STR     R4,[R2]     /* Disable div-by-zero trap if enabled */
    DSB
    UDIV    R12,R0,R7   /* R7==0 */    
    STR     R3,[R2]     /* Restore CCR from R3 */
    DSB
    /*------------------------------------------------------------------------*/
    MSR    PRIMASK,R1   /* !! Enable all interrupts !! */
    /*------------------------------------------------------------------------*/
    /* Update Signature - this corrupts signature in case of error !! */
    ADD     R0,R12
    ADD     R0,R7
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_div_test_end:
    /* Test result is returned in R0, according to the conventions */
    B       m33_cst_test_tail_end

    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_DIVIDER_ENABLE */
    
    CST_FILE_END

