/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
 
/******************************************************************************
* Test summary:
* -------------
* Tests connection between conditional branch logic and modules which updates
* flags. E.g. Branch logic relies on ALU or MAC modules which have to update 
* flags on time.
* Additionally tests special branch instructions, see below.
*
* Branches are always single issued but can be in either slot. 
* Branch instructions are always placed in the code twice to test both  
* slot0 and slot1. 
* Instructions in slot0 and slot1 are intentionally not both branches.
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER
*  - B<cond>
*  - MOV PC,Rm (Branch)
*  - POP {PC}  (Branch)
* 
* Thumb (32-bit) DECODER
*  - LDR PC,<label> (Branch)
*  - LDR PC,[Rn,Rm] (Branch)
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_BRANCH_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_BranchTest3
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

    /* Local defines */
    CST_SET(SIG_UPDATE_VAL0,0x00000543U)
    CST_SET(SIG_UPDATE_VAL1,0x00000544U)
    CST_SET(PRESIGNATURE_SEED_0, 0x5DD8) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0x0800) /* 3412 */
    
    /**
     * Values stored in registers:
     * - R0  ... must be zero
     * - R5  ... accumulated signature
     * - R9  ... PRIMASK
     * - R11 ... absolute address to jump to on test failure
     */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_BranchTest3" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_BranchTest3, function)
M33_Cst_BranchTest3:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R7,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.W R9,R7                   /* FFFF7856 */
    MOV     R1,#0xFFFFFFFF          /* FFFFFFFF */
    MOVT    R1,#PRESIGNATURE_SEED_1 /* 3412FFFF */
    AND     R0,R9,R1                /* 34127856 */
    RBIT    R6,R0                   /* 65872143 */
    REV16.W R5,R6                   /* 87654321 -> PRESIGNATURE = 0x1BBA1000 */
  
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Set return address for failure case */
    LDR     R11,=m33_cst_branch_test3_failed
    ORR     R11,R11,#0x00000001     /* Ensure bit0 is set !! */
    
    MRS     R9,PRIMASK      /* Save PRIMASK to R9 */
    
    
    /**************************************************************************
    *   Test connection between MAC and Branch unit.
    ***************************************************************************/
    MOV     R0,#0x0
    MSR     APSR_nzcvq,R0     /* Clear flags */
    MOV     R4,#0x00000002
    MOV     R3,#0xFFFFFFFF
    
    ADR.W   R7,m33_cst_branch_test3_ret1
    MULS    R4,R3       /* This will set N flag */                       
    BMI.N   m33_cst_branch_test3_testlabel1                     /* Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret1:
    ADR.W   R7,m33_cst_branch_test3_ret2
    MULS    R4,R3       /* This will clear N flag */                           
    BPL.N   m33_cst_branch_test3_testlabel1                     /* Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
    
    /***************************************************************************
    *  This is Test Label 1                                                   
    ***************************************************************************/
    CST_TYPE(m33_cst_branch_test3_testlabel1, function)
m33_cst_branch_test3_testlabel1:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R5,R5,#SIG_UPDATE_VAL0  /* !! Update signature !! */
    ROR     R5,R5,#2
    MOV     PC,R7                   /* Branch -->  contiue with testing !! */
    
    
m33_cst_branch_test3_ret2:
    ADR.W   R7,m33_cst_branch_test3_ret3
    MULS    R0,R0       /* This will set Z flag */
    BEQ.N   m33_cst_branch_test3_testlabel1                     /* Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret3:
    ADR.W   R7,m33_cst_branch_test3_ret4
    MULS    R4,R4       /* This will clear Z flag */
    BNE.N   m33_cst_branch_test3_testlabel1                     /* Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    

    /***************************************************************************
    * Test connection between ALU0, ALU1 and Branch Unit
    ***************************************************************************/
m33_cst_branch_test3_ret4:
    ADR.W   R12,m33_cst_branch_test3_ret5
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ANDS    R3,R3                           /* Slot0: This will set N flag    */
    BMI.N   m33_cst_branch_test3_testlabel2 /* Slot1:               Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret5:
    ADR.W   R12,m33_cst_branch_test3_ret6
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ANDS    R4,R4                           /* Slot0: This will clear N flag  */
    BPL.N   m33_cst_branch_test3_testlabel2 /* Slot1:               Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */

m33_cst_branch_test3_ret6:
    ADR.W   R12,m33_cst_branch_test3_ret7
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    EORS    R0,R0                           /* Slot0: This will set Z flag    */
    BEQ.N   m33_cst_branch_test3_testlabel2 /* Slot1:               Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret7:
    ADR.W   R12,m33_cst_branch_test3_ret8
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ANDS    R4,R4                           /* Slot0: This will clear Z flag  */
    BNE.N   m33_cst_branch_test3_testlabel2 /* Slot1:               Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
      
m33_cst_branch_test3_ret8:
    ADR.W   R12,m33_cst_branch_test3_ret9
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R4,R4,R3                           /* Slot0: This will set C flag */
    BHI.N   m33_cst_branch_test3_testlabel2 /* Slot1: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret9:
    ADR.W   R12,m33_cst_branch_test3_ret10
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    SUBS    R4,R4,R3                           /* Slot0: This will clear C flag */
    BCC.N   m33_cst_branch_test3_testlabel2 /* Slot1: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret10:
    ADR.W   R12,m33_cst_branch_test3_ret11
    BIC     R2,R3,#0x80000000
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R2,R2                        /* Slot0: This will set V flag */
    BVS.N   m33_cst_branch_test3_testlabel2 /* Slot1: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret11:
    ADR.W   R12,m33_cst_branch_test3_ret12
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    SUBS    R4,R4,R3                        /* Slot0: This will clear V flag */
    BVC.N   m33_cst_branch_test3_testlabel2 /* Slot1: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */ 
    
        
    /***************************************************************************
    * This is Test Label 2                                                     
    ***************************************************************************/
    CST_TYPE(m33_cst_branch_test3_testlabel2, function)
m33_cst_branch_test3_testlabel2:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R5,R5,#SIG_UPDATE_VAL1  /* !! Update signature !! */
    ROR     R5,R5,#1
    MOV     PC,R12                  /* Branch -->  contiue with testing !! */
    

m33_cst_branch_test3_ret12:
    ADR.W   R12,m33_cst_branch_test3_ret13
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    ANDS    R3,R3                           /* Slot1: This will set N flag */
    BMI.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret13:
    ADR.W   R12,m33_cst_branch_test3_ret14
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    ANDS    R4,R4                           /* Slot1: This will clear N flag */
    BPL.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */


m33_cst_branch_test3_ret14:
    ADR.W   R12,m33_cst_branch_test3_ret15
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    EORS    R0,R0                           /* Slot1: This will set Z flag */
    BEQ.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret15:
    ADR.W   R12,m33_cst_branch_test3_ret16
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    ANDS    R4,R4                           /* Slot1: This will clear Z flag */
    BNE.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret16:    
    ADR.W   R12,m33_cst_branch_test3_ret17
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    ADDS    R5,R4,R3                        /* Slot1: This will set C flag */
    BHI.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret17:
    ADR.W   R12,m33_cst_branch_test3_ret18
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    SUBS    R5,R4,R3                        /* Slot1: This will set C flag */
    BCC.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret18:
    ADR.W   R12,m33_cst_branch_test3_ret19
    BIC     R2,R3,#0x80000000
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    ADDS    R2,R2,R2                        /* Slot1: This will set V flag */
    BVS.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret19:
    ADR.W   R12,m33_cst_branch_test3_ret20
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                     /* Slot0: */
    SUBS    R4,R4,R3                        /* Slot1: This will clear V flag */
    BVC.N   m33_cst_branch_test3_testlabel2 /* Slot0: Branch -> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */


    /***************************************************************************
    *   Test Special branches:
    *    LDR PC,<label>     Interworking branch
    *    LDR PC,[Rm]        Interworking branch
    *    POP {PC}           Interworking branch
    *    MOV PC,Rm          Not interworking branch
    ***************************************************************************/
m33_cst_branch_test3_ret20:
    /* Load Test Label addresses and push them to the stack */
    LDR     R1,=m33_cst_branch_test3_testlabel1
    LDR     R2,=m33_cst_branch_test3_testlabel2
    ORR     R1,R1,#0x00000001   /* Set Bit0 for branches with Interworking */
    ORR     R2,R2,#0x00000001   /* Set Bit0 for branches with Interworking */
    PUSH    {R1,R2}
    
    ADR.W   R7,m33_cst_branch_test3_ret21
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR     PC,=m33_cst_branch_test3_testlabel1         /* Slot0: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R1,R2} /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */
     
m33_cst_branch_test3_ret21:
    ADR.W   R7,m33_cst_branch_test3_ret22
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR     PC,[SP,R0]                                   /* Slot0: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R1,R2} /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */

m33_cst_branch_test3_ret22:
    ADR.W   R7,m33_cst_branch_test3_ret23
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    POP     {PC}                                        /* Slot0: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R1,R2} /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */
     
m33_cst_branch_test3_ret23:
    ADR.W   R7,m33_cst_branch_test3_ret24
    BIC     R1,R1,#0x00000001   /* Not interworking branch - Clear Bit0  */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    MOV     PC,R1                                       /* Slot0: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R2}    /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */    
     
m33_cst_branch_test3_ret24:
    ADR.W   R12,m33_cst_branch_test3_ret25
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    LDR     PC,=m33_cst_branch_test3_testlabel2         /* Slot1: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R2}    /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */ 
     
m33_cst_branch_test3_ret25:
    ADR.W   R12,m33_cst_branch_test3_ret26
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    LDR     PC,[SP,R0]                                  /* Slot1: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R2}    /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret26:
    ADR.W   R12,m33_cst_branch_test3_ret27
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    POP     {PC}                                        /* Slot1: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    POP     {R2}    /* !! Never executed in fault-free case - Repair Stack !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test3_ret27:
    ADR.W   R12,m33_cst_branch_test3_end
    BIC     R2,R2,#0x00000001   /* Clear Bit0 for not interworking branches  */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    MOV     PC,R2                                       /* Slot1: Branch --> */
    EORS    R5,R5   /* !! Never executed in fault-free case !! */
    BX      R11     /* !! Never executed in fault-free case !! */
    
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_branch_test3_end:
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R5
m33_cst_branch_test3_failed:    
    B       m33_cst_test_tail_end
    
  
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_BRANCH_ENABLE */

    CST_FILE_END

