/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
 
/******************************************************************************
* Test summary:
* -------------
*
* This test covers conditional and table branches as well as their decoding. 
* Branch instructions covered are: B<cond> <label>, CBNZ/CBZ, TBB/TBH
*
* Branches are tested within single code section "mcal_text". 
* Conditional branch instructions are tested in both forward and backward 
* directions.
*
* Branches are always single issued but can be in either slot. 
* Branch instructions are always placed in the code twice to test both  
* slot0 and slot1. 
* Instructions in slot0 and slot1 are intentionally not both branches.
* -----------------------------------------------------------------------------
*    CST_PREPARE_PIPELINE
*    BRANCH_INSTR       <- Instruction 0:
*    NOP                <- Instruction 1:
*    NOP                <- Instruction 0:
*    BRANCH_INSTR_CMPL  <- Instruction 1:
*
*   Complementary instructions pairs:
*   -------------------------------------
*   CBZ - CBNZ
*   BEQ - BNE
*   BCS - BCC (equals BHS - BLO)
*   BMI - BPL
*   BVS - BVC
*   BHI - BLS
*   BGE - BLT
*   BGT - BLE
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER
*  - B<cond> <label>
*  - CBNZ/CBZ Rn,<label>
* 
* Thumb (32-bit) DECODER
*  - B<cond> <label>
*  - TBB/TBH Rn,Rm
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_BRANCH_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT    M33_Cst_BranchTest2
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

    /* Symbols defined in the current module for the internal use only */
    CST_SET(SIG_UPDATE_VAL1,0x000004C1)
    CST_SET(SIG_UPDATE_VAL2,0x000004C2)
    CST_SET(SIG_UPDATE_VAL3,0x000004C3)

    /* Values stored in registers to be preserved during test execution:
       - R7 ... accumulated signature
       - R9 ... PRIMASK register value
       - R11... return address on test failure
     */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /***************************************************************************
     *    This is Test Label 1
     **************************************************************************/ 
    CST_THUMB2
    CST_TYPE(m33_cst_branch_test2_testlabel1, function)
m33_cst_branch_test2_testlabel1:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9  /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R7,R7,#SIG_UPDATE_VAL1  /* !! Update signature !! */
    ROR     R7,R7,#1                /* !! Update signature !! */
    ORR     R6,R6,#0x00000001       /* Ensure bit0 is set !! */
    BX      R6
    


    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_BranchTest2" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_BranchTest2, function)
M33_Cst_BranchTest2:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare PRESIGNATURE to R7 */
    MOV     R7,#SIG_UPDATE_VAL1
    MLA     R7,R7,R7,R7
    ROR     R7,R7,#24
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Set return address for failure case */
    LDR     R11,=m33_cst_branch_test2_failed
    ORR     R11,R11,#0x00000001     /* Ensure bit0 is set !! */
    
    MRS     R9,PRIMASK      /* Save PRIMASK to R9 */
    
    /**********************************************************************
     * CBZ/CBNZ
     *
     * Note: CBZ/CBNZ allows only forward branches !!
     *********************************************************************/
    ADR.W   R2,m33_cst_branch_test2_cbz_cbnz_1_ret
    MOV     R3,#0x00000000
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                             /* Slot0: */ 
    CBNZ    R3,m33_cst_branch_test2_cbz_cbnz_1_err  /* Slot1: CBNZ no branch */
    NOP                                             /* Slot0: */    
    NOP                                             /* Slot1: */
    CBZ     R3,m33_cst_branch_test2_testlabel2      /* Slot0: CBZ branch -> */
    NOP             /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_cbz_cbnz_1_err:
    BX      R11     /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_cbz_cbnz_1_ret:
    ADR.W   R2,m33_cst_branch_test2_cbz_cbnz_2_ret
    MOV     R4,#0xFFFFFFFF
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                             /* Slot0: */ 
    CBZ     R4,m33_cst_branch_test2_cbz_cbnz_2_err  /* Slot1: CBZ no branch */
    NOP                                             /* Slot0: */    
    NOP                                             /* Slot1: */
    CBNZ    R4,m33_cst_branch_test2_testlabel2      /* Slot0: CBNZ branch -> */
    NOP             /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_cbz_cbnz_2_err:
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_cbz_cbnz_2_ret:
    ADR.W   R2,m33_cst_branch_test2_cbz_cbnz_3_ret
    MOV     R5,#0x00000000
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    CBNZ    R5,m33_cst_branch_test2_cbz_cbnz_3_err  /* Slot0: CBNZ no branch */
    NOP                                             /* Slot1 */
    NOP                                             /* Slot0 */
    CBZ     R5,m33_cst_branch_test2_testlabel2      /* Slot1: CBZ branch -> */
m33_cst_branch_test2_cbz_cbnz_3_err:
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_cbz_cbnz_3_ret:
    ADR.W   R2,m33_cst_branch_test2_cbz_cbnz_4_ret
    MOV     R6,#0xFFFFFFFF
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    CBZ     R6,m33_cst_branch_test2_cbz_cbnz_4_err  /* Slot0: CBZ no branch */
    NOP                                             /* Slot1 */    
    NOP                                             /* Slot0 */
    CBNZ    R6,m33_cst_branch_test2_testlabel2      /* Slot1: CBNZ branch -> */
m33_cst_branch_test2_cbz_cbnz_4_err:
    BX      R11     /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_cbz_cbnz_4_ret:
    B       m33_cst_branch_test2_bcond  /* Continue to B<cond> */
    
   
    /**********************************************************************
     *    This is Test Label 2
     *********************************************************************/
     CST_THUMB2
     CST_TYPE(m33_cst_branch_test2_testlabel2, function)
m33_cst_branch_test2_testlabel2:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R7,R7,#SIG_UPDATE_VAL2  /* !! Update signature !! */
    ROR     R7,R7,#1                /* !! Update signature !! */
    ORR     R2,R2,#0x00000001       /* Ensure bit0 is set !! */
    BX      R2                      /* Branch -->  contiue with testing !! */  
    
    
    /***************************************************************************
    * TBB,TBH  
    ***************************************************************************/
m33_cst_branch_test2_tbb_tbh:
    /* Load Offset Table address  */
    LDR     R10,=m33_cst_branch_test2_tbb_tbh_data0
    BIC     R10,R10,#0x00000001 /* Ensure bit0 is cleared !! */
    MOV     R5,#0x1             /* Index 0 (Offset 2*2=8Bytes) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    TBB     [R10,R5]                                    /* Slot0: branch--> */
    NOP                 /* !! Never executed in fault-free case !! */
    BLX     R11         /* !! Never executed in fault-free case !! */
    ADD     R7,R7,#SIG_UPDATE_VAL1                      /* <-- branch here */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9
    /*------------------------------------------------------------------------*/
    
    ADD     R10,R10,#0x4         /* Move Offset Table pointer */
    MOV     R5,#0x3            /* Index 0 (Offset 4*2=8Bytes) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    TBB     [R10,R5]                                    /* Slot1: branch--> */
    BLX     R11         /* !! Never executed in fault-free case !! */
    ADD     R7,R7,#SIG_UPDATE_VAL1                      /* <-- branch here */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9
    /*------------------------------------------------------------------------*/
    
    /* Load Offset Table address  */
    LDR     R10,=m33_cst_branch_test2_tbb_tbh_data1
    BIC     R10,R10,#0x00000001 /* Ensure bit0 is cleared !! */
    MOV     R5,#0x1             /* Index 1 (Offset 2*2 = 4-Bytes) */         
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    TBH     [R10,R5,LSL #1]                             /* Slot0: branch --> */
    NOP                 /* !! Never executed in fault-free case !! */
    BLX     R11         /* !! Never executed in fault-free case !! */
    ADD     R7,R7,#SIG_UPDATE_VAL1                      /* <-- branch here */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9
    /*------------------------------------------------------------------------*/
    
    ADD     R5,R10,#0x4         /* Move Offset Table pointer */
    MOV     R10,#0x0            /* Index 0 (Offset 1*2 = 2-Bytes) */         
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    TBH     [R5,R10,LSL #1]                             /* Slot1: branch --> */
    BLX     R11         /* !! Never executed in fault-free case !! */
    ADD     R7,R7,#SIG_UPDATE_VAL1                      /* <-- branch here */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9
    /*------------------------------------------------------------------------*/
    
    MOV     R3,#0x2     /* Index 2 (Offset 4*2 = 8-Bytes) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    TBB     [PC,R3]                                     /* Slot0: branch --> */
    CST_LABEL
    CST_WORD 0x00040000    /* Offset Table */
m33_cst_branch_test2_tbb_tbh_data0:
    CST_WORD 0x00000200    /* Offset Table */
    CST_WORD 0x01000000    /* Offset Table */
    CST_THUMB2
    ADD     R7,R7,#SIG_UPDATE_VAL1                      /* <-- branch here */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9
    /*------------------------------------------------------------------------*/
  
    MOV     R12,#0x1     /* Index 1 (Offset 4*2 = 8-Bytes) */  
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP    
    TBH     [PC,R12,LSL #1]                             /* Slot1: branch --> */
    CST_LABEL
    CST_WORD 0x00040000        /* Offset Table */
m33_cst_branch_test2_tbb_tbh_data1:
    CST_WORD 0x00020000        /* Offset Table */
    CST_WORD 0x00000001        /* Offset Table */
    CST_THUMB2
    ADD     R7,R7,#SIG_UPDATE_VAL1                      /* <-- branch here */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9
    /*------------------------------------------------------------------------*/
    ROR     R7,R7,#1    /* !! Update Signature !! */
    B       m33_cst_branch_test2_end       
    

    /***************************************************************************
     *  B<cond> <label>
     *
     *  Note: Conditional branches (forward/backward)
     **************************************************************************/     
m33_cst_branch_test2_bcond:
    LDR     R8,=m33_cst_branch_test2_bcond_ret1
    MOV     R4,#0x40000000                      /* Z=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BNE     m33_cst_branch_test2_bcond_err0     /* Slot0: Z==0 => error */
    NOP                                         /* Slot1 */
    BEQ     m33_cst_branch_test2_testlabel3     /* Slot0: Z==1 => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */                                         
m33_cst_branch_test2_bcond_err0:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret2:
    LDR     R8,=m33_cst_branch_test2_bcond_ret3
    MOV     R4,#0x20000000                 /* C=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BLO     m33_cst_branch_test2_bcond_err2     /* Slot1: C==0 => error */
    NOP                                         /* Slot0 */
    BCS     m33_cst_branch_test2_testlabel3     /* Slot1: C==1 => branch fwr */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err2:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret4:
    LDR     R8,=m33_cst_branch_test2_bcond_ret5
    MOV     R4,#0x80000000                       /* N=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BPL     m33_cst_branch_test2_bcond_err4     /* Slot0: N==0 => error */
    NOP                                         /* Slot1: */
    BMI     m33_cst_branch_test2_testlabel3     /* Slot0: N==1 => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err4:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret6:
    LDR     R8,=m33_cst_branch_test2_bcond_ret7
    MOV     R4,#0x10000000                       /* V=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BVC     m33_cst_branch_test2_bcond_err6     /* Slot1: V==0 => error */
    NOP                                         /* Slot0: */
    BVS     m33_cst_branch_test2_testlabel3     /* Slot1: V==1 => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err6:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret8:
    LDR     R8,=m33_cst_branch_test2_bcond_ret9
    MOV     R4,#0x20000000                       /* C=1, Z=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLS     m33_cst_branch_test2_bcond_err8     /* Slot0: !(C==1&&Z==0) => error */
    NOP                                         /* Slot1: */    
    BHI     m33_cst_branch_test2_testlabel3     /* Slot0: C==1&&Z==0 => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err8:
    BX      R11 /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_bcond_ret10:
    LDR     R8,=m33_cst_branch_test2_bcond_ret11
    MOV     R4,#0x00000000                  /* C=0, Z=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BHI     m33_cst_branch_test2_bcond_err10    /* Slot1: C==1&&Z==0 => error */
    NOP                                         /* Slot0: */
    BLS     m33_cst_branch_test2_testlabel3     /* Slot1: !(C==1&&Z==0) => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err10:
    BX      R11 /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_bcond_ret12:
    LDR     R8,=m33_cst_branch_test2_bcond_ret13
    MOV     R4,#0x90000000                      /* N=1, V=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLT     m33_cst_branch_test2_bcond_err12    /* Slot0: N!=V => error */
    NOP                                         /* Slot1: */
    BGE     m33_cst_branch_test2_testlabel3     /* Slot0: N==V => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err12:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret14:
    LDR     R8,=m33_cst_branch_test2_bcond_ret15
    MOV     R4,#0x00000000                      /* N=0, V=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BLT     m33_cst_branch_test2_bcond_err14    /* Slot1: N!=V => error */
    NOP                                         /* Slot0: */
    BGE     m33_cst_branch_test2_testlabel3     /* Slot1: N==V => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err14:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret16:
    LDR     R8,=m33_cst_branch_test2_bcond_ret17
    MOV     R4,#0x00000000                       /* Z=0, N=0, V=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLE     m33_cst_branch_test2_bcond_err16    /* Slot0: !(Z==0 && N==V) => error */
    NOP                                         /* Slot1: */
    BGT     m33_cst_branch_test2_testlabel3     /* Slot0: (Z==0 && N==V) => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err16:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret18:
    LDR     R8,=m33_cst_branch_test2_bcond_ret19
    MOV     R4, #0xD0000000                     /* Z=1, N=1, V=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BGT     m33_cst_branch_test2_bcond_err18    /* Slot1: (Z==0 && N==V) => error */
    NOP                                         /* Slot0: */
    BLE     m33_cst_branch_test2_testlabel3     /* Slot1: !(Z==0 && N==V) => branch fwd */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err18:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret20:
    LDR     R8,=m33_cst_branch_test2_bcond_ret21
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    B       m33_cst_branch_test2_testlabel3     /* Slot0: always branch fwd */
    NOP                                         /* Slot1: */
    BX      R11 /* !! Never executed in fault-free case !! */
    

m33_cst_branch_test2_bcond_ret22:
    ROR     R7,R7,#1    /* !! Update signature !! */
    B       m33_cst_branch_test2_tbb_tbh    /* Continue to Case 3) */
    
    
m33_cst_branch_test2_bcond_ret1:
    LDR     R6,=m33_cst_branch_test2_bcond_ret2
    MOV     R4,#0xB0000000                        /* Z=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BEQ     m33_cst_branch_test2_bcond_err1     /* Slot1: Z==1 => error */
    NOP                                         /* Slot0: */
    BNE     m33_cst_branch_test2_testlabel1     /* Slot1: Z==0 => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err1:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret3:
    LDR     R6,=m33_cst_branch_test2_bcond_ret4
    MOV     R4, #0xD0000000                 /* C=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BHS     m33_cst_branch_test2_bcond_err3     /* Slot0: C==1 => error (BHS equals to BCS) */
    NOP                                         /* Slot1: */
    BCC     m33_cst_branch_test2_testlabel1     /* Slot0: C==0 => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err3:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret5:
    LDR     R6,=m33_cst_branch_test2_bcond_ret6
    MOV     R4,#0x70000000                  /* N=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BMI     m33_cst_branch_test2_bcond_err5     /* Slot1: N==1 => error */
    NOP                                         /* Slot0: */
    BPL     m33_cst_branch_test2_testlabel1     /* Slot1: N==1 => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err5:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret7:
    LDR     R6,=m33_cst_branch_test2_bcond_ret8
    MOV     R4,#0xE0000000                  /* V=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BVS     m33_cst_branch_test2_bcond_err7     /* Slot0: V==1 => error */
    NOP                                         /* Slot1: */
    BVC     m33_cst_branch_test2_testlabel1     /* Slot0: V==0 => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err7:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret9:
    LDR     R6,=m33_cst_branch_test2_bcond_ret10
    MOV     R4,#0xD0000000                      /* C=0, Z=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BHI     m33_cst_branch_test2_bcond_err9     /* Slot1: C==1 && Z==0 => error */
    NOP                                         /* Slot0: */
    BLS     m33_cst_branch_test2_testlabel1     /* Slot1: !(C==1 && Z==0) => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err9:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret11:
    LDR     R6,=m33_cst_branch_test2_bcond_ret12
    MOV     R4,#0xF0000000                       /* C=1, Z=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BHI     m33_cst_branch_test2_bcond_err11    /* Slot0: C==1 && Z==0 => error */
    NOP                                         /* Slot1: */
    BLS     m33_cst_branch_test2_testlabel1     /* Slot0: !(C==1 && Z==0) => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err11:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret13:
    LDR     R6,=m33_cst_branch_test2_bcond_ret14
    MOV     R4,#0x80000000                      /* N=1, V=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BGE     m33_cst_branch_test2_bcond_err13    /* Slot1: N==V => error */
    NOP                                         /* Slot0: */
    BLT     m33_cst_branch_test2_testlabel1     /* Slot1: N!=V => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err13:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret15:
    LDR     R6,=m33_cst_branch_test2_bcond_ret16
    MOV     R4,#0x10000000                       /* N=0, V=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BGE     m33_cst_branch_test2_bcond_err15    /* Slot0: N==V => error */
    NOP                                         /* Slot1: */
    BLT     m33_cst_branch_test2_testlabel1     /* Slot0: N!=V => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err15:
    BX      R11 /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_bcond_ret17:
    LDR     R6,=m33_cst_branch_test2_bcond_ret18
    MOV     R4,#0x80000000                      /*  N=1, Z=0, V=0 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */
    BGT     m33_cst_branch_test2_bcond_err17    /* Slot1: Z==0 && N==V => error */
    NOP                                         /* Slot0: */
    BLE     m33_cst_branch_test2_testlabel1     /* Slot1: !(Z==0 && N==V) => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err17:
    BX      R11 /* !! Never executed in fault-free case !! */

m33_cst_branch_test2_bcond_ret19:
    LDR     R6,=m33_cst_branch_test2_bcond_ret20
    MOV     R4,#0x90000000                      /* Z=0, N=1, V=1 */
    MSR     APSR_nzcvq,R4
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLE     m33_cst_branch_test2_bcond_err19    /* Slot0: !(Z==0 && N==V) => error */
    NOP                                         /* Slot1: */
    BGT     m33_cst_branch_test2_testlabel1     /* Slot0: Z==0 && N==V => branch back */
    NOP         /* !! Never executed in fault-free case !! */
m33_cst_branch_test2_bcond_err19:
    BX      R11 /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test2_bcond_ret21:
    LDR     R6,=m33_cst_branch_test2_bcond_ret22
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                         /* Slot0: */    
    B       m33_cst_branch_test2_testlabel1     /* Slot1: always branch back */
    BX      R11 /* !! Never executed in fault-free case !! */


    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_branch_test2_end:
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R7
m33_cst_branch_test2_failed:    
    B       m33_cst_test_tail_end
    

    /**********************************************************************
     *    This is Test Label 3
     *********************************************************************/
    CST_TYPE(m33_cst_branch_test2_testlabel3, function)
m33_cst_branch_test2_testlabel3:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9  /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R7,R7,#SIG_UPDATE_VAL3  /* !! Update signature !! */
    ROR     R7,R7,#1                /* !! Update signature !! */
    ORR     R8,R8,#0x00000001       /* Ensure bit0 is set !! */
    BX      R8                      /* Branch -->  contiue with testing !! */
    

    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_BRANCH_ENABLE */
    
    CST_FILE_END

