/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests ALU0 and ALU1 ADDER Unit related logic as well as decoding 
* of related instructions.
* Each time before issuing the tested instructions, the external
* interrupts are disabled and pipeline is flushed to ensure its consistent 
* state.    
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:
*   - ADCS, ADDS, ADD, SBCS, SUBS, (register)
*   - ADDS, SUBS (imm3), ADDS, SUBS (imm8)
*   - RSBS (immediate)
*   - CMP, CMN (register)
*   - CMP (immediate) 
*
* Thumb (32-bit) DECODER:
*   - ADC{S}, ADD{S}, SBC{S}, SUB{S}, RSB{S} (register)
*   - ADC{S}, ADD{S}, SBC{S}, SUB{S} (immediate)
*   - CMP, CMN (register)
*   - CMP, CMN (immediate)
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_ALU_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_AluTest4

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

    CST_SET(PRESIGNATURE_SEED_0, 0x8182) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0x6BE9) /* 3412 */
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_AluTest4" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_AluTest4, function)
M33_Cst_AluTest4:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R1,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.W R2,R1                   /* FFFF7856 */
    MOV     R8,#0xFFFFFFFF          /* FFFFFFFF */
    MOVT    R8,#PRESIGNATURE_SEED_1 /* 3412FFFF */
    AND     R4,R2,R8                /* 34127856 */
    RBIT    R8,R4                   /* 65872143 */
    REV16.W R11,R8                  /* 87654321 -> PRESIGNATURE = 0x4181D697 */
    PUSH    {R11}
    
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0
    
    CST_OPCODE_START
    CST_OPCODE16(0xF380)       /* MSR     APSR,R0 */     
    CST_OPCODE16(0x8C00)       /* Clears APSR_nzcvq, APSR_ge */    
    CST_OPCODE_END
    
    MRS     R14,PRIMASK                 /* Save PRIMASK                       */
    
    /**************************************************************************/
    /*  Check internal ADDER logic & input/output ports                       */
    /**************************************************************************/
    /* Test Procedure:                                                        */
    /*  - Internal ADDER logic is tested by using ADC instructions which take */
    /*    all three input operands.                                           */
    /*  - Force to '0' and '1' all bits in input operands                     */
    /*  - Force to '0' and '1' all bits in a result                           */
    /*                                                                        */
    /*    Inputs                                                              */
    /*    A | B | Ci      Note (See, below)                                   */
    /*    ----------------------------------                                  */
    /*    0 | 0 | 0       Case 1                                              */
    /*    0 | 1 | 0       Case 2                                              */
    /*    1 | 0 | 0       Case 3                                              */
    /*    1 | 1 | 0       Case 4                                              */
    /*    0 | 0 | 1       Case 5                                              */
    /*    0 | 1 | 1       Case 6                                              */
    /*    1 | 0 | 1       Case 7                                              */
    /*    1 | 1 | 1       Case 8                                              */
    /*------------------------------------------------------------------------*/  
    MOV     R1, #0x55555555  
    MOV     R12,#0xAAAAAAAA       
    MOVS    R10,#0
    MVN     R0,R10   /* 0xFFFFFFFF */
    
    MSR     APSR_nzcvq,R10  /* Carry = 0 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE           /* Flush pipeline & disable ISRs          */
    /*------------------------------------------------------------------------*/
    ADC     R2,R1,R10               /* Slot0 - 5555 + 0000 + C(0)  Case 1,3   */  
    ADC     R3,R1,R10               /* Slot1 - 5555 + 0000 + C(0)  Case 1,3   */
    ADC     R4,R12,R10              /* Slot0 - AAAA + 0000 + C(0)  Case 1,3   */
    ADC     R5,R12,R10              /* Slot1 - AAAA + 0000 + C(0)  Case 1,3   */
    ADC     R6,R10,R1               /* Slot0 - 0000 + 5555 + C(0)  Case 1,2   */
    ADC     R7,R10,R1               /* Slot1 - 0000 + 5555 + C(0)  Case 1,2   */
    ADC     R8,R10,R12              /* Slot0 - 0000 + AAAA + C(0)  Case 1,2   */
    ADC     R9,R10,R12              /* Slot1 - 0000 + AAAA + C(0)  Case 1,2   */
    ADC     R10,R0,R0               /* Slot0 - FFFF + FFFF + C(0)  Case 4     */
    ADC     R11,R0,R0               /* Slot0 - FFFF + FFFF + C(0)  Case 4     */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */   
    
    /* Decoder: CMP, CMN */
    CMP     R2,R1                   /* CMP(register)  - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end
    CMP     R3,#0x55555555          /* CMP(immediate) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R4,R12                  /* CMP(register)  - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R5,#0xAAAAAAAA          /* CMP(immediate) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R6,R1                   /* CMP(register)  - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end
    CMP     R7,R12,LSR #1           /* CMP(register)  - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end
    CMP     R8,R12                  /* CMP(register)  - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R9,R1,LSL #1            /* CMP(register)  - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end
    CMN     R10,#0x00000002         /* CMN(immediate) - 32bit */
    BNE     m33_cst_alu_test4_end
    CMN     R11,#0x00000002         /* CMN(immediate) - 32bit */
    BNE     m33_cst_alu_test4_end
    
    
    MVN     R10,R0          /* R10 = 0x00000000 */
    MOV     R2,#0x20000000
    MSR     APSR_nzcvq,R2   /* Carry = 1 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE           /* Flush pipeline & disable ISRs          */
    /*------------------------------------------------------------------------*/
    ADC     R2,R10,R10              /* Slot0 - 0000 + 0000 + C(1)  Case 5     */
    ADC     R3,R10,R10              /* Slot1 - 0000 + 0000 + C(1)  Case 5     */
    ADC     R4,R7,R0                /* Slot0 - 5555 + FFFF + C(1)  Case 6,8   */
    ADC     R5,R7,R0                /* Slot1 - 5555 + FFFF + C(1)  Case 6,8   */
    ADC     R6,R9,R0                /* Slot0 - AAAA + FFFF + C(1)  Case 6,8   */
    ADC     R7,R9,R0                /* Slot1 - AAAA + FFFF + C(1)  Case 6,8   */
    ADC     R8,R0,R1                /* Slot0 - FFFF + 5555 + C(1)  Case 7,8   */
    ADC     R9,R0,R1                /* Slot1 - FFFF + 5555 + C(1)  Case 7,8   */
    ADC     R10,R0,R12              /* Slot0 - FFFF + AAAA + C(1)  Case 7,8   */
    ADC     R11,R0,R12              /* Slot1 - FFFF + AAAA + C(1)  Case 7,8   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
     
    /* Decoder: CMP, CMN */
    CMN     R2,#0xFFFFFFFF          /* CMN(immediate) - 32bit */
    BNE     m33_cst_alu_test4_end
    CMP     R3,#0x1                 /* CMP(immediate) - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end
    CMP     R4,R1                   /* CMP(register)  - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end
    CMP     R5,#0x55555555          /* CMP(immediate) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R6,R12                  /* CMP(register)  - 16bit Encoding T2 */          
    BNE     m33_cst_alu_test4_end
    CMP     R7,#0xAAAAAAAA          /* CMP(immediate) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R8,R12,ROR #31          /* CMP(register)  - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end
    CMP     R9,R1                   /* CMP(register)  - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     R10,R1,LSL #1           /* CMP(register)  - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end
    CMP     R11,#0xAAAAAAAA         /* CMP(immediate) - 32bit Encoding T2 */         
    BNE     m33_cst_alu_test4_end
    
    /* !! Update signature !! */
    POP     {R0}
    ADD     R0,R0,R3,LSL #31
    PUSH    {R0}
    
    
    /**************************************************************************/
    /*  Check ALU adder N,Z,C,V flags generation !!                           */
    /**************************************************************************/    
    MOV     R5,#0x80000000  
    MOV     R2,#1
    MOV     R3,#0xFFFFFF00
    MOV     R0,#0
    
    /* Decoder: ADDS (register) - Thumb 16bit */
    MSR     APSR_nzcvq,R0   /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ADDS    R4,R5,R0                /* Slot0 - Sets N Flag */
    ADDS    R4,R5,R5                /* Slot1 - Sets Z,C,V flags */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R7,APSR                 /* Load flag result */
    
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ADDS    R4,R5,R5                /* Slot0 - Sets Z,C,V flags */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R8,APSR                 /* Load flag result */
     
    
    /* Decoder: ADDS (imm8) - Thumb 16bit */
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ADDS    R3,#0xAA                /* Slot0 - Sets N flag  */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */     
    MRS     R9,APSR                 /* Load flag result */
    
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    ADDS    R3,#0x55                /* Slot1 - Sets N flag */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R10,APSR                /* Load flag result */
    
    
    /* Decoder: ADDS (imm3) - Thumb 16bit */
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ADDS    R4,R3,#5                /* Slot0 - Sets C flag  */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R11,APSR                /* Load flag result */
    
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    ADDS    R4,R3,#5        /* Slot1 - Sets C flag */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R12,APSR                /* Load flag result */
    
    
    /* !! Update signature !! */
    /* Decoder: ADD, SBC (register, shift) - 32bit */
    POP     {R6}
    MSR     APSR_nzcvq,R0           /* Clear flags */
    ADD     R7,R6,R7,LSR #28
    ADD     R8,R7,R8,LSR #24
    SBC     R9,R8,R9,ASR #20
    SBC     R10,R9,R10,ASR #16
    ADD     R11,R10,R11,LSL #1
    ADD     R12,R11,R12,LSL #2
    PUSH    {R12}                   /* Store signature */
    
    
    /* Decoder: SUBS (imm3) - Thumb 16bit */
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    SUBS    R6,R4,#4                /* Slot0 - Sets Z,C flag  */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */    
    MRS     R7,APSR                 /* Load flag result */
                            
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    SUBS    R6,R4,#4                /* Slot1 - Sets Z,C flag */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R8,APSR                 /* Load flag result */
    
    
    /* Decoder: SUBS (imm8) - Thumb 16bit */
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    SUBS    R3,#0x55                /* Slot0 - Sets N,C flag  */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R9,APSR                 /* Load flag result */
     
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    SUBS    R3,#0xAA                /* Slot1 - Sets N,C flag */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R10,APSR                /* Load flag result */
    
    
    /* Decoder: SUBS (register) - Thumb 16bit */
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    SUBS    R4,R5,R2                /* Slot0 - Sets C,V Flag */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R11,APSR                /* Load flag result */
    
    MSR     APSR_nzcvq,R0           /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    SUBS    R4,R5,R2                /* Slot1 - Sets C,V Flags */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    MRS     R12,APSR                /* Load flag result */
    
    
    /* !! Update signature !! */
    /* Decoder: ADDC, SUB (register, shift) - 32bit */
    POP     {R6}
    ADC     R7,R6,R7,ROR #27
    ADC     R8,R7,R8,ROR #23
    SUB     R9,R8,R9,ASR #10
    SUB     R10,R9,R10,ASR #15
    ADC     R11,R10,R11,ROR #12
    ADC     R12,R11,R12,ROR #31
    PUSH    {R12}                   /* Store signature */
    
    
    /**************************************************************************/
    /*  Test C flag forwarding  !!                                            */
    /**************************************************************************/
    /* Decoder: ADCS (register) - Thumb 16bit */
    MOV     R3,#0xFFFFFFFF
    MOV     R5,#0
    MOV     R2,#3
    MSR     APSR_nzcvq,R0   /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ADCS    R2,R3   /* Slot0 - Set C flag and  --- */
    ADCS    R5,R5   /* Slot1 - forward here <----- */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    MSR     APSR_nzcvq,R0   /* Clear flags */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP              /* Slot0 */
    ADCS    R2,R3    /* Slot1 - Set C flag and  --- */
    ADCS    R5,R0    /* Slot0 - forward here <----- */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    /* Decoder: CMP (immediate) - 16bit */
    CMP     R5,#2
    BNE     m33_cst_alu_test4_end
    
    
    /* Decoder: SBCS (register) - Thumb 16bit */
    MOV     R4,#0x20000000
    MOV     R6,#0
    MSR     APSR_nzcvq,R4   /* Set C flag */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    SBCS    R2,R3   /* Slot0 - Clear C flag and --- */
    SBCS    R6,R6   /* Slot1 - forward here  <----- */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    MSR     APSR_nzcvq,R4   /* Set C flag */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP             /* Slot0 */
    SBCS    R2,R3   /* Slot1 - Clear C flag and --- */
    SBCS    R6,R0   /* Slot0 - forward here  <----- */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    /* Decoder : CMN (register) - 16bit */
    CMN     R6,R5
    BNE     m33_cst_alu_test4_end
    
    
    /* !! Update signature !! */
    POP     {R10}
    /* Decoder ADD (register) - Thumb 16bit T2 */
    ADD     R10,R5
    ADD     R2,R10
    ADD     R6,R2
    ADD     R5,R6
    PUSH    {R5}                    /* Store signature */
    
    
    /**************************************************************************/
    /* Continue with the decoder testing                                      */
    /*  - test {S} bit is decoded correctly !!                                */
    /**************************************************************************/
    /* ADD{S} (immediate) - 32bit */
    /* SUB{S} (immediate) - 32bit */
    /* ADC{S} (immediate) - 32bit */
    /* SBC{S} (immediate) - 32bit */
    MSR     APSR_nzcvq,R0   /* Clear flags */
    MOV     R2,#0x2
    /*      R1,#0x55555555*/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ADDS    R3,R2,#0xFFFFFFFF       /* Slot0 - Sets C Flag */
    ADD     R4,R2,#0xFFFFFFFF       /* Slot1 */
    ADC     R5,R0,#0x55555555       /* Slot0 */ 
    ADC     R6,R0,#0x55555555       /* Slot1 */    
    SUB     R7,R1,#0xAAAAAAAA       /* Slot0 */
    SUBS    R8,R1,#0xAAAAAAAA       /* Slot1 - Clears C flag */
    SBC     R9,R0,#0x00000000       /* Slot0 */
    SBC     R10,R0,#0x00000000      /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    /* Decoder: CMP, CMN */
    CMP     R3,#1                   /* CMP(immediate) - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end                              
    CMN     R4,#0xFFFFFFFF          /* CMN(immediate) - 32bit */
    BNE     m33_cst_alu_test4_end                              
    CMN     R5,#0xAAAAAAAA          /* CMN(immediate) - 32bit */
    BNE     m33_cst_alu_test4_end                              
    CMP     R6,R5                   /* CMP(register)  - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end                              
    CMN     R7,R1                   /* CMN(register)  - 16bit Encoding T1 */ 
    BNE     m33_cst_alu_test4_end                              
    CMP     R8,R7                   /* CMP(register)  - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end                              
    CMP     R9,#0xFFFFFFFF          /* CMP(immediate) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end                              
    CMN     R10,R4                  /* CMN(register)  - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    
    /* !! Update signature !! */
    POP     {R11}
    RSB     R11,R11,R9,LSR #15
    PUSH    {R11}
    
    /**************************************************************************/
    /* Continue with the decoder testing                                      */
    /**************************************************************************/
    /* RSB (register) */
    /* RSB (immediate) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    RSB     R11,R7,R2,LSL #31       /* RSB(register)  - 32bit */
    RSB     R12,R8,R2,LSL #31       /* RSB(register)  - 32bit */
    CST_OPCODE_START
    CST_OPCODE16(0x426D)           /* RSBS R5,R5,#0  - 16bit Encoding T1 */
    CST_OPCODE16(0x4276)           /* RSBS R6,R6,#0  - 16bit Encoding T1 */
    CST_OPCODE_END
    RSB     R9,R7,R3                /* RSB(register)  - 32bit */
    RSB     R10,R8,R4               /* RSB(register)  - 32bit */
    RSB     R3,R1,#0x66666666       /* RSB(immediate) - 32bit Encoding T2*/
    RSB     R4,R1,#0x66666666       /* RSB(immediate) - 32bit Encoding T2*/
    RSB     R7,R7,#0x33333333       /* RSB(immediate) - 32bit Encoding T2*/
    RSB     R8,R8,#0x33333333       /* RSB(immediate) - 32bit Encoding T2*/
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    /* Decoder: CMP, CMN */
    CMP     R3,R7,LSR #3            /* CMP(register) - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end      
    CMP     R8,R4,LSL #3            /* CMP(register) - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end      
    CMN     R9,R1,ROR #1            /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end      
    CMN     R10,R1,LSL #1           /* CMN(register) - 32bit Encoding T2 */                
    BNE     m33_cst_alu_test4_end      
    CMP     R5,R11,LSL #1           /* CMP(register) - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end      
    CMP     R12,R6,LSR #1           /* CMP(register) - 32bit Encoding T3 */
    BNE     m33_cst_alu_test4_end
    
    /* !! Update signature !! */
    POP     {R7}
    RSB     R7,R7,#0
    PUSH    {R7}
    
    
    /**************************************************************************/
    /* Continue with the decoder testing                                      */
    /**************************************************************************/
    /* ADD, SUB (SP plus/minus immediate)                                     */
    /* ADD, SUB (SP plus/minus register )                                     */
    /**************************************************************************/
    MOV     R1,SP       /* R1 = SP */
    RSB     R7,R1,#0    /* R7 = -SP */
    MOV     R6,#0
    MOV     R5,#0
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    /* Stack pointer is modified => ISRs must disabled !!                     */
    /*------------------------------------------------------------------------*/
    ADD     R5,R5,SP                /* ADD(register)  - 16bit Encoding T1 */
    ADD     R6,R6,SP                /* ADD(register)  - 16bit Encoding T1 */
    ADD     SP,R7                   /* ADD(register)  - 16bit Encoding T2 */           
    ADD     SP,R0                   /* ADD(register)  - 16bit Encoding T2 */           
    SUB     R3,SP,R5                /* SUB(register)  - 32bit Encoding T1 */
    SUB     R4,SP,R6                /* SUB(register)  - 32bit Encoding T1 */
    ADD     SP,#0x54                /* ADD(immediate) - 16bit Encoding T2 */
    ADD     SP,#0x54                /* ADD(immediate) - 16bit Encoding T2 */
    ADD     SP,#0x28                /* ADD(immediate) - 16bit Encoding T2 */
    ADD     SP,#0x28                /* ADD(immediate) - 16bit Encoding T2 */
    SUB     SP,#0x78                /* SUB(immediate) - 16bit Encoding T1 */
    SUB     SP,#0x78                /* SUB(immediate) - 16bit Encoding T1 */
    SUB     SP,#0x04                /* SUB(immediate) - 16bit Encoding T1 */
    SUB     SP,#0x04                /* SUB(immediate) - 16bit Encoding T1 */
    ADD     R1,SP,#0x00AA00AA       /* ADD(immediate) - 32bit Encoding T3 */
    ADD     R2,SP,#0x00AA00AA       /* ADD(immediate) - 32bit Encoding T3 */
    SUB     R7,SP,#0x55005500       /* SUB(immediate) - 32bit Encoding T2 */
    SUB     R8,SP,#0x55005500       /* SUB(immediate) - 32bit Encoding T2 */
    ADD     R9,SP,#0x0003B800       /* ADD(immediate) - 32bit Encoding T3 */
    ADD     R10,SP,#0x0003B800      /* ADD(immediate) - 32bit Encoding T3 */
    SUB     R11,SP,#0x00007700      /* SUB(immediate) - 32bit Encoding T3 */
    SUB     R12,SP,#0x00007700      /* SUB(immediate) - 32bit Encoding T3 */ 
    ADD     SP,R0                   /* ADD(register)  - 16bit Encoding T2 */
    ADD     SP,R5                   /* ADD(register)  - 16bit Encoding T2 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    /* Decoder: CMP, CMN */
    CMP     SP,R5                   /* CMP(register) - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMP     SP,R6                   /* CMP(register) - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     SP,R3                   /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R7,R1,LSL #7            /* CMN(register) - 32bit Encoding T2 */   
    BNE     m33_cst_alu_test4_end
    CMN     R2,R8,ASR #7            /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R11,R9,ASR #3           /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R10,R12,LSL #3          /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    
    /* !! Update signature !! */
    POP     {R2}
    SUB     R2,R2,R9,LSR #12
    PUSH    {R2}
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    /* Stack pointer is modified => ISRs must disabled !!                     */
    /*------------------------------------------------------------------------*/
    ADD     SP,R3   /* SP=0 */      /* ADD(register)  - 16bit Encoding T2 */
    ADD     SP,R0   /* SP=0 */      /* ADD(register)  - 16bit Encoding T2 */
    ADD     R1,SP,#0xCCCCCCCC       /* ADD(immediate) - 32bit Encoding T4 */
    ADD     R2,SP,#0xCCCCCCCC       /* ADD(immediate) - 32bit Encoding T4 */
    SUB     R9,SP,#0x33333333       /* SUB(immediate) - 32bit Encoding T4 */
    SUB     R10,SP,#0x33333333      /* SUB(immediate) - 32bit Encoding T4 */
    ADD     R7,SP,R5                /* ADD(register)  - 32bit Encoding T3 */
    ADD     R8,SP,R6                /* ADD(register)  - 32bit Encoding T3 */
    ADD     R5,SP,#0xAAA            /* ADD(immediate) - 16bit Encoding T1 */
    ADD     R6,SP,#0xAAA            /* ADD(immediate) - 16bit Encoding T1 */
    SUB     R3,SP,#0x555            /* SUB(immediate) - 16bit Encoding T3 */
    SUB     R4,SP,#0x555            /* SUB(immediate) - 16bit Encoding T3 */
    ADD     SP,R7   /* R7=SP */     /* ADD(register)  - 16bit Encoding T2 */
    ADD     SP,R0                   /* ADD(register)  - 16bit Encoding T2 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R14             /* Restore PRIMASK register */
    
    /* Decoder: CMP, CMN */
    CMP     SP,R7                   /* CMP(register) - 16bit Encoding T1 */
    BNE     m33_cst_alu_test4_end
    CMP     SP,R8                   /* CMP(register) - 16bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R9,R1,LSR #2            /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R2,R10,LSL #2           /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R5,R3,LSL #1            /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    CMN     R4,R6,ROR #1            /* CMN(register) - 32bit Encoding T2 */
    BNE     m33_cst_alu_test4_end
    
    /* !! Update signature !! */
    POP     {R1}
    ADD     R1,R1,R5,LSL #16
    PUSH    {R1}
    
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_alu_test4_end:
    /* Test result is returned in R0, according to the conventions */
    POP     {R0}
    B       m33_cst_test_tail_end
    
        
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_ALU_ENABLE */
  
    CST_FILE_END

