/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests ALU0 and ALU1 BARREL SHIFTER unit related logic as well as decoding 
* of the shift instructions. 
* Each time before issuing the tested instructions, the external
* interrupts are disabled and pipeline is flushed to ensure its consistent 
* state.    
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:
*   - LSLS, ASRS, LSRS, RORS (register)
*   - LSLS, ASRS, LSRS, RORS (immediate)
*
* Thumb (32-bit) DECODER:
*   - LSL{S}, ASR{S}, LSR{S}, ROR{S} (register)
*   - LSL{S}, ASR{S}, LSR{S}, ROR{S} (immediate)
*   - RRX{S}
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_ALU_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_AluTest2

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end


    CST_SET(PRESIGNATURE_SEED_0, 0xDE54) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0xF816) /* 3412 */
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_AluTest2" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_AluTest2, function)
M33_Cst_AluTest2:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R2,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.N R4,R2                   /* 00007856 */
    MOV     R2,#0x00000000          /* 00000000 */
    MOVT    R2,#PRESIGNATURE_SEED_1 /* 34120000 */
    ORR     R2,R2,R4                /* 34127856 */
    RBIT    R1,R2                   /* 65872143 */
    REV16.N R4,R1                   /* 87654321 -> PRESIGNATURE = 0x2A7B1F68 */
    MOV     R0,R4
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Initialize C-flag beacause ADCS is used for signature update !! */
    MOV     R1,#0
    
    CST_OPCODE_START
    CST_OPCODE16(0xF381)       /* MSR     APSR,R1 */     
    CST_OPCODE16(0x8C00)       /* Clears APSR_nzcvq, APSR_ge */    
    CST_OPCODE_END
    
    MRS     R12,PRIMASK                 /* Save PRIMASK                       */
    
    
    /**************************************************************************/
    /* Tests BARREL SHIFTER internal logic                                    */
    /*                                                                        */
    /*  Shift both '1' and '0' from every source position to every            */
    /*  destination position.                                                 */
    /**************************************************************************/
    MOV     R1,#0x55555555                  /* Load value to be shifted */
    BL      m33_cst_alu_shift_test_code1    /* Branch & execute testing loop */
    
    MOV     R1,#0xAAAAAAAA                  /* Load value to be shifted */
    BL      m33_cst_alu_shift_test_code1    /* Branch & execute testing loop */
    
    MVN     R1,R0                           /* Load value to be shifted */
    BL      m33_cst_alu_shift_test_code1    /* Branch & execute testing loop */
    
    MVN     R1,R0                           /* Load value to be shifted */
    BL      m33_cst_alu_shift_test_code1    /* Branch & execute testing loop */
    
    /**************************************************************************/
    /* Continue with decoder and N,Z,C flags testing                          */
    /**************************************************************************/
    /* Load to R1,R3,R6 value to be shifted */
    MOV     R1,#0x7FFFFFFF
    MOV     R3,#0x80000000
    MOV     R6,#0xFFFFFFFE
    /* Load shift amounts */
    MOV     R5,#0
    MOV     R4,#31
    MOV     R2,#32
    BL      m33_cst_alu_shift_test_code2    /* Branch & execute testing code */
    
    /* Load to R5,R1 new values to be shifted */
    MOV     R5,#0x80000000
    MOV     R1,#0
    BL      m33_cst_alu_shift_test_code3    /* Branch & execute testing code */
    
    /**************************************************************************/
    /* Continue with RRX & decoder testing                                    */
    /**************************************************************************/
    /* Load to R1,R5,R10 value to be shifted */
    MVN     R1,R0
    MVN     R5,R0
    MVN     R10,R0
    MOV     R2,#0x20000000
    MSR     APSR_nzcvq,R2   /* Set C flag */
    BL      m33_cst_alu_shift_test_code4    /* Branch & execute testing code */
    
    /* Load to R1,R5,R10 value to be shifted */
    MVN     R1,R0
    MVN     R5,R0
    MVN     R10,R0
    MOV     R2,#0
    MSR     APSR_nzcvq,R2   /* Clear C flag */
    BL      m33_cst_alu_shift_test_code4    /* Branch & execute testing code */
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_alu_test2_end:
    /* Test result is returned in R0, according to the conventions */
    B       m33_cst_test_tail_end
    
    
    /**************************************************************************/
    /* BARREL SHIFTER - Test routines                                         */
    /**************************************************************************/
m33_cst_alu_shift_test_code1:
    MOV     R2,#0   /* Clear counter */
    PUSH    {R14}
m33_cst_alu_test2_loop1:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ASR     R4,R1,R2
    ASR     R5,R1,R2
    LSL     R6,R1,R2
    LSL     R7,R1,R2
    LSR     R8,R1,R2
    LSR     R9,R1,R2
    ROR     R10,R1,R2
    ROR     R11,R1,R2
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12     /* Restore PRIMASK register */
    
    /* Update test signature !! */
    BL      m7_alu_test2_sum_r4_r11_to_r0
    
    ADDS    R2,#1
    CMP     R2,#32
    BNE     m33_cst_alu_test2_loop1
    POP     {R15}   /* Return from test routine */

    /**************************************************************************/
    /* Test N,Z,C flags                                                       */  
    /**************************************************************************/
m33_cst_alu_shift_test_code2:
    MSR     APSR_nzcvq,R5   /* Clear Flags */
    /*------------------------------------------------------------------------*/
    /* Test that Slot1 has priority over Slot0 as it is always newer !!       */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    LSLS    R3,R5                   /* Slot0 - Set N flag */
    LSLS    R6,R4                   /* Slot1 - Set C,Z flags */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R6,APSR                 /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ASRS    R5,R5                   /* Slot0 - Set C,Z flag */
    ASRS    R3,R4                   /* Slot1 - Set N flag   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R7,APSR                 /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    LSRS    R3,R5                   /* Slot0 - Set N flag  */
    RORS    R1,R5                   /* Slot1 - Clear flags */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R8,APSR                 /* Load flag result */
    
    /* Test that slot0 sets flags correctly */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    LSRS    R3,R2                   /* Slot0 - Set C,Z flags */    
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R9,APSR                 /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    RORS    R2,R4                   /* Slot0 - Clear flags */    
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R10,APSR                /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    LSLS    R1,R4                   /* Slot0 sets N,C flag */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R11,APSR                /* Load flag result */
    
    /* Update Signature !! */
    B       m7_alu_test2_sum_r6_r11_to_r0
    
    
    /**************************************************************************/
    /* Continue with the decoder testing                                      */
    /*  - test {S} bit is decoded correctly !!                                */
    /**************************************************************************/
m33_cst_alu_shift_test_code3:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    LSLS    R3,R5,#2                /* Slot0 - Set Z Flag */
    NOP
    ASR     R3,R5,#31               /* Slot0 - N Flag is not set !! */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R8,APSR                 /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ASRS    R4,R5,R1                /* Slot0 - Set N Flag */
    NOP
    LSL     R4,R1,R1                /* Slot0 - Z flag is not set !! */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R9,APSR                 /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    LSRS    R5,R3,#31               /* Slot1 - Set C flag */
    NOP
    LSL     R5,R3,#1                /* Slot1 - N,C flags are not set */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R10,APSR                /* Load flag result */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    RORS    R6,R4,R1                /* Slot1 - Set Z flag */
    NOP
    ROR     R6,R3,R1                /* Slot1 - N flag is not set !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12             /* Restore PRIMASK register */
    MRS     R11,APSR                /* Load flag result */
    
    /* Update Signature !! */
    B       m7_alu_test2_sum_r3_r11_to_r0
    
    
    /**************************************************************************/
    /* Continue with the decoder testing                                      */
    /*  - SHIFT (immediate) decoding                                          */
    /*  - RRX decoding                                                        */
    /**************************************************************************/
m33_cst_alu_shift_test_code4:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ASR     R2 ,R5,#28
    ASR     R3 ,R5,#3
    LSL     R4 ,R5,#21
    LSL     R5 ,R1,#10
    LSR     R6 ,R10,#25
    LSR     R7 ,R10,#6
    ROR     R8 ,R10,#24
    ROR     R9, R10,#7
    RRX     R10,R1
    RRX     R11,R1
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12     /* Restore PRIMASK register */
    
    
    /**************************************************************************/
    /* Update test signature here                                             */
    /**************************************************************************/
    ADCS    R0,R2
m7_alu_test2_sum_r3_r11_to_r0:
    ADCS    R0,R3
m7_alu_test2_sum_r4_r11_to_r0:
    ADCS    R0,R4
    ADCS    R0,R5
m7_alu_test2_sum_r6_r11_to_r0:
    ADCS    R0,R6
    ADCS    R0,R7
    ADCS    R0,R0,R8
    ADCS    R0,R0,R9
    ADCS    R0,R0,R10
    ADCS    R0,R0,R11
    BX      LR
    
        
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_ALU_ENABLE */
    
    CST_FILE_END

