/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "CorTst_Compiler.h"

    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT m33_cst_ISR_dispatcher
    CST_EXPORT m33_cst_ISR_address
    CST_EXPORT m33_cst_user_VTOR
    
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_DATA_ALIGN(mcal_bss, CST_BYTES_4)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_4
m33_cst_user_VTOR:
    CST_ALLOC_BYTES(4)
m33_cst_ISR_address:
    CST_ALLOC_BYTES(4)


    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC_ALIGN(mcal_text, CST_BYTES_4)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_4
    CST_THUMB2
    CST_TYPE(m33_cst_ISR_dispatcher, function)
m33_cst_ISR_dispatcher:
    
    /**************************************************************************/
    /* !!! We have to find CST exception !!!                                  */
    /**************************************************************************/
    CMP     R10, #0x5A
    BEQ     m33_cst_check_isr_num
    /* Check ISR address */
    LDR     R1,[SP,#0]      /* Load stacked R0 register !!! */
    LDR     R3,[SP,#24]     /* Load stacked return address */
    CMP     R1,R3
    BNE     m33_cst_pass_control_to_alien_ISR

m33_cst_check_isr_num:
    /* Check ISR vector */
    LDR     R1,[SP,#8]      /* Load stacked R2 register */
    MRS     R3,IPSR         /* Load IPSR register */
    CMP     R1,R3
    BNE     m33_cst_pass_control_to_alien_ISR   

    /*************************************************************************/
    /*  !!! CST exception was recognized !!!                                */
    /*************************************************************************/
m33_cst_pass_control_to_cst_ISR:

    LDR     R1,=m33_cst_ISR_address
    LDR     R3,[R1]
    /*************************************************************************/
    BX      R3      /* -> Pass control to CST ISR !!                        */
    /*************************************************************************/

        
    /*************************************************************************/
    /* Alien interrupt was detected !!! */
    /*************************************************************************/
m33_cst_pass_control_to_alien_ISR:

    LDR     R3,=m33_cst_user_VTOR
    LDR     R1,[R3]     /* Load R1 with content of user_VTOR variable */
    MRS     R3,IPSR     /* IPSR contains IRQ number of the current ISR */
    LSL     R3,R3,#2    /* Multiplied by 4 to get offset address of the ISR. */
    ADD     R1,R3,R1    /* Add offset to the base address of the user vtable. */
    LDR     R3,[R1]     /* Load the address of the corresponding user ISR... */
    /*************************************************************************/
    BX      R3          /* -> Pass control to user interrupt  !!             */
    /*************************************************************************/
    
    
    CST_ALIGN_BYTES_4
    CST_LTORG
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_FILE_END

