# 项目名称: SafLib_Demo
---
## 功能描述

+ 此示例将 SafLib 与 YUNTU MCAL 模块集成到一个项目中。
+ 它旨在演示启动测试和运行时测试支持。
+ 启动测试仅在系统启动时执行一次，用于首次芯片上电复位（POR），而运行时测试在主循环中周期性执行。
+ **ClkTst** 在`Mcu_Init()`之前进行测试，以确保时钟可以正常使用。
+ **WdgTst** 在启动测试结束时调用，以确保它可以触发系统复位，从而重置启动测试期间使用的所有外设和模块。
+ 示例中使用了以下模块：
  + **SafLib**: 集成 SafLib 提供与安全相关的硬件安全机制自检或软件安全机制。
    + **IntTst**: 集成 **INTM** 模块和 **pTMR** 驱动，用于测试中断监控通道。
    + **WdgTst**: 集成 **WDG** 和 **EWDG** 驱动，用于测试看门狗定时器功能。
    + **CorTst**: AUTOSAR 标准化模块，测试 CPU 核心的 ALU、加载/存储指令、MPU、FPU 和异常功能，包含多个原子测试用例。
    + **FlsTst**: AUTOSAR 标准化模块，测试 Flash 内存数据完整性。
    + **RamTst**: AUTOSAR 标准化模块，测试 RAM 内存健康状态。
    + **ClkTst**: 系统时钟监控功能的自检。
    + **EfmTst**: EFM 程序/擦除保护功能的自检。
    + **CrcTst**: CRC 和硬件寄存器保护功能的自检。
    + **PpuTst**: 外设配置寄存器功能的自检。
    + **StkTst**: 软件实现的指定系统堆栈溢出检测和报告的自检。
    + **DmaTst**: DMA 数据传输和错误检测与报告功能的自检。
    + **EccTst**: CAN、SRAM 和 FLASH 的 ECC 错误检测与报告功能的自检。
  + **MCAL**: 用户应用的功能外设驱动。
    + **YT-LINK**: 用于配置链接文件。
    + **Platform**: MPU 和中断配置。
    + **Mcu**: 系统初始化和时钟配置。
    + **Wdg**: 看门狗定时器模块，用于触发看门狗测试。
    + **Gpt**: 一个通道用于用户 Dio LED 切换测试，另一个通道用于看门狗触发服务。
    + **Dio**: 一个通道用于用户 LED 切换测试。
    + **Port**: 用户 LED 切换测试的端口配置。
    + **CddUart**: UART 驱动模块，用于将测试结果打印到控制台。
    + **Fls**: 为 FlsTst、EccTst 和 EfmTst 模块提供 Flash 扇区配置。
    + **Crc**: 为 FlsTst 提供 AUTOSAR 标准化 CRC 驱动。
  + **Stub 模块**:
    + **Rte**: 为 SafLib 和 MCAL 模块的所有模块提供 SchM 保护。
    + **Det**: 功能参数检查、模块状态检查和错误报告。
    + **WdgIf**: 看门狗接口模块，WdgTst 模块所需的头文件。
    + **MemIf**: 内存接口模块，Fls 模块所需的头文件。
---
## 设置步骤

+ ***步骤1***: 使用 YCT 工具打开 ***SafLib_Demo.yct***，根据需要配置工具链（默认使用 VS Code + GCC）。
+ ***步骤2***: 生成代码，如果需要，可以更改配置以适应自己的硬件设计。如果更改，请确保所有修改无错误后再生成代码。
+ ***步骤3***: 使用 VS Code/IAR/Keil IDE 打开生成的项目。
+ ***步骤4***: 编译项目，给 EVB 上电，并通过可用的调试器（如 J-LINK 调试探针）将代码下载到 EVB。
+ ***步骤5***：使用 YCT 工具生成具有**签名的 .hex** 文件。在YCT工具中，启用 **FlsTstFwPath**，将**步骤4**中编译生成的.hex 文件导入到 YCT 中，生成具有签名的 .hex文件，如下图所示：
![API](GenHex.jpg)
打开 EVB 电源并通过可用的调试器（如 J-Link）将具有签名的 .hex 下载到 EVB中。
---
***提示***: 此处输入的 .hex 文件路径为相对路径，该相对路径基于 YCT 工程文件所在位置。新生成的.hex 文件和源文件处于同一目录 。

---
+ ***步骤6***: 点击 **运行**（快捷键 `F5`）按钮运行程序，您可以看到如下串口控制台输出：
![API](Start-to-run.jpg) 
从控制台输出中，您可以看到运行时测试的测试结果（启动测试被跳过，因为这不是 POR 复位），例如：
![API](runtime-test-UART-console-output.jpg) 
支持运行时测试的已配置 SafLib 模块的测试会在主循环中重复执行，因此您可以在控制台输出中看到每个模块的测试结果。
同时，看门狗会定期被喂养，蓝色用户 LED（**LED5**）每秒会由 Gpt 通道 0 切换一次，用于指示程序正常运行。
---
***提示***: 如果任何模块测试失败，测试结果会打印到控制台，如下所示：
```C
SafLib Test Error Notification Entered: ModuleId = <Module_Id>
The SafLib runtime test is running with at least one error!
```

***提示***: 为避免 SafLib 运行时测试期间连续触发断点，应禁用 CPU 核心异常的所有 Vector Catch。

---

+ ***步骤7***: 如果 EVB 断电后重新上电，启动测试将被执行，串口控制台输出如下（启动测试后，运行时测试将按 **步骤6** 周期性执行）：
![API](startup-test-UART-console-output.jpg)

***注意***: UART 串口应配置为 `115200` 波特率，`8` 数据位，`无` 校验位，`1` 停止位，`无` 流控。

## 硬件需求

- **评估板（EVB）**：YTM32B1ME0-Q144-EVB-Rev.B/C
- **调试器**：J-Link HW v9.2或更高版本，安装有YUNTU `YTM32B1ME0` 补丁（支持包）。

***注意***: 请确认EVB底部的版本号，如果是***YTM32B1ME0-EVB-Q144 Rev.C***，`YTMEVB_Demo`、`Icu_Demo`和`Dio_Demo`请使用以**_RevC**结尾的样例工程。

---

## 软件需求

- **配置与代码生成工具**：
  - **MCAL**：Yuntu Config Tool（YCT）v2.7.0或更高版本
- **编译器工具链**：
  - **GCC**：GNU GCC v10.3或更高版本
  - **Keil/MDK**：ARM Keil/MDK v5.36或更高版本(编译器推荐使用`armclang v6.18.2`)
  - **IAR**：IAR v9.50或更高版本
  - **VS Code**：Microsoft Visual Studio Code IDE v1.76或更高版本（需安装C/C++支持、GNU工具链、CMake v3.25、ninja、Cortex-Debug扩展）
- **调试器驱动**：
  - **J-Link**：SEGGER J-Link v7.82或更高版本，需安装YUNTU `YTM32B1ME0` 补丁（支持包）。
  - **Ozone调试工具**：SEGGER Ozone v3.28或更高版本。

  ***注意***: 需要安装 **YTM32B1ME0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.


---