/**
* @file    Dem.c
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Dem
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.3.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
#include "Dem.h"



/*==================================================================================================
                                      SOURCE FILE VERSION INFORMATION                                
==================================================================================================*/
#define DEM_VENDOR_ID_C                      (180)
#define DEM_AR_RELEASE_MAJOR_VERSION_C       (4)
#define DEM_AR_RELEASE_MINOR_VERSION_C       (4)
#define DEM_AR_RELEASE_REVISION_VERSION_C    (0)
#define DEM_SW_MAJOR_VERSION_C               (2)
#define DEM_SW_MINOR_VERSION_C               (3)
#define DEM_SW_PATCH_VERSION_C               (0)
/*==================================================================================================
                                            FILE VERSION CHECKS                                      
==================================================================================================*/
/* Check if source file and DEM header file are of the same vendor */
#if (DEM_VENDOR_ID_C != DEM_VENDOR_ID)
#error "Dem.c and Dem.h have different vendor ids"
#endif

/* Check if source file and DEM header file are of the same Autosar version */
#if (( DEM_AR_RELEASE_MAJOR_VERSION_C != DEM_AR_RELEASE_MAJOR_VERSION) || \
      ( DEM_AR_RELEASE_MINOR_VERSION_C != DEM_AR_RELEASE_MINOR_VERSION) || \
      ( DEM_AR_RELEASE_REVISION_VERSION_C != DEM_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of Dem.c and Dem.h are different"
#endif

/* Check if source file and DEM header file are of the same Software version */
#if (( DEM_SW_MAJOR_VERSION_C != DEM_SW_MAJOR_VERSION) || \
      ( DEM_SW_MINOR_VERSION_C != DEM_SW_MINOR_VERSION) || \
      ( DEM_SW_PATCH_VERSION_C != DEM_SW_PATCH_VERSION))
#error "Software Version Numbers of Dem.c and Dem.h are different"
#endif

/*==================================================================================================
                                                GLOBAL VARIABLES                                       
==================================================================================================*/

Dem_EventIdType Dem_EventId[DEM_EVENT_ID];                 /**< @brief DEM event ID*/
Dem_EventStatusType Dem_EventStatus[DEM_EVENT_STATUS];             /**< @brief DEM event status*/
boolean               Dem_EventOverflowFlag = FALSE;                /**< @brief DEM Overflow Event Flag*/
uint32             Dem_numEventErrors=0;               /**< @brief DEM event number of errors*/


/*==================================================================================================
                                                LOCAL VARIABLES                                        
==================================================================================================*/
/*==================================================================================================
                                                LOCAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                LOCAL MACROS                                           
==================================================================================================*/
/*==================================================================================================
                                                LOCAL FUNCTIONS                                        
==================================================================================================*/
/*==================================================================================================
                                                GLOBAL FUNCTIONS                                       
==================================================================================================*/
Std_ReturnType Dem_SetEventStatus(Dem_EventIdType EventId, Dem_EventStatusType EventStatus)
{
    if(DEM_EVENT_ID > Dem_numEventErrors)
    {
        Dem_EventId[Dem_numEventErrors] = EventId;
        Dem_EventStatus[Dem_numEventErrors] = EventStatus;
        Dem_numEventErrors++;
    }
    else
    {
        Dem_EventOverflowFlag = TRUE;
        Dem_numEventErrors=0;
        Dem_EventId[Dem_numEventErrors] = EventId;
        Dem_EventStatus[Dem_numEventErrors] = EventStatus;
        Dem_numEventErrors++;
    }

    return(E_OK);
}

#ifdef __cplusplus
}
#endif

/* End of file Dem.c */


