/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"


void INT_SYS_ConfigInit()
{
    INT_SYS_DisableIRQGlobal();
    /* EFM_Ecc_IRQn(37) EFM_Ecc_IRQHandler*/
    INT_SYS_SetPriority(EFM_Ecc_IRQn,6);
    INT_SYS_EnableIRQ(EFM_Ecc_IRQn);
    /* WDG0_IRQn(38) WDG0_IRQHandler*/
    INT_SYS_SetPriority(WDG0_IRQn,6);
    INT_SYS_EnableIRQ(WDG0_IRQn);
    /* LINFlexD0_IRQn(45) LINFlexD0_IRQHandler*/
    INT_SYS_SetPriority(LINFlexD0_IRQn,6);
    INT_SYS_EnableIRQ(LINFlexD0_IRQn);
    /* CAN0_ORed_BusOff_Warning_IRQn(84) CAN0_ORed_BusOff_Warning_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_BusOff_Warning_IRQn,6);
    INT_SYS_EnableIRQ(CAN0_ORed_BusOff_Warning_IRQn);
    /* CAN0_Error_IRQn(85) CAN0_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN0_Error_IRQn,6);
    INT_SYS_EnableIRQ(CAN0_Error_IRQn);
    /* CAN0_Wake_Up_IRQn(86) CAN0_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN0_Wake_Up_IRQn,6);
    INT_SYS_EnableIRQ(CAN0_Wake_Up_IRQn);
    /* CAN0_ORed_0_15_MB_IRQn(87) CAN0_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_0_15_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN0_ORed_0_15_MB_IRQn);
    /* CAN0_ORed_16_31_MB_IRQn(88) CAN0_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_16_31_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN0_ORed_16_31_MB_IRQn);
    /* CAN1_ORed_BusOff_Warning_IRQn(95) CAN1_ORed_BusOff_Warning_IRQHandler*/
    INT_SYS_SetPriority(CAN1_ORed_BusOff_Warning_IRQn,6);
    INT_SYS_EnableIRQ(CAN1_ORed_BusOff_Warning_IRQn);
    /* CAN1_Error_IRQn(96) CAN1_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN1_Error_IRQn,6);
    INT_SYS_EnableIRQ(CAN1_Error_IRQn);
    /* CAN1_Wake_Up_IRQn(97) CAN1_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN1_Wake_Up_IRQn,6);
    INT_SYS_EnableIRQ(CAN1_Wake_Up_IRQn);
    /* CAN1_ORed_0_15_MB_IRQn(98) CAN1_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN1_ORed_0_15_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN1_ORed_0_15_MB_IRQn);
    /* CAN1_ORed_16_31_MB_IRQn(99) CAN1_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN1_ORed_16_31_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN1_ORed_16_31_MB_IRQn);
    /* CAN2_ORed_BusOff_Warning_IRQn(106) CAN2_ORed_BusOff_Warning_IRQHandler*/
    INT_SYS_SetPriority(CAN2_ORed_BusOff_Warning_IRQn,6);
    INT_SYS_EnableIRQ(CAN2_ORed_BusOff_Warning_IRQn);
    /* CAN2_Error_IRQn(107) CAN2_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN2_Error_IRQn,6);
    INT_SYS_EnableIRQ(CAN2_Error_IRQn);
    /* CAN2_Wake_Up_IRQn(108) CAN2_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN2_Wake_Up_IRQn,6);
    INT_SYS_EnableIRQ(CAN2_Wake_Up_IRQn);
    /* CAN2_ORed_0_15_MB_IRQn(109) CAN2_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN2_ORed_0_15_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN2_ORed_0_15_MB_IRQn);
    /* CAN2_ORed_16_31_MB_IRQn(110) CAN2_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN2_ORed_16_31_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN2_ORed_16_31_MB_IRQn);
    /* LINFlexD5_IRQn(167) LINFlexD5_IRQHandler*/
    INT_SYS_SetPriority(LINFlexD5_IRQn,6);
    INT_SYS_EnableIRQ(LINFlexD5_IRQn);
    /* CAN3_ORed_BusOff_Warning_IRQn(172) CAN3_ORed_BusOff_Warning_IRQHandler*/
    INT_SYS_SetPriority(CAN3_ORed_BusOff_Warning_IRQn,6);
    INT_SYS_EnableIRQ(CAN3_ORed_BusOff_Warning_IRQn);
    /* CAN3_Error_IRQn(173) CAN3_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN3_Error_IRQn,6);
    INT_SYS_EnableIRQ(CAN3_Error_IRQn);
    /* CAN3_Wake_Up_IRQn(174) CAN3_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN3_Wake_Up_IRQn,6);
    INT_SYS_EnableIRQ(CAN3_Wake_Up_IRQn);
    /* CAN3_ORed_0_15_MB_IRQn(175) CAN3_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN3_ORed_0_15_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN3_ORed_0_15_MB_IRQn);
    /* CAN3_ORed_16_31_MB_IRQn(176) CAN3_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN3_ORed_16_31_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN3_ORed_16_31_MB_IRQn);
    /* CAN4_ORed_BusOff_Warning_IRQn(179) CAN4_ORed_BusOff_Warning_IRQHandler*/
    INT_SYS_SetPriority(CAN4_ORed_BusOff_Warning_IRQn,6);
    INT_SYS_EnableIRQ(CAN4_ORed_BusOff_Warning_IRQn);
    /* CAN4_Error_IRQn(180) CAN4_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN4_Error_IRQn,6);
    INT_SYS_EnableIRQ(CAN4_Error_IRQn);
    /* CAN4_Wake_Up_IRQn(181) CAN4_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN4_Wake_Up_IRQn,6);
    INT_SYS_EnableIRQ(CAN4_Wake_Up_IRQn);
    /* CAN4_ORed_0_15_MB_IRQn(182) CAN4_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN4_ORed_0_15_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN4_ORed_0_15_MB_IRQn);
    /* CAN4_ORed_16_31_MB_IRQn(183) CAN4_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN4_ORed_16_31_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN4_ORed_16_31_MB_IRQn);
    /* CAN5_ORed_BusOff_Warning_IRQn(186) CAN5_ORed_BusOff_Warning_IRQHandler*/
    INT_SYS_SetPriority(CAN5_ORed_BusOff_Warning_IRQn,6);
    INT_SYS_EnableIRQ(CAN5_ORed_BusOff_Warning_IRQn);
    /* CAN5_Error_IRQn(187) CAN5_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN5_Error_IRQn,6);
    INT_SYS_EnableIRQ(CAN5_Error_IRQn);
    /* CAN5_Wake_Up_IRQn(188) CAN5_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN5_Wake_Up_IRQn,6);
    INT_SYS_EnableIRQ(CAN5_Wake_Up_IRQn);
    /* CAN5_ORed_0_15_MB_IRQn(189) CAN5_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN5_ORed_0_15_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN5_ORed_0_15_MB_IRQn);
    /* CAN5_ORed_16_31_MB_IRQn(190) CAN5_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN5_ORed_16_31_MB_IRQn,6);
    INT_SYS_EnableIRQ(CAN5_ORed_16_31_MB_IRQn);
    INT_SYS_EnableIRQGlobal();
}
