/**
****************************************************************************************
* @file    : bsp_uart.h
* @author  : Samir
* @version : V1.0
* @date    : 2024-09-05
* @brief   : ͷļ
****************************************************************************************
*/
#ifndef __BSP_UART_H
#define __BSP_UART_H

#include "./config/bsp_config.h"

/************************************ ӿ *************************************/
typedef enum    /* uart  */
{
    UART_0 = 0U,
    UART_1,
    UART_2,
    UART_3,
    UART_4,
    UART_5,
    UART_6,
    UART_7,
    UART_8,
    UART_9
} uart_number_t;

#define UART_BUFFER_SIZE        (128)   /* ݻС */
#define UART_QUEUE_QUANTITY     (10)    /* ڶеϢ */
#define UART_TX_TIMEOUT         (50)    /* ķʽʱĳʱʱ */

typedef struct
{
    uint8_t buffer[UART_BUFFER_SIZE];   /* ݵĿռ */
    uint16_t size;                      /* ѴݵĴС */
} uart_data_t;                          /* 洢봮صݽṹ */

/* ӦøĶ */
#define UART0_SWITCH            (1)     /* ڿ 0:ر 1: */
#define UART1_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART2_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART3_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART4_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART5_SWITCH            (1)     /* ڿ 0:ر 1: */
#define UART6_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART7_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART8_SWITCH            (0)     /* ڿ 0:ر 1: */
#define UART9_SWITCH            (0)     /* ڿ 0:ر 1: */

/************************************    UART0    *************************************/
#if UART0_SWITCH
extern __IO bool g_u0_rx_flag;                          /* ״̬־ */
extern __IO bool g_u0_tx_flag;                          /* ״̬־ */
extern __IO bool g_u0_rx_timeout_flag;                  /* ճʱ־ */
extern QueueHandle_t u0_rx_queue_handle;                /* 0նо */
extern uart_data_t bsp_u0_rx_queue[UART_QUEUE_QUANTITY]; /* ŴݵĶл */
#endif

/************************************    UART1    *************************************/
#if UART1_SWITCH
extern __IO bool g_u1_rx_flag;                          /* ״̬־ */
extern __IO bool g_u1_tx_flag;                          /* ״̬־ */
extern __IO bool g_u1_rx_timeout_flag;                  /* ճʱ־ */
extern QueueHandle_t u1_rx_queue_handle;                /* 1նо */
extern uart_data_t bsp_u1_rx_queue[UART_QUEUE_QUANTITY]; /* ŴݵĶл */
#endif

/************************************    UART3    *************************************/
#if UART3_SWITCH
extern __IO bool g_u3_rx_flag;                          /* ״̬־ */
extern __IO bool g_u3_tx_flag;                          /* ״̬־ */
extern __IO bool g_u3_rx_timeout_flag;                  /* ճʱ־ */
extern QueueHandle_t u3_rx_queue_handle;                /* 3նо */
extern uart_data_t bsp_u3_rx_queue[UART_QUEUE_QUANTITY]; /* ŴݵĶл */
#endif

/************************************    UART5    *************************************/
#if UART5_SWITCH
extern __IO bool g_u5_rx_flag;                          /* ״̬־ */
extern __IO bool g_u5_tx_flag;                          /* ״̬־ */
extern __IO bool g_u5_rx_timeout_flag;                  /* ճʱ־ */
extern QueueHandle_t u5_rx_queue_handle;                /* 5նо */
extern uart_data_t bsp_u5_rx_queue[UART_QUEUE_QUANTITY]; /* ŴݵĶл */
#endif

/************************************ ӿں *************************************/
void bsp_uart_init(uart_number_t uart_num);
uint8_t bsp_uart_send(uart_number_t uart_num, uint8_t *data, uint16_t len);
uint8_t bsp_receive_data(uart_number_t uart_num, uint8_t *data, uint16_t len);
void bsp_uart_queue_send(uart_data_t *uart_queue, uint32_t remain_num,
                       QueueHandle_t queue_handle, __IO uint8_t *queue_count);
#endif /* __BSP_UART_H */
