/**
****************************************************************************************
* @file    : bsp_uart.c
* @author  : Samir
* @version : V1.0
* @date    : 2024-09-05
* @brief   : ļ
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include <stdarg.h>
#include <stddef.h>
#include "./uart/bsp_uart.h"
#include "linflexd_uart_config.h"
#include "dma_config.h"
#include "linflexd_hw_access.h"


static void replace_control_chars(const char *input, char *output); /* 滻ַΪתַ */


linflexd_uart_idle_timeout_config_t uart_idle_timeout_config = {
    .enableIdleTimeout = true,
    .idleTimeoutCount = UART_TX_TIMEOUT
};

#if UART0_SWITCH
uint32_t gul_u0_rx_remain_num = 0;      /* ʣյֽ */
__IO bool g_u0_rx_flag = false;         /* ״̬ */
__IO bool g_u0_tx_flag = false;         /* ״̬ */
__IO bool g_u0_rx_timeout_flag = false; /* ճʱ־ */
uart_data_t bsp_u0_rx_queun[UART_QUEUE_QUANTITY] = {0}; /* ŴݵĶл */
__IO uint8_t uc_rx_msg_count0 = 0; /* ¼յݴڶеĸĿ */
#endif

#if UART1_SWITCH
uint32_t gul_u1_rx_remain_num = 0;      /* ʣյֽ */
__IO bool g_u1_rx_flag = false;         /* ״̬ */
__IO bool g_u1_tx_flag = false;         /* ״̬ */
__IO bool g_u1_rx_timeout_flag = false; /* ճʱ־ */
uart_data_t bsp_u1_rx_queun[UART_QUEUE_QUANTITY] = {0}; /* ŴݵĶл */
__IO uint8_t uc_rx_msg_count1 = 0; /* ¼յݴڶеĸĿ */
#endif

#if UART2_SWITCH
uint32_t gul_u3_rx_remain_num = 0;      /* ʣյֽ */
__IO bool g_u3_rx_flag = false;         /* ״̬ */
__IO bool g_u3_tx_flag = false;         /* ״̬ */
__IO bool g_u3_rx_timeout_flag = false; /* ճʱ־ */
uart_data_t bsp_u3_rx_queun[UART_QUEUE_QUANTITY] = {0}; /* ŴݵĶл */
__IO uint8_t uc_rx_msg_count3 = 0; /* ¼յݴڶеĸĿ */
#endif

#if UART5_SWITCH
uint32_t gul_u5_rx_remain_num = 0;      /* ʣյֽ */
__IO bool g_u5_rx_flag = false;         /* ״̬ */
__IO bool g_u5_tx_flag = false;         /* ״̬ */
__IO bool g_u5_rx_timeout_flag = false; /* ճʱ־ */
uart_data_t bsp_u5_rx_queun[UART_QUEUE_QUANTITY] = {0}; /* ŴݵĶл */
__IO uint8_t uc_rx_msg_count5 = 0; /* ¼յݴڶеĸĿ */
#endif

#if UART0_SWITCH
/* 0ջص */
static void uart0_rx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    uart_data_t *p_uart_data = NULL;          /* ݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u0_rx_flag = true;
        LOG_ERROR(15, "\nu0_EVENT_END\r\n");
    }
    else if (event == UART_EVENT_TIMEOUT)
    {
        g_u0_rx_timeout_flag = true;
        LINFlexD_UART_DRV_GetReceiveStatus(UART_0, &gul_u0_rx_remain_num);

        /* յݷ */
        bsp_uart_queue_send(bsp_u0_rx_queun, gul_u0_rx_remain_num, u0_rx_queue_handle, &uc_rx_msg_count0); 
    }
    bsp_receive_data(UART_0, bsp_u0_rx_queun[uc_rx_msg_count0].buffer, UART_BUFFER_SIZE); /* ڽ */
}

/* 0ͻص */
static void uart0_tx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u0_tx_flag = true;
    }                               
}

/* 0ص */
static void uart0_erro_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_ERROR)
    {
        LOG_ERROR(15, "\nu0_EVENT_RX_ERROR\r\n");
        
        memset(bsp_u0_rx_queun[uc_rx_msg_count0].buffer, 0, UART_BUFFER_SIZE);
        /* ڽ */
        bsp_receive_data(UART_0, bsp_u0_rx_queun[uc_rx_msg_count0].buffer, UART_BUFFER_SIZE); 
    }
}
#endif /* UART0_SWITCH */

#if UART1_SWITCH
/* 1ջص */
static void uart1_rx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    uart_data_t *p_uart_data = NULL;          /* ݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u1_rx_flag = true;
        LOG_INFO_FAILED(15, "\nu1_EVENT_END\r\n");
    }
    else if (event == UART_EVENT_TIMEOUT)
    {
        g_u1_rx_timeout_flag = true;
        LINFlexD_UART_DRV_GetReceiveStatus(UART_1, &gul_u1_rx_remain_num);

        /* յݷ */
        bsp_uart_queue_send(bsp_u1_rx_queun, gul_u1_rx_remain_num, u1_rx_queue_handle, &uc_rx_msg_count1); 
    }
    bsp_receive_data(UART_1, bsp_u1_rx_queun[uc_rx_msg_count1].buffer, UART_BUFFER_SIZE); /* ڽ */
}

/* 1ͻص */
static void uart1_tx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u1_tx_flag = true;
    }
}

/* 1ص */
static void uart1_erro_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_ERROR)
    {
        LOG_INFO_FAILED(15, "\nu1_EVENT_RX_ERROR\r\n");
        
        memset(bsp_u1_rx_queun[uc_rx_msg_count1].buffer, 0, UART_BUFFER_SIZE);
        /* ڽ */
        bsp_receive_data(UART_1, bsp_u1_rx_queun[uc_rx_msg_count1].buffer, UART_BUFFER_SIZE); 
    }
}
#endif /* UART1_SWITCH */

#if UART3_SWITCH
/* 3ջص */
static void uart3_rx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    uart_data_t *p_uart_data = NULL;          /* ݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u3_rx_flag = true;
        LOG_INFO_FAILED(15, "\nu3_EVENT_END\r\n");
    }
    else if (event == UART_EVENT_TIMEOUT)
    {
        g_u3_rx_timeout_flag = true;
        LINFlexD_UART_DRV_GetReceiveStatus(UART_3, &gul_u3_rx_remain_num);

        /* յݷ */
        bsp_uart_queue_send(bsp_u3_rx_queun, gul_u3_rx_remain_num, u3_rx_queue_handle, &uc_rx_msg_count3); 
    }
    bsp_receive_data(UART_3, bsp_u3_rx_queun[uc_rx_msg_count3].buffer, UART_BUFFER_SIZE); /* ڽ */
}

/* 3ͻص */
static void uart3_tx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u3_tx_flag = true;
    }
}

/* 3ص */
static void uart3_erro_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_ERROR)
    {
        LOG_INFO_FAILED(15, "\nu3_EVENT_RX_ERROR\r\n");
        
        memset(bsp_u3_rx_queun[uc_rx_msg_count3].buffer, 0, UART_BUFFER_SIZE);
        /* ڽ */
        bsp_receive_data(UART_3, bsp_u3_rx_queun[uc_rx_msg_count3].buffer, UART_BUFFER_SIZE); 
    }
}
#endif /* UART3_SWITCH */

#if UART5_SWITCH
/* 5ջص */
static void uart5_rx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    uart_data_t *p_uart_data = NULL;          /* ݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u5_rx_flag = true;
        LOG_ERROR(15, "u5_EVENT_END\r\n");
    }
    else if (event == UART_EVENT_TIMEOUT)
    {
        g_u5_rx_timeout_flag = true;
        LINFlexD_UART_DRV_GetReceiveStatus(UART_5, &gul_u5_rx_remain_num);

        /* յݷ */
        bsp_uart_queue_send(bsp_u5_rx_queun, gul_u5_rx_remain_num, u5_rx_queue_handle, &uc_rx_msg_count5); 
    }
    bsp_receive_data(UART_5, bsp_u5_rx_queun[uc_rx_msg_count5].buffer, UART_BUFFER_SIZE); /* ڽ */
}

/* 5ͻص */
static void uart5_tx_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_END_TRANSFER)
    {
        g_u5_tx_flag = true;
    }
}

/* 5ص */
static void uart5_erro_callback(void *LINFLexDState, uart_event_t event, void *userData)
{
    (void)LINFLexDState;
    (void)userData;
    if (event == UART_EVENT_ERROR)
    {
        LOG_ERROR(15, "\nu5_EVENT_RX_ERROR\r\n");
        
        memset(bsp_u5_rx_queun[uc_rx_msg_count5].buffer, 0, UART_BUFFER_SIZE);
        /* ڽ */
        bsp_receive_data(UART_5, bsp_u5_rx_queun[uc_rx_msg_count5].buffer, UART_BUFFER_SIZE); 
    }
}
#endif /* UART5_SWITCH */

/**
 * @brief   ʼ
 * @param   uart_num:ڱ
 * @author  Samir
 * @version 1.0
 * @date    2024-11-21
 */
void bsp_uart_init(uart_number_t uart_num)
{
#if UART0_SWITCH
    if (uart_num == UART_0)
    {
        LINFlexD_UART_DRV_Init(UART_0, &linflexd_uart0_config0_State, &linflexd_uart0_config0); /* ʼ0 */
        LINFlexD_UART_DRV_ConfigureTimeoutCounter(UART_0, &uart_idle_timeout_config);           /* ÿгʱ */
        LINFlexD_UART_DRV_InstallRxCallback(UART_0, uart0_rx_callback, NULL);                   /* װջص */
        LINFlexD_UART_DRV_InstallTxCallback(UART_0, uart0_tx_callback, NULL);                   /* װͻص */
        LINFlexD_UART_DRV_InstallErrorCallback(UART_0, uart0_erro_callback, NULL);              /* װص */
        LINFlexD_UART_DRV_ReceiveData(UART_0, bsp_u0_rx_queun[uc_rx_msg_count0].buffer, UART_BUFFER_SIZE);
    }
#endif /* UART0_SWITCH */

#if UART1_SWITCH
    if (uart_num == UART_1)
    {
        LINFlexD_UART_DRV_Init(UART_1, &linflexd_uart1_config1_State, &linflexd_uart1_config1); /* ʼ1 */
        LINFlexD_UART_DRV_ConfigureTimeoutCounter(UART_1, &uart_idle_timeout_config);           /* ÿгʱ */
        LINFlexD_UART_DRV_InstallRxCallback(UART_1, uart1_rx_callback, NULL);                   /* װջص */
        LINFlexD_UART_DRV_InstallTxCallback(UART_1, uart1_tx_callback, NULL);                   /* װͻص */
        LINFlexD_UART_DRV_InstallErrorCallback(UART_1, uart1_erro_callback, NULL);              /* װص */
        LINFlexD_UART_DRV_ReceiveData(UART_1, bsp_u1_rx_queun[uc_rx_msg_count1].buffer, UART_BUFFER_SIZE);
    }
#endif /* UART1_SWITCH */

#if UART2_SWITCH
    if (uart_num == UART_3)
    {
        LINFlexD_UART_DRV_Init(UART_3, &linflexd_uart3_config3_State, &linflexd_uart3_config3); /* ʼ3 */
        LINFlexD_UART_DRV_ConfigureTimeoutCounter(UART_3, &uart_idle_timeout_config);           /* ÿгʱ */
        LINFlexD_UART_DRV_InstallRxCallback(UART_3, uart3_rx_callback, NULL);                   /* װջص */
        LINFlexD_UART_DRV_InstallTxCallback(UART_3, uart3_tx_callback, NULL);                   /* װͻص */
        LINFlexD_UART_DRV_InstallErrorCallback(UART_3, uart3_erro_callback, NULL);              /* װص */
        LINFlexD_UART_DRV_ReceiveData(UART_3, bsp_u3_rx_queun[uc_rx_msg_count3].buffer, UART_BUFFER_SIZE);
    }
#endif /* UART2_SWITCH */

#if UART5_SWITCH
   if (uart_num == UART_5)
    {
        LINFlexD_UART_DRV_Init(UART_5, &linflexd_uart5_config5_State, &linflexd_uart5_config5); /* ʼ3 */
        LINFlexD_UART_DRV_ConfigureTimeoutCounter(UART_5, &uart_idle_timeout_config);           /* ÿгʱ */
        LINFlexD_UART_DRV_InstallRxCallback(UART_5, uart5_rx_callback, NULL);                   /* װջص */
        LINFlexD_UART_DRV_InstallTxCallback(UART_5, uart5_tx_callback, NULL);                   /* װͻص */
        LINFlexD_UART_DRV_InstallErrorCallback(UART_5, uart5_erro_callback, NULL);              /* װص */
        LINFlexD_UART_DRV_ReceiveData(UART_5, bsp_u5_rx_queun[uc_rx_msg_count5].buffer, UART_BUFFER_SIZE);
    }
#endif /* UART5_SWITCH */
}

/**
 * @brief   ڷ
 * @param   uart_num:ڱ
 * @param   data:Ҫ͵ݻָ
 * @param   len:Ҫ͵ݵ ֽΪλ
 * @return  0:ɹ, 0:ʧ
 * @author  Samir
 * @version 1.0
 * @date    2024-11-21
 */
uint8_t bsp_uart_send(uart_number_t uart_num, uint8_t *data, uint16_t len)
{
    uint8_t status = 0;

    status = LINFlexD_UART_DRV_SendData(uart_num, (const uint8_t *)data, len);
    
    return status;
}

/**
 * @brief   ڽ
 * @param   uart_num:ڱ
 * @param   data:Ҫյݻָ
 * @param   len:Ҫյݵ ֽΪλ
 * @return  0:ɹ, 0:ʧ
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
uint8_t bsp_receive_data(uart_number_t uart_num, uint8_t *data, uint16_t len)
{
    uint8_t status = 0;

    status = LINFlexD_UART_DRV_ReceiveData(uart_num, data, len);

    return status;
}

/**
 * @brief   uartöд
 * @param   uart_queue:uartݶл
 * @param   remain_num:ʣݳ
 * @param   queue_handle:о
 * @param   queue_count:ݶл
 * @author  Samir
 * @version 1.0
 * @date    2024-11-27
 */
void bsp_uart_queue_send(uart_data_t *uart_queue, uint32_t remain_num, 
                     QueueHandle_t queue_handle, __IO uint8_t *queue_count)
{
    uart_data_t *p_uart_data = NULL;        
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */
    uint8_t uart_queue_count = *queue_count;

    uart_queue[uart_queue_count].size = UART_BUFFER_SIZE - remain_num;
    p_uart_data = &uart_queue[uart_queue_count]; /* Ҫ͵ݶ */
    uart_queue_count++;
    uart_queue_count %= UART_QUEUE_QUANTITY;            /* ȡֹԽ */
    memset(uart_queue[uart_queue_count].buffer, 0, UART_BUFFER_SIZE); /* һڻ */
    *queue_count = uart_queue_count;                   /* ¼ֵ */
    if (xQueueSendToBackFromISR(queue_handle, &p_uart_data, &task_switching_flag) != pdTRUE)
    {
        LOG_ERROR(15, "\n%s is full\r\n", queue_handle);
    }
    if (task_switching_flag == pdTRUE)
    {
        portYIELD_FROM_ISR(task_switching_flag);
    }
}

/**
 * @brief   ַ滻Ϊתַ
 * @param   input:ַ
 * @param   output:ַ
 * @author  Samir
 * @version 1.0
 * @date    2024-09-18
 */
static void replace_control_chars(const char *input, char *output)
{
    while (*input)
    {
        if (*input == '\r')
        {
            strcat(output, "\\r");
        }
        else if (*input == '\n')
        {
            strcat(output, "\\n");
        }
        else
        {
            strncat(output, input, 1);
        }
        input++;
    }
}

#if PRINTF_DEBUG

const char hex_asc_table[16] = {
    '0', '1', '2', '3',
    '4', '5', '6', '7',
    '8', '9', 'a', 'b',
    'c', 'd', 'e', 'f'
};

void printf_char(char ch)
{
    LINFlexD_UART_DRV_SendDataPolling(DEBUG_UART, (const uint8_t *) &ch, 1);
}

static void printf_str(char *str)
{
    while (str && (*str != (char)'\0'))
        printf_char(*str++);
}

static void printf_hex(unsigned int val, unsigned int width)
{
    int i = 0;
    char hex_val = 0, asc = 0;

    if ((width > 8) || (width == 0))
        width = 8;

    for (i = width - 1; i >= 0; i--)
    {
        hex_val = (val & (0x0F << (i << 2))) >> (i << 2);
        asc = hex_asc_table[(int)hex_val];
        printf_char(asc);
    }
}

static void printf_dec(unsigned int val)
{
    unsigned char buf[16];
    char asc = 0;
    int i = 0;

    while (1)
    {
        buf[i] = val % 10;
        val = val / 10;
        i++;
        if (val == 0)
            break;
    }

    for (; i > 0; i--)
    {
        asc = hex_asc_table[buf[i - 1]];
        printf_char(asc);
    }
}

void PRINTF(const char *fmt, ...)
{
    char c;
    unsigned int width = 0;
    va_list argptr;

    va_start(argptr, fmt);
    do
    {
        c = *fmt;
        if (c != '%')
        {
            printf_char(c);
        }
        else
        {
            while (1)
            {
                c = *++fmt;
                if ((c == 'd') || (c == 'x') || (c == 'X') || (c == 's') || (c == 'c'))
                {
                    if ((c == 'x') || (c == 'X'))
                    {
                        if (*(fmt - 1) == '%')
                            width = 8;
                        else
                            width = *(fmt - 1) - '0';
                    }
                    break;
                }
            }

            switch (c)
            {
            case 'd':
                printf_dec(va_arg(argptr, int));
                break;
            case 'x':
                printf_hex((va_arg(argptr, int)), width);
                break;
            case 's':
                printf_str(va_arg(argptr, char *));
                break;
            case 'c':
                printf_char(va_arg(argptr, int));
                break;
            default:
                break;
            }
        }
        ++fmt;
    } while (*fmt != '\0');

    va_end(argptr);
}
#endif /* PRINTF_DEBUG */

/************************************* END OF FILE ************************************/
