/**
****************************************************************************************
* @file    : bsp_sys.h
* @author  : Samir
* @version : V1.2
* @date    : 2025-4-15
* @brief   : ͷļ
****************************************************************************************
*/
#ifndef __BSP_SYS_H
#define __BSP_SYS_H

#include <stdint.h>
#include "YTM32B1HA0.h"

/************************************ ӿ *************************************/
/** 
  * @brief  ״̬ṹ
  */  
typedef enum 
{
  x_ok       = 0x00U,
  x_error    = 0x01U,
  x_busy     = 0x02U,
  x_timeout  = 0x03U
} x_status_t;

#define  TICK_INT_PRIORITY          15U             /* ϵͳʱȼ */
#define  X_MAX_DELAY                0xFFFFFFFFU     /* ʱ */

/* CORTEX_Preemption_Priority_Group  CORTEX ռȼ */
#define NVIC_PRIORITYGROUP_0        0x00000007U     /* 0 λռȼ 4λȼ */                                              
#define NVIC_PRIORITYGROUP_1        0x00000006U     /* 1 λռȼ 3λȼ */                                          
#define NVIC_PRIORITYGROUP_2        0x00000005U     /* 2 λռȼ 2λȼ */                                           
#define NVIC_PRIORITYGROUP_3        0x00000004U     /* 3 λռȼ 1 λȼ */                                               
#define NVIC_PRIORITYGROUP_4        0x00000003U     /* 4 λռȼ 0 λʾȼ */

/* ϵͳʱ ̶Ƶ */
typedef enum
{
  x_tick_freq_10hz         = 100U,
  x_tick_freq_100hz        = 10U,
  x_tick_freq_1khz         = 1U,
  x_tick_freq_default      = x_tick_freq_1khz
} x_tick_freq_t;

/* DWT Ĵַ */
#define  DWT_CYCCNT         *(volatile unsigned int *)0xE0001004
#define  DWT_CR             *(volatile unsigned int *)0xE0001000
#define  DEM_CR             *(volatile unsigned int *)0xE000EDFC

#define  DEM_CR_TRCENA      (1 << 24)   /* ʹDWTλ */
#define  DWT_CR_CYCCNTENA   (1 <<  0)   /* ʹDWT CYCCNTĴλ */

#define ARRAY_LENGTH(arr)   (sizeof(arr) / sizeof(arr[0]))      /* 鳤 */
#define ALIGN_BYTES         (4U)                                /* 4ֽڶ */

/************************************ ӿں *************************************/
void sys_msr_msp(uint32_t addr); /* ջַ */
void sys_soft_reset(void);       /* ϵͳλ */

x_status_t x_init(void);
void x_inc_tick(void);
uint32_t x_get_tick(void);
uint32_t x_get_tick_prio(void);
x_tick_freq_t x_get_tick_freq(void);
void x_delay(uint32_t delay);
x_status_t x_init_tick(uint32_t tick_priority);
uint32_t x_systick_config(uint32_t ticks_numb);

void bsp_dwt_init(void);    /* DWTʼ */
void bsp_delay_ms(uint32_t delay_time);
void bsp_delay_us(uint32_t delay_time);
void bsp_delay_dwt(uint32_t delay_time); /* DWTʱ */
uint32_t bsp_dwt_timestamp(void);        /* ȡDWTʱ(us) */

#endif /* __BSP_SYS_H */
