/**
****************************************************************************************
* @file    : bsp_reel.h
* @author  : Samir
* @version : V1.5
* @date    : 2025-4-2
* @brief   : ͷļ
****************************************************************************************
*/
#ifndef __BSP_REEL_H
#define __BSP_REEL_H

#include "./config/bsp_config.h"


/************************************ ӿ *************************************/
#define REEL_SECTOR_ADDR    (0x6000000U)    /* ַ */
#define REEL_SECTOR_NUM     (1U)            /* ռ */

#define REEL_DATA_ADDR      (REEL_SECTOR_ADDR) /* ݵַ */

#define REEL_FLAG_DATA      (0x55667788U)   /* ̱־ֵ,Ƿгʼ */
#define REEL_FLAG_ADDR      (REEL_DATA_ADDR + ALIGN_BYTES) /* ̱־ַ */


/************************************ ӿں *************************************/
extern uint32_t reel_encoder_data;        /* ¼̱ */
extern __IO uint8_t reel_power_down_flag; /* ̵־ */

uint8_t bsp_reel_init(void);
uint8_t bsp_reel_erase_sector(void);
uint8_t bsp_reel_write_data(uint32_t *data);
uint32_t bsp_reel_read_data(void);


#endif /* __BSP_REEL_H */
