/**
****************************************************************************************
* @file    : bsp_reel.c
* @author  : Samir
* @version : V1.5
* @date    : 2025-4-2
* @brief   : 
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include "./reel/bsp_reel.h"
#include "./flash/bsp_flash.h"


uint32_t reel_encoder_data = 0;        /* ¼̱ */
__IO uint8_t reel_power_down_flag = 0; /* ̵־ */

uint32_t reel_data[8] = {0}; /*  */


/**
 * @brief   ʼ
 * @return  0:ɹ, 0:ʧ
 * @author  Samir
 * @version 1.5
 * @date    2025-4-2
 */
uint8_t bsp_reel_init(void)
{
    uint8_t status = 0;
    
    if(REEL_FLAG_DATA != *(uint32_t *)REEL_FLAG_ADDR)
    {
        reel_data[0] = 0;               /* ¼̱ */
        reel_data[1] = REEL_FLAG_DATA;  /* ¼Ƿʼ */

        status = flash_erase(1, REEL_SECTOR_ADDR, REEL_SECTOR_NUM);    /*  */
        status = flash_write(REEL_DATA_ADDR, ARRAY_LENGTH(reel_data) * ALIGN_BYTES, reel_data);  /* дʼ־ */     
    }
    else
    {
        reel_encoder_data = bsp_reel_read_data();   /* ȡ */
    }

    return status;
}

/**
 * @brief   ڵflash
 * @return  0:ɹ, 0:ʧ
 * @author  Samir
 * @version 1.5
 * @date    2025-4-2
 */
uint8_t bsp_reel_erase_sector(void)
{
    uint8_t status = 0;

    status = flash_erase(1, REEL_SECTOR_ADDR, REEL_SECTOR_NUM);    /*  */
    
    return status;
}


/**
 * @brief   д
 * @param   data:Ҫ¼ľֵ
 * @return  0:ɹ, 0:ʧ
 * @author  Samir
 * @version 1.5
 * @date    2025-4-2
 */
uint8_t bsp_reel_write_data(uint32_t *data)
{
    uint8_t status = 0;
    reel_data[0] = *data;           /* ¼̱ */
    reel_data[1] = REEL_FLAG_DATA;  /* ¼Ƿʼ */

    status = flash_erase(1, REEL_SECTOR_ADDR, REEL_SECTOR_NUM);    /*  */
    status = flash_write(REEL_DATA_ADDR, ARRAY_LENGTH(reel_data) * ALIGN_BYTES, reel_data);  /* д */

    return status;
}

/**
 * @brief   ȡ
 * @return  falshм¼ľֵ
 * @author  Samir
 * @version 1.0
 * @date    2025-02-26
 */
uint32_t bsp_reel_read_data(void)
{
    return *(uint32_t *)REEL_DATA_ADDR;
}

/************************************* END OF FILE ************************************/
