/**
****************************************************************************************
* @file    : bsp_key_fifo.h
* @author  : Samir
* @version : V1.0
* @date    : 2025-02-07
* @brief   : ͷļ
****************************************************************************************
*/
#ifndef __BSP_KEY_FIFO_H
#define __BSP_KEY_FIFO_H

#include "./config/bsp_config.h"


/************************************ ӿ *************************************/
/* ʹGPIOʱ cubemxʱҪ */
#define ALL_KEY_GPIO_CLK_ENABLE()                             \
    do{                                                       \
        RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE); \
    } while (0);

#define DOUBLE_CLICK_ENABLE     0   /* 1ʾ˫⣬ Ӱ쵥 */

#define KEY_HARD_NUM            14   /* ʵ尴 */
#define KEY_COUNT               (KEY_HARD_NUM + 0)  /* 14  + 0 ϰ */

/*
    ˲ʱ50ms, λ10ms
    ֻ⵽50ms״̬ΪЧͰ¼
    ʹ·Ӳ˲˲ҲԱ֤ɿؼ⵽¼
*/
#define KEY_FILTER_TIME     5
#define KEY_LONG_TIME       0     /* λ10ms 0 룬Ϊ¼0ʱⳤ¼ */

#define KEY_DB_CLICK_TIME   40      /* ˫ʱλms */

#define KEY_FIFO_SIZE       20      /* FIFOĴ洢 */

typedef struct{
    uint8_t buf[KEY_FIFO_SIZE];     /* ֵ */
    uint8_t read;                   /* ָ1 */
    uint8_t write;                  /* дָ */
    uint8_t read2;                  /* ָ2 */
}key_fifo;

typedef struct{              /* ζ尴õGPIO */
    GPIO_Type* gpio;
    uint16_t pin;
    uint8_t active_level;    /* ƽ */
}key_gpio;

/* ID, Ҫbsp_KeyState()ڲ */
typedef enum{
    KID_K1 = 0,
    KID_K2,
    KID_K3,
    KID_K4,
    KID_K5,
    KID_K6,
    KID_K7,
    KID_K8,
    KID_K9,
    KID_K10,
    KID_K11,
    KID_K12,
    KID_K13,
    KID_K14,
}key_id;

/* ÿӦ1ȫֵĽṹ */
typedef struct{
    /* һָ룬ָжϰǷµĺ */
    uint8_t (*key_down_func)(void); /* µжϺ,1ʾ */

    uint8_t  cnt;           /* ˲ */
    uint16_t long_cnt;      /*  */
    uint16_t long_tim;      /* ³ʱ, 0ʾⳤ */
    uint8_t  state;         /* ǰ״̬»ǵ */
    uint8_t  repeat_speed;  /*  */
    uint8_t  repeat_cnt;    /*  */
    
    uint16_t delay_cnt;     /* ӳټ˫ */
    uint8_t  click_cnt;     /*  */
    int32_t  last_tim;      /* ϴΰʱ */
}key_t;

/* ӦóĹ */
#define DI1_DOWN                KEY_1_DOWN
#define DI1_UP                  KEY_1_UP
#define DI1_LONG_DOWN           KEY_1_LONG_DOWN
#define KEY_LONG_UP_K1          KEY_1_LONG_UP
#define KEY_AUTO_K1             KEY_1_AUTO_UP
#define KEY_DB_K1               KEY_1_DB_UP

#define DI2_DOWN                KEY_2_DOWN
#define DI2_UP                  KEY_2_UP
#define KEY_LONG_DOWN_K2        KEY_2_LONG_DOWN
#define KEY_LONG_UP_K2          KEY_2_LONG_UP
#define KEY_AUTO_K2             KEY_2_AUTO_UP
#define KEY_DB_K2               KEY_2_DB_UP

#define DI3_DOWN                KEY_3_DOWN
#define DI3_UP                  KEY_3_UP
#define KEY_LONG_DOWN_K3        KEY_3_LONG_DOWN
#define KEY_LONG_UP_K3          KEY_3_LONG_UP
#define KEY_AUTO_K3             KEY_3_AUTO_UP
#define KEY_DB_K3               KEY_3_DB_UP

#define DI4_DOWN                KEY_4_DOWN
#define DI4_UP                  KEY_4_UP
#define KEY_LONG_DOWN_K4        KEY_4_LONG_DOWN
#define KEY_LONG_UP_K4          KEY_4_LONG_UP
#define KEY_AUTO_K4             KEY_4_AUTO_UP
#define KEY_DB_K4               KEY_4_DB_UP

#define DI5_DOWN                KEY_5_DOWN
#define DI5_UP                  KEY_5_UP
#define KEY_LONG_DOWN_K5        KEY_5_LONG_DOWN
#define KEY_LONG_UP_K5          KEY_5_LONG_UP
#define KEY_AUTO_K5             KEY_5_AUTO_UP
#define KEY_DB_K5               KEY_5_DB_UP

#define DI6_DOWN                KEY_6_DOWN
#define DI6_UP                  KEY_6_UP
#define KEY_LONG_DOWN_K6        KEY_6_LONG_DOWN
#define KEY_LONG_UP_K6          KEY_6_LONG_UP
#define KEY_AUTO_K6             KEY_6_AUTO_UP
#define KEY_DB_K6               KEY_6_DB_UP

#define DI7_DOWN                KEY_7_DOWN
#define DI7_UP                  KEY_7_UP
#define KEY_LONG_DOWN_K7        KEY_7_LONG_DOWN
#define KEY_LONG_UP_K7          KEY_7_LONG_UP
#define KEY_AUTO_K7             KEY_7_AUTO_UP
#define KEY_DB_K7               KEY_7_DB_UP

#define DI8_DOWN                KEY_8_DOWN
#define DI8_UP                  KEY_8_UP
#define KEY_LONG_DOWN_K8        KEY_8_LONG_DOWN
#define KEY_LONG_UP_K8          KEY_8_LONG_UP
#define KEY_AUTO_K8             KEY_8_AUTO_UP
#define KEY_DB_K8               KEY_8_DB_UP

#define DI9_DOWN                KEY_9_DOWN
#define DI9_UP                  KEY_9_UP
#define KEY_LONG_DOWN_K9        KEY_9_LONG_DOWN
#define KEY_LONG_UP_K9          KEY_9_LONG_UP
#define KEY_AUTO_K9             KEY_9_AUTO_UP
#define KEY_DB_K9               KEY_9_DB_UP

#define DI10_DOWN               KEY_10_DOWN
#define DI10_UP                 KEY_10_UP
#define KEY_LONG_DOWN_K10       KEY_10_LONG_DOWN
#define KEY_LONG_UP_K10         KEY_10_LONG_UP
#define KEY_AUTO_K10            KEY_10_AUTO_UP
#define KEY_DB_K10              KEY_10_DB_UP

#define DI11_DOWN               KEY_11_DOWN
#define DI11_UP                 KEY_11_UP
#define KEY_LONG_DOWN_K11       KEY_11_LONG_DOWN
#define KEY_LONG_UP_K11         KEY_11_LONG_UP
#define KEY_AUTO_K11            KEY_11_AUTO_UP
#define KEY_DB_K11              KEY_11_DB_UP

#define DI12_DOWN               KEY_12_DOWN
#define DI12_UP                 KEY_12_UP
#define KEY_LONG_DOWN_K12       KEY_12_LONG_DOWN
#define KEY_LONG_UP_K12         KEY_12_LONG_UP
#define KEY_AUTO_K12            KEY_12_AUTO_UP
#define KEY_DB_K12              KEY_12_DB_UP

#define FAN1_FB_DOWN            KEY_13_DOWN
#define FAN1_FB_UP              KEY_13_UP
#define FAN1_FB_LONG_DOWN       KEY_13_LONG_DOWN
#define FAN1_FB_LONG_UP         KEY_13_LONG_UP
#define FAN1_FB_AUTO            KEY_13_AUTO_UP
#define FAN1_FB_DB              KEY_13_DB_UP

#define FAN2_FB_DOWN            KEY_14_DOWN
#define FAN2_FB_UP              KEY_14_UP
#define FAN2_FB_LONG_DOWN       KEY_14_LONG_DOWN
#define FAN2_FB_LONG_UP         KEY_14_LONG_UP
#define FAN2_FB_AUTO            KEY_14_AUTO_UP
#define FAN2_FB_DB              KEY_14_DB_UP

#define SYS_DOWN_K1K2           KEY_15_DOWN        /* K1 K2 ϼ */
#define SYS_UP_K1K2             KEY_15_UP
#define SYS_LONG_DOWN_K1K2      KEY_15_LONG_DOWN
#define SYS_LONG_UP_K1K2        KEY_15_LONG_UP
#define SYS_AUTO_K1K2           KEY_15_AUTO_UP
#define SYS_DB_K1K2             KEY_15_DB_UP

#define SYS_DOWN_K2K3           KEY_16_DOWN        /* K2 K3 ϼ */
#define SYS_UP_K2K3             KEY_16_UP
#define SYS_LONG_DOWN_K2K3      KEY_16_LONG_DOWN
#define SYS_LONG_UP_K2K3        KEY_16_LONG_UP
#define SYS_AUTO_K2K3           KEY_16_AUTO_UP
#define SYS_DB_K2K3             KEY_16_DB_UP


/*
    ֵ, 밴´ʱÿİ¡ͳ¼

    Ƽʹenum, #defineԭ
    (1) ֵ,˳ʹ뿴
    (2) ɰǱֵظ
*/
#define KEY_MSG_STEP    6 /* Ϣ벽(ÿм¼룬˳У */
typedef enum{
    KEY_NONE = 0,           /* 0 ʾް¼ */

    KEY_1_DOWN,             /* 1 */
    KEY_1_UP,               /* 1 */
    KEY_1_LONG_DOWN,        /* 1 */
    KEY_1_LONG_UP,          /* 1ĵ */  
    KEY_1_AUTO_UP,          /* 1Զ */
    KEY_1_DB_UP,            /* 1˫ */ 

    KEY_2_DOWN,             /* 2 */
    KEY_2_UP,               /* 2 */
    KEY_2_LONG_DOWN,        /* 2 */
    KEY_2_LONG_UP,          /* 2ĵ */  
    KEY_2_AUTO_UP,          /* 2Զ */
    KEY_2_DB_UP,            /* 2˫ */

    KEY_3_DOWN,             /* 3 */
    KEY_3_UP,               /* 3 */
    KEY_3_LONG_DOWN,        /* 3 */
    KEY_3_LONG_UP,          /* 3ĵ */  
    KEY_3_AUTO_UP,          /* 3Զ */
    KEY_3_DB_UP,            /* 3˫ */

    KEY_4_DOWN,             /* 4 */
    KEY_4_UP,               /* 4 */
    KEY_4_LONG_DOWN,        /* 4 */
    KEY_4_LONG_UP,          /* 4ĵ */  
    KEY_4_AUTO_UP,          /* 4Զ */
    KEY_4_DB_UP,            /* 4˫ */

    KEY_5_DOWN,             /* 5 */
    KEY_5_UP,               /* 5 */
    KEY_5_LONG_DOWN,        /* 5 */
    KEY_5_LONG_UP,          /* 5ĵ */
    KEY_5_AUTO_UP,          /* 5Զ */
    KEY_5_DB_UP,            /* 5˫ */

    KEY_6_DOWN,             /* 6 */
    KEY_6_UP,               /* 6 */
    KEY_6_LONG_DOWN,        /* 6 */
    KEY_6_LONG_UP,          /* 6ĵ */
    KEY_6_AUTO_UP,          /* 6Զ */
    KEY_6_DB_UP,            /* 6˫ */

    KEY_7_DOWN,             /* 7 */
    KEY_7_UP,               /* 7 */
    KEY_7_LONG_DOWN,        /* 7 */
    KEY_7_LONG_UP,          /* 7ĵ */
    KEY_7_AUTO_UP,          /* 7Զ */
    KEY_7_DB_UP,            /* 7˫ */

    KEY_8_DOWN,             /* 8 */
    KEY_8_UP,               /* 8 */
    KEY_8_LONG_DOWN,        /* 8 */
    KEY_8_LONG_UP,          /* 8ĵ */
    KEY_8_AUTO_UP,          /* 8Զ */
    KEY_8_DB_UP,            /* 8˫ */

    KEY_9_DOWN,             /* 9 */
    KEY_9_UP,               /* 9 */
    KEY_9_LONG_DOWN,        /* 9 */
    KEY_9_LONG_UP,          /* 9ĵ */  
    KEY_9_AUTO_UP,          /* 9Զ */
    KEY_9_DB_UP,            /* 9˫ */

    KEY_10_DOWN,            /* 10 */
    KEY_10_UP,              /* 10 */
    KEY_10_LONG_DOWN,       /* 1 */
    KEY_10_LONG_UP,         /* 1ĵ */  
    KEY_10_AUTO_UP,         /* 1Զ */
    KEY_10_DB_UP,           /* 1˫ */

    KEY_11_DOWN,            /* 11 */
    KEY_11_UP,              /* 11 */
    KEY_11_LONG_DOWN,       /* 11 */
    KEY_11_LONG_UP,         /* 11ĵ */
    KEY_11_AUTO_UP,         /* 11Զ */
    KEY_11_DB_UP,           /* 11˫ */
    
    KEY_12_DOWN,            /* 12 */
    KEY_12_UP,              /* 12 */
    KEY_12_LONG_DOWN,       /* 12 */
    KEY_12_LONG_UP,         /* 12ĵ */
    KEY_12_AUTO_UP,         /* 12Զ */
    KEY_12_DB_UP,           /* 12˫ */

    KEY_13_DOWN,            /* 13 */
    KEY_13_UP,              /* 13 */
    KEY_13_LONG_DOWN,       /* 13 */
    KEY_13_LONG_UP,         /* 13ĵ */
    KEY_13_AUTO_UP,         /* 13Զ */
    KEY_13_DB_UP,           /* 13˫ */

    KEY_14_DOWN,            /* 14 */
    KEY_14_UP,              /* 14 */
    KEY_14_LONG_DOWN,       /* 14 */
    KEY_14_LONG_UP,         /* 14ĵ */
    KEY_14_AUTO_UP,         /* 14Զ */
    KEY_14_DB_UP,           /* 14˫ */

    /* ϼ */
    KEY_15_DOWN,            /* 15 */
    KEY_15_UP,              /* 15 */
    KEY_15_LONG_DOWN,       /* 15 */
    KEY_15_LONG_UP,         /* 15ĵ */
    KEY_15_AUTO_UP,         /* 15Զ */
    KEY_15_DB_UP,           /* 15˫ */

    KEY_16_DOWN,            /* 16 */
    KEY_16_UP,              /* 16 */
    KEY_16_LONG_DOWN,       /* 16 */
    KEY_16_LONG_UP,         /* 16ĵ */
    KEY_16_AUTO_UP,         /* 16Զ */
    KEY_16_DB_UP,           /* 16˫ */
}key_num;

/************************************ ӿں *************************************/
void key_hard_init(void);
void key_var_init(void);
void key_put(uint8_t _key_code);
void key_set_param(uint8_t _key_id, uint16_t _long_tim, uint8_t _repeat_speed);
uint8_t key_get(void);
uint8_t key_get2(void);
uint8_t key_get_state(key_id _key_id);
void key_clear(void);
void key_scan10ms(void);

static uint8_t key_pin_active(uint8_t _id);
static uint8_t key_down_func(uint8_t _id);
static void key_detect(uint8_t _id);


#endif /* __BSP_KEY_FIFO_H */
