/**
****************************************************************************************
* @file    : bsp_key_fifo.c
* @author  : Samir
* @version : V1.0
* @date    : 2025-02-07
* @brief   : FIFO
****************************************************************************************
* @attention
*            
*
*
****************************************************************************************
*/
#include "./input/bsp_key_fifo.h"


static key_t    st_btn[KEY_COUNT] = {0};
static key_fifo st_key;        /* FIFO,ṹ */

/* GPIOPIN */
static const key_gpio st_gpio_list[KEY_HARD_NUM] = {
    {GPIOA, 14U, 0},     /* K1 */
    {GPIOA, 13U, 0},     /* K2 */
    {GPIOA, 12U, 0},     /* K3 */
    {GPIOA, 11U, 0},     /* K4 */
    {GPIOC, 6U, 0},      /* K5 */
    {GPIOC, 7U, 0},      /* K6 */
    {GPIOA, 0U, 0},      /* K7 */
    {GPIOA, 1U, 0},      /* K8 */
    {GPIOA, 16U, 0},     /* K9 */
    {GPIOA, 15U, 0},     /* K10 */
    {GPIOE, 6U, 0},      /* K11 */
    {GPIOE, 2U, 0},      /* K12 */
    {GPIOC, 2U, 1},      /* K13 */
    {GPIOD, 7U, 1},      /* K14 */
}; 


/**
 * @brief   systickжϷȡCPUʱ䣬λ1ms
 * @param   
 * @retval  CPUʱ䣬λ1ms
 */
int32_t get_run_tim(void)
{
    int32_t run_time;

    run_time = xTaskGetTickCount();    /* SystickжбдҪжϽб */

    return run_time;
}

/**
 * @brief   㵱ǰʱ͸ʱ֮Ĳֵ˼ѭ
 * @param   _last_tim:ϸʱ
 * @retval  ǰʱ͹ȥʱĲֵλ1ms
 */
int32_t check_run_tim(int32_t _last_tim)
{
    int32_t now_time;
    int32_t time_diff;

    now_time = xTaskGetTickCount();    /* SystickжбдҪжϽб */
    
    if (now_time >= _last_tim)
    {
        time_diff = now_time - _last_tim;
    }
    else
    {
        time_diff = 0x7FFFFFFF - _last_tim + now_time;
    }

    return time_diff;
}

/**
 * @brief  Ӳʼ
 * @param  
 * @retval 
 * @note   ùûӲ ʱҪ
 */
void key_hard_init(void)
{    
    // uint8_t i;
    // GPIO_InitTypeDef GPIO_InitStruct;

    // ALL_KEY_GPIO_CLK_ENABLE();                  /* аGPIOʱ */

    // GPIO_InitStruct.GPIO_Mode = GPIO_Mode_IPD;  /* ģʽΪ */
    
    // for (i = 0; i < KEY_HARD_NUM; i++)
    // {
    //     GPIO_InitStruct.GPIO_Pin = st_gpio_list[i].pin;
    //     GPIO_Init(st_gpio_list[i].gpio, &GPIO_InitStruct);
    // }
}

/**
 * @brief  ʼ
 * @param  
 * @retval 
 */
void key_var_init(void)
{
    uint8_t i;

    /* ԰FIFOдָ */
    st_key.read = 0;
    st_key.write = 0;
    st_key.read2 = 0;

    /* ÿṹԱһȱʡֵ */
    for (i = 0; i < KEY_COUNT; i++)
    {
        st_btn[i].long_tim = KEY_LONG_TIME;     /* ʱ 0 ʾⳤ¼ */
        st_btn[i].cnt = KEY_FILTER_TIME / 2;    /* Ϊ˲ʱһ */
        st_btn[i].state = 0;            /* ȱʡ״̬0Ϊδ */
        st_btn[i].repeat_speed = 0;     /* ٶȣ0ʾ֧ */
        st_btn[i].repeat_cnt = 0;       /*  */
        st_btn[i].delay_cnt = 0;
        st_btn[i].click_cnt = 0;  
        st_btn[i].last_tim = 0;
    }

    /* ҪĳĲڴ˵¸ֵ */
    key_set_param(KID_K1, 300, 0);  /* 1ⳤ300 * 10ms¼ */
}

/**
 * @brief  ð
 * @param  _key_id: ID
 * @param  _long_tim: ¼ʱ λ10ms
 * @param  _repeat_speed: ٶ
 * @retval 
 */
void key_set_param(uint8_t _key_id, uint16_t _long_tim, uint8_t _repeat_speed)
{
    st_btn[_key_id].long_tim = _long_tim;           /* ʱ 0 ʾⳤ¼ */
    st_btn[_key_id].repeat_speed = _repeat_speed;   /* ٶȣ0ʾ֧ */
    st_btn[_key_id].repeat_cnt = 0;                 /*  */
}

/**
 * @brief  1ֵѹ밴FIFOģһ
 * @param  _key_code: 
 * @retval 
 */
void key_put(uint8_t _key_code)
{
    st_key.buf[st_key.write] = _key_code;

    if(++st_key.write  >= KEY_FIFO_SIZE)
    {
        st_key.write = 0;
    }
}

/**
 * @brief  ӰFIFOȡһֵ
 * @param  
 * @retval 
 */
uint8_t key_get(void)
{
    uint8_t ret;

    if (st_key.read == st_key.write)
    {
        return KEY_NONE;
    }
    else
    {
        ret = st_key.buf[st_key.read];

        if (++st_key.read >= KEY_FIFO_SIZE)
        {
            st_key.read = 0;
        }
        return ret;
    }
}

/**
 * @brief  ӰFIFOȡһֵĶָ
 * @param  
 * @retval 
 */
uint8_t key_get2(void)
{
    uint8_t ret;

    if (st_key.read2 == st_key.write)
    {
        return KEY_NONE;
    }
    else
    {
        ret = st_key.buf[st_key.read2];

        if (++st_key.read2 >= KEY_FIFO_SIZE)
        {
            st_key.read2 = 0;
        }
        return ret;
    }
}

/**
 * @brief  ȡ״̬
 * @param  _key_id: ID
 * @retval 1 ʾ£ 0 ʾδ
 */
uint8_t key_get_state(key_id _key_id)
{
    return st_btn[_key_id].state;
}

/**
 * @brief  հFIFO
 * @param  
 * @retval 
 */
void key_clear(void)
{
    st_key.read = st_key.write;
}

/**
 * @brief  жϰǷ
 * @param  _id:id
 * @retval 1 ʾ(ͨ0ʾδ£ͷţ
 */
static uint8_t key_pin_active(uint8_t _id)
{
    uint8_t level;
    
    if ((st_gpio_list[_id].gpio->PDIR & (1 << st_gpio_list[_id].pin)) == 0)
    {
        level = 0;
    }
    else
    {
        level = 1;
    }

    if (level == st_gpio_list[_id].active_level)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

/**
 * @brief  жϰǷ¡ϼ֡
 * @param  _id:id
 * @retval 1 ʾ(ͨ0ʾδ£ͷţ
 * @note   עͿѡ񵥼 
 *         1.ͬʱ¼ 
 *         2.ͬʱ¼
 */
static uint8_t key_down_func(uint8_t _id)
{
    /* ʵ嵥 */
    if (_id < KEY_HARD_NUM)
    {
        /* ȡ·עͣ1.ͬʱ¼  */
        // uint8_t i;
        // uint8_t count = 0;
        // uint8_t save = 255;
        
        // /* жм */
        // for (i = 0; i < KEY_HARD_NUM; i++)
        // {
        //     if (key_pin_active(i)) 
        //     {
        //         count++;
        //         save = i;
        //     }
        // }
        
        // if (count == 1 && save == _id)
        // {
        //     return 1;    /* ֻ1ʱЧ */
        // }

        // return 0;

        /* ˷2.ͬʱ¼ */
        return key_pin_active(_id);  
    }
    
    /* ϼ K1K2 */
    if (_id == KEY_HARD_NUM + 0)
    {
        if (key_pin_active(KID_K1) && key_pin_active(KID_K2))
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }

    /* ϼ K2K3 */
    if (_id == KEY_HARD_NUM + 1)
    {
        if (key_pin_active(KID_K2) && key_pin_active(KID_K3))
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }

    return 0;
}

/**
 * @brief  һ״̬뱻Եĵ
 * @param  _id: id
 * @retval 
 */
static void key_detect(uint8_t _id)
{
    key_t *pbtn;

    pbtn = &st_btn[_id];
    if (key_down_func(_id))
    {
        if (pbtn->cnt < KEY_FILTER_TIME)
        {
            pbtn->cnt = KEY_FILTER_TIME;
        }
        else if (pbtn->cnt < 2 * KEY_FILTER_TIME)
        {
            pbtn->cnt++;
        }
        else
        {
            if (pbtn->state == 0)
            {
                pbtn->state = 1;

                /* ͰťµϢ */
                key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_DOWN));
            }

            if (pbtn->long_tim > 0)
            {
                if (pbtn->long_cnt < pbtn->long_tim)
                {
                    /* ͳϢ */
                    if (++pbtn->long_cnt == pbtn->long_tim)
                    {
                        pbtn->state = 2;
                        
                        /* ֵ밴FIFO */
                        key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_LONG_DOWN));                        
                    }
                }
                else
                {
                    if (pbtn->repeat_speed > 0)
                    {
                        if (++pbtn->repeat_cnt >= pbtn->repeat_speed)
                        {
                            pbtn->repeat_cnt = 0;
                            /* ÿڷ1¼ */
                            key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_AUTO_UP));
                        }
                    }
                }
            }
        }
    }
    else
    {
        if (pbtn->cnt > KEY_FILTER_TIME)
        {
            pbtn->cnt = KEY_FILTER_TIME;
        }
        else if (pbtn->cnt != 0)
        {
            pbtn->cnt--;
        }
        else
        {
            if (pbtn->state != 0)
            {
                /* ĵ */
                if (pbtn->long_tim == 0)
                {
                    /* Ͷ̰Ϣ */
                    key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_UP));
                }
                else
                {
                    if (pbtn->state == 2)
                    {
                        /* ͳϢ */
                        key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_LONG_UP));
                        
                        #if DOUBLE_CLICK_ENABLE == 1
                            st_btn[_id].last_tim = get_run_tim();  /* ¼ʱ */
                        #endif
                    }
                    else
                    {                       
                        #if DOUBLE_CLICK_ENABLE == 1
                        /* Ͷ̰Ϣ */
                            if (check_run_tim(st_btn[_id].last_tim) < 500)
                            {                            
                                if (pbtn->click_cnt == 1)
                                {
                                    key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_DB_UP));  /* ˫¼ */
                                    pbtn->click_cnt = 0;
                                }
                                else
                                {
                                    key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_UP));     /* ¼ */
                                    pbtn->click_cnt = 0;
                                }
                                pbtn->delay_cnt = 80; 
                            }
                            else                       
                            {
                                pbtn->click_cnt++;                        
                                pbtn->delay_cnt = KEY_DB_CLICK_TIME;  
                            }
                            st_btn[_id].last_tim = get_run_tim();  /* ¼ʱ */   
                        #else
                            key_put((uint8_t)(KEY_MSG_STEP * _id + KEY_1_UP));     /* ¼ */
                        #endif
                    }
                }
                pbtn->state = 0;                
            }
        }

        pbtn->long_cnt = 0;
        pbtn->repeat_cnt = 0;
    }
}

/**
 * @brief  ɨа10msһ
 * @param  
 * @retval 
 */
void key_scan10ms(void)
{
    uint8_t i;

    for (i = 0; i < KEY_COUNT; i++)
    {   
        #if DOUBLE_CLICK_ENABLE == 1
            /* ʱж */
            if (st_btn[i].delay_cnt > 0)
            {
                if (--st_btn[i].delay_cnt == 0)
                {
                    if (st_btn[i].click_cnt == 1)
                    {
                        key_put((uint8_t)(KEY_MSG_STEP * i + KEY_1_UP));   /*  */
                    }              
                    st_btn[i].click_cnt = 0;
                }
            }
        #endif
        
        key_detect(i);  /* ⰴ */
    }
}

/************************************* END OF FILE ************************************/