/**
****************************************************************************************
* @file    : bsp_gpio.c
* @author  : Samir
* @version : V1.0
* @date    : 2024-09-30
* @brief   : GPIO ļ
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include "./config/bsp_config.h"
#include "./gpio/bsp_gpio.h"
#include "pins_driver.h"


/**
 * @brief   ûѡݶ˿λ
 * @param   GPIOx:YTM32B1HA0XΪ豸ѡ GPIO  x  A..E
 * @param   GPIO_Pin:ָҪдĶ˿λ x  0..31 GPIO_PIN_x֮һ
 * @param   PinState:ָҪдѡλֵ GPIO_PIN_RESET  GPIO_PIN_SET
 * @author  Samir
 * @version 1.0
 * @date    2024-11-13
 */
void bsp_gpio_write_pin(GPIO_Type *const GPIOx, uint32_t GPIO_Pin, gpio_pin_state_t PinState)
{
    PINS_DRV_WritePin(GPIOx, GPIO_Pin, PinState);
}

/**
 * @brief   лָ GPIO 
 * @param   GPIOx:YTM32B1HA0XΪ豸ѡ GPIO  x  A..E
 * @param   GPIO_Pin:ָҪдĶ˿λ x  0..31 GPIO_PIN_x֮һ
 * @author  Samir
 * @version 1.0
 * @date    2024-11-13
 */
void bsp_gpio_toggle_pin(GPIO_Type *const GPIOx, uint32_t GPIO_Pin)
{
    PINS_DRV_TogglePins(GPIOx, 1 << GPIO_Pin);
}

/**
 * @brief   ȡָ˿
 * @param   GPIOx:YTM32B1HA0XΪ豸ѡ GPIO  x  A..E
 * @param   GPIO_Pin:ָҪдĶ˿λ x  0..15 GPIO_PIN_x֮һ
 * @return  ״̬ GPIO_PIN_RESET  GPIO_PIN_SET
 * @author  Samir
 * @version 1.0
 * @date    2024-11-13
 */
gpio_pin_state_t bsp_gpio_read_pin(GPIO_Type *const GPIOx, uint32_t GPIO_Pin)
{
    pins_channel_type_t return_value = 0U;

    gpio_pin_state_t bit_status;
    return_value = PINS_DRV_ReadPins(GPIOx);
    bit_status = (return_value & (1 << GPIO_Pin)) ? GPIO_PIN_SET : GPIO_PIN_RESET;

    return bit_status;
}

/************************************* END OF FILE ************************************/
