/**
****************************************************************************************
* @file    : bsp_flash.c
* @author  : Samir
* @version : V1.0
* @date    : 2025-04-02
* @brief   : flash
****************************************************************************************
* @attention
*            
*
*
****************************************************************************************
*/

#include "./flash/bsp_flash.h"
#include "flash_driver.h"


 /**
  * @brief   ַָʼдָС
  * @param   addr:ݵַ32ֽڶ룩
  * @param   size:ݴС (λ:ֽ,  32 ֽ,32ֽڶ)
  * @param   buf:ݻ
  * @return  0:ɹ, 0:ʧ
  * @author  Samir
  * @version 1.1
  * @date    2025-4-3
  */
 uint8_t flash_write(uint32_t addr, uint32_t size, void *buf)
 {
     uint8_t ret = 0;
 
     ret = FLASH_DRV_Program(FLASH_INSTANCE, addr, size, buf); /* д */
 
     return ret;
 }

 /**
  * @brief   flash
  * @param   type:0: PFLASH, 1: DFLASH
  * @param   sector_addr:ʼַ
  * @param   num:
  * @return  0:ɹ, 0:ʧ
  * @author  Samir
  * @version 1.0
  * @date    2025-04-02
  * @note    עַĺϷ
  */
uint8_t flash_erase(uint8_t type, uint32_t sector_addr, uint16_t num)
{
    uint8_t ret = 0;

    switch (type)
    {
    case 0: /* PFLASH */
        ret = FLASH_DRV_EraseSectorQuick(FLASH_INSTANCE, sector_addr, num * PFLASH_SECTOR_SIZE); /* ٲ */
        break;

    case 1: /* DFLASH */
        ret = FLASH_DRV_EraseSectorQuick(FLASH_INSTANCE, sector_addr, num * DFLASH_SECTOR_SIZE); /* ٲ */
        break;

    default:
        ret = 3; /* Ͳ */
        break;
    }

    return ret;
}

/************************************* END OF FILE ************************************/
