/**
****************************************************************************************
* @file    : bsp_fan.c
* @author  : Samir
* @version : V1.0
* @date    : 2025-02-17
* @brief   : 
****************************************************************************************
* @attention
*            
*
*
****************************************************************************************
*/

#include "./fan/bsp_fan.h"
#include "etmr_config.h"


/**
 * @brief   ȳʼ
 * @author  Samir
 * @version 1.0
 * @date    2025-02-17
 */
void bsp_fan_init(void)
{
    /* 1ʼ */
    eTMR_DRV_Init(FAN1_PWM_INST, &ETMR2_CM_Config2, &ETMR2_CM_Config2_State);
    eTMR_DRV_InitPwm(FAN1_PWM_INST, &ETMR2_PWM_Config2);
    eTMR_DRV_Enable(FAN1_PWM_INST);

    /* 2ʼ */
    eTMR_DRV_Init(FAN2_PWM_INST, &ETMR0_CM_Config0, &ETMR0_CM_Config0_State);
    eTMR_DRV_InitPwm(FAN2_PWM_INST, &ETMR0_PWM_Config0);
    eTMR_DRV_Enable(FAN2_PWM_INST);
}

/**
 * @brief   ٶ
 * @param   fan_inst:ʵ 
 * @param   speed:ٶȰٷֱ 0~100
 * @author  Samir
 * @version 1.0
 * @date    2025-02-17
 */
void bsp_fan_speed_set(uint8_t fan_inst, uint32_t speed)
{
    static __IO uint8_t flag1 = 0;
    static __IO uint8_t flag2 = 0;
    
    if (speed <= 0)
    {
        speed = 0;
    }
    else
    {
        speed = (uint32_t) ((speed / 100.0) * eTMR_MAX_DUTY_CYCLE);
    }

    if (fan_inst == FAN1_PWM_INST)
    {
        if(speed >= eTMR_MAX_DUTY_CYCLE)
        {
            flag1 = 1;
            /* 100%ռձȽ취 ʹCHMASK뷽ʽ */
            eTMR_DRV_SetChnOutMask(fan_inst, 1 << FAN1_PWM_CHANNEL, 0x1 << (FAN1_PWM_CHANNEL * 2), false);
        }
        else
        {
            if(flag1 == 1)
            {
                flag1 = 0;
                /* ʹCHMASK100%лռձʱҪCHMASK */
                eTMR_DRV_SetChnOutMask(fan_inst, 0 << FAN1_PWM_CHANNEL, 0, false);
            }
            eTMR_DRV_UpdatePwmChannel(fan_inst, FAN1_PWM_CHANNEL, speed, 0);
            eTMR_DRV_SetLdok(fan_inst);
        }
    }
    else if (fan_inst == FAN2_PWM_INST)
    {
        if(speed >= eTMR_MAX_DUTY_CYCLE)
        {
            flag2 = 1;
            /* 100%ռձȽ취 ʹCHMASK뷽ʽ */
            eTMR_DRV_SetChnOutMask(fan_inst, 1 << FAN2_PWM_CHANNEL, 0x1 << (FAN2_PWM_CHANNEL * 2), false);            
        }
        else
        {
            if(flag2 == 1)
            {
                flag2 = 0;
                /* ʹCHMASK100%лռձʱҪCHMASK */
                eTMR_DRV_SetChnOutMask(fan_inst, 0 << FAN2_PWM_CHANNEL, 0, false);
            }
            eTMR_DRV_UpdatePwmChannel(fan_inst, FAN2_PWM_CHANNEL, speed, 0);
            eTMR_DRV_SetLdok(fan_inst);
        }
    }
}



/************************************* END OF FILE ************************************/