/**
****************************************************************************************
* @file    : bsp_config.h
* @author  : Samir
* @version : V2.0
* @date    : 2024-09-29
* @brief   : BSPͷļ
****************************************************************************************
*/
#ifndef __BSP_CONFIG_H
#define __BSP_CONFIG_H

#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#include "SEGGER_RTT.h"
#include "YTM32B1HA0.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "timers.h"

#include "./sys/bsp_sys.h"


/*************************** ΪDEBUGҪ ****************************/
#define DEBUG                          (1U) /* Ƿ־ 1:0:ر */

/* ־ȼѡ */
#define INFO_SWITCH                    (1U) /* INFO ־ 1:,0:ر */
#define DEBUG_SWITCH                   (1U) /* DEBUG־ 1:,0:ر */
#define WARN_SWITCH                    (1U) /* WARN ־ 1:,0:ر */
#define ERROR_SWITCH                   (1U) /* ERROR־ 1:,0:ر */

/* µԷֻѡһ */
#if DEBUG
    #define SEGGER_RTT_DUBUG           (1U) /* Ƿ RTT   1:0:ر */
    #define PRINTF_DEBUG               (0U) /* Ƿprintf 1:0:ر*/
#else       
    #define SEGGER_RTT_DUBUG           (0U) /* Ƿ RTT  е 1:0:ر */
    #define PRINTF_DEBUG               (0U) /* Ƿprintfе 1:0:ر*/
#endif

#if SEGGER_RTT_DUBUG
    #define SEGGER_RTT_TIMESTAMP       (0U) /* ǷRTTʱ,1:,0:رգRTTʱͻῪRTT־ʾ */
    #define SEGGER_RTT_INFO            (0U) /* ǷRTT־ʾ,1:,0:ر */
    #define SYS_MS                     xTaskGetTickCount()  /* ȡϵͳmsʱ */
#elif PRINTF_DEBUG
    #define DEBUG_UART                 UART_0  /* printfʹõĴڱ */
#endif

/************************************    DEBUG    *************************************/
#if SEGGER_RTT_DUBUG
    #define SEGGER_RTT_DUBUG_INIT()                                                            \
        do                                                                                     \
        {                                                                                      \
            SEGGER_RTT_ConfigUpBuffer(0, "RTTUP", NULL, 0, SEGGER_RTT_MODE_NO_BLOCK_SKIP);     \
            SEGGER_RTT_ConfigDownBuffer(0, "RTTDOWN", NULL, 0, SEGGER_RTT_MODE_NO_BLOCK_SKIP); \
        }while (0);

    #if SEGGER_RTT_TIMESTAMP  
    #define LOG_PROTO(terminal, type, color, format, ...)                                                                    \
        do                                                                                                                   \
        {                                                                                                                    \
            SEGGER_RTT_SetTerminal(terminal);                                                                                \
            SEGGER_RTT_printf(0, "%s""[%02d:%02d:%02d:%03d]""%s" format,color,                                               \
                (SYS_MS / 1000) / 3600, (SYS_MS / 1000 / 60) % 60, (SYS_MS / 1000) % 60, SYS_MS % 1000, type, ##__VA_ARGS__);\
        } while (0)
    #define LOG_PROTO_FAILED(terminal, type, color, format, ...)                                                                         \
        do                                                                                                                               \
        {                                                                                                                                \
            SEGGER_RTT_SetTerminal(terminal);                                                                                            \
            SEGGER_RTT_printf(0, "%s""[%02d:%02d:%02d:%03d]""%s" format,color,                                                           \
                            (SYS_MS / 1000) / 3600, (SYS_MS / 1000 / 60) % 60, (SYS_MS / 1000) % 60, SYS_MS % 1000, type, ##__VA_ARGS__);\
            SEGGER_RTT_printf(0, " \t\t\t\t\t\t\tError file:%s,line:%d\r\n", __FILE__, __LINE__);                                        \
        } while (0)
        #elif SEGGER_RTT_INFO
        #define LOG_PROTO(terminal, type, color, format, ...)                       \
            do                                                                      \
            {                                                                       \
                SEGGER_RTT_SetTerminal(terminal);                                   \
                SEGGER_RTT_printf(0, "%s" "%s" format,color, type, ##__VA_ARGS__);  \
            } while (0)
        #define LOG_PROTO_FAILED(terminal, type, color, format, ...)                            \
            do                                                                                  \
            {                                                                                   \
                SEGGER_RTT_SetTerminal(terminal);                                               \
                SEGGER_RTT_printf(0, "%s""%s"format,color, type, ##__VA_ARGS__);                \
                SEGGER_RTT_printf(0, "        Error file:%s,line:%d\r\n", __FILE__, __LINE__);  \
            } while (0)
        #else
        #define LOG_PROTO(terminal, type, color, format, ...)           \
            do                                                          \
            {                                                           \
                ((void) type);                                          \
                SEGGER_RTT_SetTerminal(terminal);                       \
                SEGGER_RTT_printf(0, "%s" format,color, ##__VA_ARGS__); \
            } while (0)
        #define LOG_PROTO_FAILED(terminal, type, color, format, ...)                           \
            do                                                                                 \
            {                                                                                  \
                ((void) type);                                                                 \
                SEGGER_RTT_SetTerminal(terminal);                                              \
                SEGGER_RTT_printf(0, "%s"format, color, ##__VA_ARGS__);                        \
                SEGGER_RTT_printf(0, "        Error file:%s,line:%d\r\n", __FILE__, __LINE__); \
            } while (0)   
        #endif

    #if INFO_SWITCH
        #define LOG_INFO(terminal, format, ...)     LOG_PROTO(terminal, "[INFO]:", RTT_CTRL_TEXT_BRIGHT_CYAN, format, ##__VA_ARGS__) /* ˮɫ־ */
    #else
        #define LOG_INFO(terminal, format, ...)
    #endif

    #if DEBUG_SWITCH
        #define LOG_DEBUG(terminal, format, ...)     LOG_PROTO(terminal, "[DEBUG]:", RTT_CTRL_TEXT_BRIGHT_GREEN, format, ##__VA_ARGS__) /* ɫ־־ */
    #else
        #define LOG_DEBUG(terminal, format, ...)
    #endif

    #if WARN_SWITCH
        #define LOG_WARN(terminal, format, ...)     LOG_PROTO(terminal, "[WARN]:", RTT_CTRL_TEXT_BRIGHT_YELLOW, format, ##__VA_ARGS__) /* ɫ־־ */
    #else
        #define LOG_WARN(terminal, format, ...)
    #endif

    #if ERROR_SWITCH
        #define LOG_ERROR(terminal, format,...)     LOG_PROTO_FAILED(terminal, "[ERROR]:", RTT_CTRL_TEXT_BRIGHT_RED, format, ##__VA_ARGS__) /* ɫ־־ */
    #else
        #define LOG_ERROR(terminal, format, ...)
    #endif

#elif PRINTF_DEBUG
    #define SEGGER_RTT_DUBUG_INIT()     /* PRINTF_DEBUG ʱ RTT_DUBUG_INIT Ϊպ */

    #define LOG_PROTO(terminal, type, format, ...)    \
        do                                            \
        {                                             \
            ((void)terminal);                         \
            PRINTF("%s" format, type, ##__VA_ARGS__); \
        } while (0)

    /* λ־Ϣʧʱڵļк */
    #define LOG_PROTO_FAILED(terminal, type, format, ...)             \
        do                                                            \
        {                                                             \
            ((void)terminal);                                         \
            PRINTF("%s" format, type, ##__VA_ARGS__);                 \
            PRINTF("\tError file:%s,line:%d\r\n", __FILE__, __LINE__);\
        } while (0)

    #if INFO_SWITCH
        #define LOG_INFO(terminal, format, ...)     LOG_PROTO(terminal, "[INFO]:", format, ##__VA_ARGS__)
    #else
        #define LOG_INFO(terminal, format, ...)
    #endif

    #if DEBUG_SWITCH
        #define LOG_DEBUG(terminal, format, ...)     LOG_PROTO(terminal, "[DEBUG]:", format, ##__VA_ARGS__)
    #else
        #define LOG_DEBUG(terminal, format, ...)
    #endif

    #if WARN_SWITCH
        #define LOG_WARN(terminal, format, ...)     LOG_PROTO(terminal, "[WARN]:", format, ##__VA_ARGS__)
    #else
        #define LOG_WARN(terminal, format, ...)
    #endif

    #if ERROR_SWITCH
        #define LOG_ERROR(terminal, format,...)     LOG_PROTO_FAILED(terminal, "[ERROR]:", format, ##__VA_ARGS__)
    #else
        #define LOG_ERROR(terminal, format, ...)
    #endif

    void PRINTF(const char *fmt, ...); /* printfԺ */
#else
    #define SEGGER_RTT_DUBUG_INIT()     /* PRINTF_DEBUG ʱ RTT_DUBUG_INIT Ϊպ */
    #define LOG_INFO(terminal, format, ...)
    #define LOG_WARN(terminal, format, ...)
    #define LOG_DEBUG(terminal, format, ...)
    #define LOG_ERROR(terminal, format, ...)
#endif


/************************************ ӿں *************************************/


#endif /* __BSP_CONFIG_H */
