/**
****************************************************************************************
* @file    : bsp_can.h
* @author  : Samir
* @version : V1.5
* @date    : 2025-3-19
* @brief   : ͷļ
****************************************************************************************
*/
#ifndef __BSP_CAN_H
#define __BSP_CAN_H

#include "./config/bsp_config.h"
#include "can_config.h"


/************************************ ӿ *************************************/
typedef enum    /* CAN  */
{
    CAN_0 = 0U,
    CAN_1,
    CAN_2,
    CAN_3,
    CAN_4,
    CAN_5,
    CAN_6,
    CAN_7
} can_number_t;

typedef struct
{
    uint32_t can_id;                    /* Ϣ ID*/
    uint8_t buffer[64];                 /* ݵĿռ */
    uint8_t size;                       /* ݳȣֽΪλ*/
} can_data_t;                           /* 洢canصݽṹ */
#define CAN_QUEUE_QUANTITY              (16U)   /* CAN */

/* Ӧ޸ */
#define CAN0_SWITCH                     (1U)    /* CAN 0:رգ1 */
#define CAN1_SWITCH                     (1U)    /* CAN 0:رգ1 */
#define CAN2_SWITCH                     (1U)    /* CAN 0:رգ1 */
#define CAN3_SWITCH                     (1U)    /* CAN 0:رգ1 */
#define CAN4_SWITCH                     (1U)    /* CAN 0:رգ1 */
#define CAN5_SWITCH                     (0U)    /* CAN 0:رգ1 */
#define CAN6_SWITCH                     (0U)    /* CAN 0:رգ1 */
#define CAN7_SWITCH                     (0U)    /* CAN 0:رգ1 */

/************************************    CAN0    *************************************/
#if CAN0_SWITCH

#define CAN0_DATA_LENGTH                (8U)    /* CAN0 ݳ */
#define CAN0_RX_MAILBOX                 (0U)    /* CAN0  ʹrx fifoģʽʹô */
#define CAN0_RX_FIFO_FILTER_COUNT       (8U)    /* can0 fifoID */
#define CAN0_RX_FIFO_MAILBOX_COUNT      (8U)    /* can0 fifoʱ */
#define CAN0_TX_START_MAILBOX           (CAN0_RX_FIFO_MAILBOX_COUNT) /* CAN0 ʼ */
#define CAN0_TX_END_MAILBOX             (CAN0_TX_START_MAILBOX + 21) /* CAN0 ͽ */

extern __IO bool g_c0_rx_fifo_flag;         /* fifoģʽĽ״̬ */
extern __IO bool g_c0_rx_flag;              /* ״̬ */
extern __IO bool g_c0_tx_flag;              /* ״̬ */
extern QueueHandle_t c0_tx_queue_handle;    /* CAN0Ͷо */
extern QueueHandle_t c0_rx_queue_handle;    /* CAN0նо */
extern can_data_t bsp_c0_tx_queue[CAN_QUEUE_QUANTITY]; /* CAN0Ͷ */
extern __IO uint8_t uc_c0_tx_count; /* ¼յݴڶеĸĿ */
#endif

/************************************    CAN1    *************************************/
#if CAN1_SWITCH

#define CAN1_DATA_LENGTH                (8U)    /* CAN1 ݳ */
#define CAN1_RX_MAILBOX                 (0U)    /* CAN1  ʹrx fifoģʽʹô */
#define CAN1_RX_FIFO_FILTER_COUNT       (16U)    /* can1 fifoID */
#define CAN1_RX_FIFO_MAILBOX_COUNT      (10U)    /* can1 fifoʱ */
#define CAN1_TX_START_MAILBOX           (CAN1_RX_FIFO_MAILBOX_COUNT) /* CAN1 ʼ */
#define CAN1_TX_END_MAILBOX             (CAN1_TX_START_MAILBOX + 2)  /* CAN1 ͽ */

extern __IO bool g_c1_rx_fifo_flag;         /* fifoģʽĽ״̬ */
extern __IO bool g_c1_rx_flag;              /* ״̬ */
extern __IO bool g_c1_tx_flag;              /* ״̬ */
extern QueueHandle_t c1_tx_queue_handle;    /* CAN1Ͷо */
extern QueueHandle_t c1_rx_queue_handle;    /* CAN1նо */
extern can_data_t bsp_c1_tx_queue[CAN_QUEUE_QUANTITY]; /* CAN1Ͷ */
extern __IO uint8_t uc_c1_tx_count; /* ¼յݴڶеĸĿ */
#endif

/************************************    CAN2    *************************************/
#if CAN2_SWITCH

#define CAN2_DATA_LENGTH                (8U)    /* CAN2 ݳ */
#define CAN2_RX_MAILBOX                 (0U)    /* CAN2  ʹrx fifoģʽʹô */
#define CAN2_RX_FIFO_FILTER_COUNT       (24U)    /* can2 fifoID */
#define CAN2_RX_FIFO_MAILBOX_COUNT      (12U)    /* can2 fifoʱ */
#define CAN2_TX_START_MAILBOX           (CAN2_RX_FIFO_MAILBOX_COUNT) /* CAN2 ʼ */
#define CAN2_TX_END_MAILBOX             (CAN2_TX_START_MAILBOX + 4)  /* CAN2 ͽ */

extern __IO bool g_c2_rx_fifo_flag;         /* fifoģʽĽ״̬ */
extern __IO bool g_c2_rx_flag;              /* ״̬ */
extern __IO bool g_c2_tx_flag;              /* ״̬ */
extern QueueHandle_t c2_tx_queue_handle;    /* CAN2Ͷо */
extern QueueHandle_t c2_rx_queue_handle;    /* CAN2նо */
extern can_data_t bsp_c2_tx_queue[CAN_QUEUE_QUANTITY]; /* CAN2Ͷ */
extern __IO uint8_t uc_c2_tx_count; /* ¼յݴڶеĸĿ */
#endif

/************************************    CAN3    *************************************/
#if CAN3_SWITCH

#define CAN3_DATA_LENGTH                (8U)    /* CAN3 ݳ */
#define CAN3_RX_MAILBOX                 (0U)    /* CAN3  ʹrx fifoģʽʹô */
#define CAN3_RX_FIFO_FILTER_COUNT       (16U)    /* can3 fifoID */
#define CAN3_RX_FIFO_MAILBOX_COUNT      (10U)    /* can3 fifoʱ */
#define CAN3_TX_START_MAILBOX           (CAN3_RX_FIFO_MAILBOX_COUNT) /* CAN3 ʼ */
#define CAN3_TX_END_MAILBOX             (CAN3_TX_START_MAILBOX + 4)  /* CAN3 ͽ */

extern __IO bool g_c3_rx_fifo_flag;         /* fifoģʽĽ״̬ */
extern __IO bool g_c3_rx_flag;              /* ״̬ */
extern __IO bool g_c3_tx_flag;              /* ״̬ */
extern QueueHandle_t c3_tx_queue_handle;    /* CAN3Ͷо */
extern QueueHandle_t c3_rx_queue_handle;    /* CAN3նо */
extern can_data_t bsp_c3_tx_queue[CAN_QUEUE_QUANTITY]; /* CAN3Ͷ */
extern __IO uint8_t uc_c3_tx_count; /* ¼յݴڶеĸĿ */
#endif

/************************************    CAN4    *************************************/
#if CAN4_SWITCH

#define CAN4_DATA_LENGTH                (8U)    /* CAN4 ݳ */
#define CAN4_RX_MAILBOX                 (0U)    /* CAN4  ʹrx fifoģʽʹô */
#define CAN4_RX_FIFO_FILTER_COUNT       (8U)    /* can4 fifoID */
#define CAN4_RX_FIFO_MAILBOX_COUNT      (8U)    /* can4 fifoʱ */
#define CAN4_TX_START_MAILBOX           (CAN4_RX_FIFO_MAILBOX_COUNT) /* CAN4 ʼ */
#define CAN4_TX_END_MAILBOX             (CAN4_TX_START_MAILBOX + 4)  /* CAN4 ͽ */

extern __IO bool g_c4_rx_fifo_flag;         /* fifoģʽĽ״̬ */
extern __IO bool g_c4_rx_flag;              /* ״̬ */
extern __IO bool g_c4_tx_flag;              /* ״̬ */
extern QueueHandle_t c4_tx_queue_handle;    /* CAN4Ͷо */
extern QueueHandle_t c4_rx_queue_handle;    /* CAN4նо */
extern can_data_t bsp_c4_tx_queue[CAN_QUEUE_QUANTITY]; /* CAN4Ͷ */
extern __IO uint8_t uc_c44_tx_count; /* ¼յݴڶеĸĿ */
#endif

/************************************    CAN5    *************************************/
#if CAN5_SWITCH

#define CAN5_DATA_LENGTH                (8U)    /* CAN5 ݳ */
#define CAN5_RX_FILTER_COUNT            (8U)    /* can5 ùID */
#define CAN5_RX_START_MAILBOX           (0U)    /* CAN5 ʼ */
#define CAN5_RX_END_MAILBOX             (CAN5_RX_START_MAILBOX + 8U) /* CAN5 ս */
#define CAN5_TX_START_MAILBOX           (CAN5_RX_END_MAILBOX)        /* CAN5 ʼ */
#define CAN5_TX_END_MAILBOX             (CAN5_TX_START_MAILBOX + 4U) /* CAN5 ͽ */

extern __IO bool g_c5_rx_fifo_flag;         /* fifoģʽĽ״̬ */
extern __IO bool g_c5_rx_flag;              /* ״̬ */
extern __IO bool g_c5_tx_flag;              /* ״̬ */
extern QueueHandle_t c5_tx_queue_handle;    /* CAN5Ͷо */
extern QueueHandle_t c5_rx_queue_handle;    /* CAN5նо */
extern can_data_t bsp_c5_tx_queue[CAN_QUEUE_QUANTITY]; /* CAN5Ͷ */
extern __IO uint8_t uc_c5_tx_count; /* ¼յݴڶеĸĿ */
#endif

/************************************ ӿں *************************************/
void bsp_can_init(can_number_t can_id, uint32_t *id_buf, uint8_t ext_id_num);
uint8_t bsp_can_send_msg(can_number_t can_id, uint32_t id, uint8_t *data, uint8_t id_type);
void bsp_can_queue_send(can_data_t *can_queue, uint32_t can_id, uint8_t *can_data,
                        uint8_t data_len, QueueHandle_t queue_handle, __IO uint8_t *queue_count);

#endif /* __BSP_CAN_H */
