/**
****************************************************************************************
* @file    : bsp_can.c
* @author  : Samir
* @version : V1.5
* @date    : 2025-3-19
* @brief   : can
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include "./can/bsp_can.h"


#if CAN0_SWITCH
__IO bool g_c0_rx_fifo_flag = false;              /* fifoģʽ ״̬ */
__IO bool g_c0_rx_flag = false;                   /* ״̬ */
__IO bool g_c0_tx_flag = false;                   /* ״̬ */
can_data_t bsp_c0_rx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can0ն */
can_data_t bsp_c0_tx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can0Ͷ */
__IO uint8_t uc_c0_rx_count = 0; /* ¼յݴڶеĸĿ */
__IO uint8_t uc_c0_tx_count = 0; /* ¼յݴڶеĸĿ */

flexcan_msgbuff_t can0_rx_msg; /* ջ */

/* canϢ */
const flexcan_data_info_t can0_rx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN0_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/*  IDṹ */
flexcan_id_table_t can0_rx_fifo_filter_acc_info[CAN0_RX_FIFO_FILTER_COUNT];

/* Ϣṹ */
flexcan_data_info_t can0_tx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN0_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* ͵Ϣṹ */
flexcan_msgbuff_t can0_tx_msg = {
    .cs = 0U,
    .msgId = 0x00U,
    .data[0] = 0x00,
    .dataLen = CAN0_DATA_LENGTH
};
#endif /* CAN0_SWITCH */

#if CAN1_SWITCH
__IO bool g_c1_rx_fifo_flag = false;              /* fifoģʽ ״̬ */
__IO bool g_c1_rx_flag = false;                   /* ״̬ */
__IO bool g_c1_tx_flag = false;                   /* ״̬ */
can_data_t bsp_c1_rx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can1ն */
can_data_t bsp_c1_tx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can1Ͷ */
__IO uint8_t uc_c1_rx_count = 0; /* ¼յݴڶеĸĿ */
__IO uint8_t uc_c1_tx_count = 0; /* ¼յݴڶеĸĿ */

flexcan_msgbuff_t can1_rx_msg; /* ջ */

/* canϢ */
const flexcan_data_info_t can1_rx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN1_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/*  IDṹ */
flexcan_id_table_t can1_rx_fifo_filter_acc_info[CAN1_RX_FIFO_FILTER_COUNT];

/* Ϣṹ */
flexcan_data_info_t can1_tx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN1_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* ͵Ϣṹ */
flexcan_msgbuff_t can1_tx_msg = {
    .cs = 0U,
    .msgId = 0x00U,
    .data[0] = 0x00,
    .dataLen = CAN1_DATA_LENGTH
};
#endif /* CAN1_SWITCH */

#if CAN2_SWITCH
__IO bool g_c2_rx_fifo_flag = false;              /* fifoģʽ ״̬ */
__IO bool g_c2_rx_flag = false;                   /* ״̬ */
__IO bool g_c2_tx_flag = false;                   /* ״̬ */
can_data_t bsp_c2_rx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can2ն */
can_data_t bsp_c2_tx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can2Ͷ */
__IO uint8_t uc_c2_rx_count = 0; /* ¼յݴڶеĸĿ */
__IO uint8_t uc_c2_tx_count = 0; /* ¼յݴڶеĸĿ */

flexcan_msgbuff_t can2_rx_msg; /* ջ */

/* canϢ */
const flexcan_data_info_t can2_rx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN2_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/*  IDṹ */
flexcan_id_table_t can2_rx_fifo_filter_acc_info[CAN2_RX_FIFO_FILTER_COUNT];

/* Ϣṹ */
flexcan_data_info_t can2_tx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN2_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* ͵Ϣṹ */
flexcan_msgbuff_t can2_tx_msg = {
    .cs = 0U,
    .msgId = 0x00U,
    .data[0] = 0x00,
    .dataLen = CAN2_DATA_LENGTH
};
#endif /* CAN2_SWITCH */

#if CAN3_SWITCH
__IO bool g_c3_rx_fifo_flag = false;              /* fifoģʽ ״̬ */
__IO bool g_c3_rx_flag = false;                   /* ״̬ */
__IO bool g_c3_tx_flag = false;                   /* ״̬ */
can_data_t bsp_c3_rx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can3ն */
can_data_t bsp_c3_tx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can3Ͷ */
__IO uint8_t uc_c3_rx_count = 0; /* ¼յݴڶеĸĿ */
__IO uint8_t uc_c3_tx_count = 0; /* ¼յݴڶеĸĿ */

flexcan_msgbuff_t can3_rx_msg; /* ջ */

/* canϢ */
const flexcan_data_info_t can3_rx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN3_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/*  IDṹ */
flexcan_id_table_t can3_rx_fifo_filter_acc_info[CAN3_RX_FIFO_FILTER_COUNT];

/* Ϣṹ */
flexcan_data_info_t can3_tx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN3_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* ͵Ϣṹ */
flexcan_msgbuff_t can3_tx_msg = {
    .cs = 0U,
    .msgId = 0x00U,
    .data[0] = 0x00,
    .dataLen = CAN3_DATA_LENGTH
};
#endif /* CAN3_SWITCH */

#if CAN4_SWITCH
__IO bool g_c4_rx_fifo_flag = false;              /* fifoģʽ ״̬ */
__IO bool g_c4_rx_flag = false;                   /* ״̬ */
__IO bool g_c4_tx_flag = false;                   /* ״̬ */
can_data_t bsp_c4_rx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can4ն */
can_data_t bsp_c4_tx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can4Ͷ */
__IO uint8_t uc_c4_rx_count = 0; /* ¼յݴڶеĸĿ */
__IO uint8_t uc_c4_tx_count = 0; /* ¼յݴڶеĸĿ */

flexcan_msgbuff_t can4_rx_msg; /* ջ */

/* canϢ */
const flexcan_data_info_t can4_rx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN4_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/*  IDṹ */
flexcan_id_table_t can4_rx_fifo_filter_acc_info[CAN4_RX_FIFO_FILTER_COUNT];

/* Ϣṹ */
flexcan_data_info_t can4_tx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN4_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* ͵Ϣṹ */
flexcan_msgbuff_t can4_tx_msg = {
    .cs = 0U,
    .msgId = 0x00U,
    .data[0] = 0x00,
    .dataLen = CAN4_DATA_LENGTH
};
#endif /* CAN4_SWITCH */

#if CAN5_SWITCH
__IO bool g_c5_rx_fifo_flag = false;              /* fifoģʽ ״̬ */
__IO bool g_c5_rx_flag = false;                   /* ״̬ */
__IO bool g_c5_tx_flag = false;                   /* ״̬ */
can_data_t bsp_c5_rx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can5ն */
can_data_t bsp_c5_tx_queue[CAN_QUEUE_QUANTITY] = {0}; /* can5Ͷ */
__IO uint8_t uc_c5_rx_count = 0; /* ¼յݴڶеĸĿ */
__IO uint8_t uc_c5_tx_count = 0; /* ¼յݴڶеĸĿ */

flexcan_msgbuff_t can5_rx_msg; /* ջ */

/* canϢ ׼֡ */
const flexcan_data_info_t can5_rx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN5_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* canϢ Զ֡ */
const flexcan_data_info_t can5_rx_mb_exd_info = {
    .msg_id_type = FLEXCAN_MSG_ID_EXT,
    .data_length = CAN5_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* Ϣṹ */
flexcan_data_info_t can5_tx_mb_std_info = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = CAN5_DATA_LENGTH,
    .fd_enable = false,
    .fd_padding = 0,
    .enable_brs = false,
    .is_remote = false,
};

/* ͵Ϣṹ */
flexcan_msgbuff_t can5_tx_msg = {
    .cs = 0U,
    .msgId = 0x00U,
    .data[0] = 0x00,
    .dataLen = CAN5_DATA_LENGTH
};
#endif /* CAN5_SWITCH */

#if CAN0_SWITCH
/* can0صʵ */
static void bsp_can0_callback(uint8_t instance, flexcan_event_type_t eventType,
                              uint32_t buffIdx, flexcan_state_t *flexcanState)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    switch (eventType) 
    {
    case FLEXCAN_EVENT_RX_COMPLETE:                 /* RXģʽ */
        g_c0_rx_flag = true;
        // FLEXCAN_DRV_Receive(0, &can0_rx_msg);        /* ʼݡ */
        break;

    case FLEXCAN_EVENT_RXFIFO_COMPLETE:             /* RXFIFO ģʽ */
        g_c0_rx_fifo_flag = true;

        /* յԶеķʽݸӦ */
        bsp_can_queue_send(bsp_c0_rx_queue, can0_rx_msg.msgId, can0_rx_msg.data, 
                    can0_rx_msg.dataLen, c0_rx_queue_handle, &uc_c0_rx_count); 
        FLEXCAN_DRV_RxFifo(CAN_0, &can0_rx_msg);        /* ʼݡ */
    break;  

    case FLEXCAN_EVENT_TX_COMPLETE:                 /*  */
        g_c0_tx_flag = true;
    break;

    default:                                        /*  */
        break;
    }
}
#endif /* CAN0_SWITCH */

#if CAN1_SWITCH
/* can1صʵ */
static void bsp_can1_callback(uint8_t instance, flexcan_event_type_t eventType,
                              uint32_t buffIdx, flexcan_state_t *flexcanState)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    switch (eventType) 
    {
    case FLEXCAN_EVENT_RX_COMPLETE:                 /* RXģʽ */
        g_c1_rx_flag = true;
        // FLEXCAN_DRV_Receive(CAN_1, &can1_rx_msg);        /* ʼݡ */
        break;

    case FLEXCAN_EVENT_RXFIFO_COMPLETE:             /* RXFIFO ģʽ */
        g_c1_rx_fifo_flag = true;

        /* յԶеķʽݸӦ */
        bsp_can_queue_send(bsp_c1_rx_queue, can1_rx_msg.msgId, can1_rx_msg.data, 
                    can1_rx_msg.dataLen, c1_rx_queue_handle, &uc_c1_rx_count); 
        FLEXCAN_DRV_RxFifo(CAN_1, &can1_rx_msg);        /* ʼݡ */
    break;  

    case FLEXCAN_EVENT_TX_COMPLETE:                 /*  */
        g_c1_tx_flag = true;
    break;

    default:                                        /*  */
        break;
    }
}
#endif /* CAN1_SWITCH */

#if CAN2_SWITCH
/* can2صʵ */
static void bsp_can2_callback(uint8_t instance, flexcan_event_type_t eventType,
                              uint32_t buffIdx, flexcan_state_t *flexcanState)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    switch (eventType) 
    {
    case FLEXCAN_EVENT_RX_COMPLETE:                 /* RXģʽ */
        g_c2_rx_flag = true;
        // FLEXCAN_DRV_Receive(CAN_2, &can2_rx_msg);        /* ʼݡ */
        break;

    case FLEXCAN_EVENT_RXFIFO_COMPLETE:             /* RXFIFO ģʽ */
        g_c2_rx_fifo_flag = true;

        /* յԶеķʽݸӦ */
        bsp_can_queue_send(bsp_c2_rx_queue, can2_rx_msg.msgId, can2_rx_msg.data, 
                    can2_rx_msg.dataLen, c2_rx_queue_handle, &uc_c2_rx_count); 
        FLEXCAN_DRV_RxFifo(CAN_2, &can2_rx_msg);        /* ʼݡ */
    break;  

    case FLEXCAN_EVENT_TX_COMPLETE:                 /*  */
        g_c2_tx_flag = true;
    break;

    default:                                        /*  */
        break;
    }
}
#endif /* CAN2_SWITCH */

#if CAN3_SWITCH
/* can3صʵ */
static void bsp_can3_callback(uint8_t instance, flexcan_event_type_t eventType,
                              uint32_t buffIdx, flexcan_state_t *flexcanState)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    switch (eventType) 
    {
    case FLEXCAN_EVENT_RX_COMPLETE:                 /* RXģʽ */
        g_c3_rx_flag = true;
        // FLEXCAN_DRV_Receive(CAN_3, &can3_rx_msg);        /* ʼݡ */
        break;

    case FLEXCAN_EVENT_RXFIFO_COMPLETE:             /* RXFIFO ģʽ */
        g_c3_rx_fifo_flag = true;

        /* յԶеķʽݸӦ */
        bsp_can_queue_send(bsp_c3_rx_queue, can3_rx_msg.msgId, can3_rx_msg.data, 
                    can3_rx_msg.dataLen, c3_rx_queue_handle, &uc_c3_rx_count); 
        FLEXCAN_DRV_RxFifo(CAN_3, &can3_rx_msg);        /* ʼݡ */
    break;  

    case FLEXCAN_EVENT_TX_COMPLETE:                 /*  */
        g_c3_tx_flag = true;
    break;

    default:                                        /*  */
        break;
    }
}
#endif /* CAN3_SWITCH */

#if CAN4_SWITCH
/* can4صʵ */
static void bsp_can4_callback(uint8_t instance, flexcan_event_type_t eventType,
                              uint32_t buffIdx, flexcan_state_t *flexcanState)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    switch (eventType) 
    {
    case FLEXCAN_EVENT_RX_COMPLETE:                 /* RXģʽ */
        g_c4_rx_flag = true;
        // FLEXCAN_DRV_Receive(CAN_4, &can4_rx_msg);        /* ʼݡ */
        break;

    case FLEXCAN_EVENT_RXFIFO_COMPLETE:             /* RXFIFO ģʽ */
        g_c4_rx_fifo_flag = true;

        /* յԶеķʽݸӦ */
        bsp_can_queue_send(bsp_c4_rx_queue, can4_rx_msg.msgId, can4_rx_msg.data, 
                    can4_rx_msg.dataLen, c4_rx_queue_handle, &uc_c4_rx_count); 
        FLEXCAN_DRV_RxFifo(CAN_4, &can4_rx_msg);        /* ʼݡ */
    break;  

    case FLEXCAN_EVENT_TX_COMPLETE:                 /*  */
        g_c4_tx_flag = true;
    break;

    default:                                        /*  */
        break;
    }
}
#endif /* CAN4_SWITCH */

#if CAN5_SWITCH
/* can5صʵ */
static void bsp_can5_callback(uint8_t instance, flexcan_event_type_t eventType,
                              uint32_t buffIdx, flexcan_state_t *flexcanState)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */

    switch (eventType) 
    {
    case FLEXCAN_EVENT_RX_COMPLETE:                 /* RXģʽ */
        g_c5_rx_flag = true;

        bsp_can_queue_send(bsp_c5_rx_queue, can5_rx_msg.msgId, can5_rx_msg.data, 
            can5_rx_msg.dataLen, c5_rx_queue_handle, &uc_c5_rx_count);

        for (uint8_t mailbox_num = CAN5_RX_START_MAILBOX; mailbox_num < CAN5_RX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_5, mailbox_num) != STATUS_BUSY)
            {
                FLEXCAN_DRV_Receive(CAN_5, mailbox_num, &can5_rx_msg); /* ʼݡ */
                break;
            }
        }
        
        break;

    case FLEXCAN_EVENT_RXFIFO_COMPLETE:             /* RXFIFO ģʽ */
        g_c5_rx_fifo_flag = true;
    break;  

    case FLEXCAN_EVENT_TX_COMPLETE:                 /*  */
        g_c5_tx_flag = true;
    break;

    default:                                        /*  */
        break;
    }
}
#endif /* CAN5_SWITCH */

/**
 * @brief   CANʼ
 * @param   can_id:CANʵ
 * @param   id_buf:id飬׼IDǰչIDںCAN fifoģʽµĹ
 * @param   ext_id_num:idչID
 * @author  Samir
 * @version 1.0
 * @date    2024-11-26
 */
void bsp_can_init(can_number_t can_id, uint32_t *id_buf, uint8_t ext_id_num)
{
#if CAN0_SWITCH
    if (can_id == CAN_0)
    {
        /* ñ׼IDĹϢ */
        for (uint8_t i = 0; i < ((uint8_t)CAN0_RX_FIFO_FILTER_COUNT - ext_id_num); i++)
        {
            can0_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can0_rx_fifo_filter_acc_info[i].isExtendedFrame = false; /* ׼ID */
            can0_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        /* չIDĹϢ */
        for (uint8_t i = ((uint8_t)CAN0_RX_FIFO_FILTER_COUNT - ext_id_num); i < (uint8_t)CAN0_RX_FIFO_FILTER_COUNT; i++)
        {
            can0_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can0_rx_fifo_filter_acc_info[i].isExtendedFrame = true; /* չID */
            can0_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        FLEXCAN_DRV_Init(CAN_0, &flexcan0_init_config0_State, &flexcan0_init_config0);
        for(uint8_t i = CAN0_TX_START_MAILBOX; i < CAN0_TX_END_MAILBOX; i++)    /* TX  */
        {
            FLEXCAN_DRV_ConfigTxMb(CAN_0, i, &can0_tx_mb_std_info, 0x00U);
        }
        FLEXCAN_DRV_ConfigRxFifo(CAN_0, FLEXCAN_RX_FIFO_ID_FORMAT_A, can0_rx_fifo_filter_acc_info); /* ýFIFO */
        FLEXCAN_DRV_InstallEventCallback(CAN_0, bsp_can0_callback, NULL);                           /* װcanص */
        FLEXCAN_DRV_RxFifo(CAN_0, &can0_rx_msg);                                                    /* ʹRX FIFO  CAN ֡ */
    }
#endif /* CAN0_SWITCH */

#if CAN1_SWITCH
    if (can_id == CAN_1)
    {
        /* ñ׼IDĹϢ */
        for (uint8_t i = 0; i < ((uint8_t)CAN1_RX_FIFO_FILTER_COUNT - ext_id_num); i++)
        {
            can1_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can1_rx_fifo_filter_acc_info[i].isExtendedFrame = false; /* ׼ID */
            can1_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        /* չIDĹϢ */
        for (uint8_t i = ((uint8_t)CAN1_RX_FIFO_FILTER_COUNT - ext_id_num); i < (uint8_t)CAN1_RX_FIFO_FILTER_COUNT; i++)
        {
            can1_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can1_rx_fifo_filter_acc_info[i].isExtendedFrame = true; /* չID */
            can1_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        FLEXCAN_DRV_Init(CAN_1, &flexcan1_init_config1_State, &flexcan1_init_config1);
        for(uint8_t i = CAN1_TX_START_MAILBOX; i < CAN1_TX_END_MAILBOX; i++)    /* TX  */
        {
            FLEXCAN_DRV_ConfigTxMb(CAN_1, i, &can1_tx_mb_std_info, 0x00U);                
        }
        FLEXCAN_DRV_ConfigRxFifo(CAN_1, FLEXCAN_RX_FIFO_ID_FORMAT_A, can1_rx_fifo_filter_acc_info); /* ýFIFO */
        FLEXCAN_DRV_InstallEventCallback(CAN_1, bsp_can1_callback, NULL);                           /* װcanص */
        FLEXCAN_DRV_RxFifo(CAN_1, &can1_rx_msg);                                                    /* ʹRX FIFO  CAN ֡ */
    }
#endif /* CAN1_SWITCH */

#if CAN2_SWITCH
    if (can_id == CAN_2)
    {
        /* ñ׼IDĹϢ */
        for (uint8_t i = 0; i < ((uint8_t)CAN2_RX_FIFO_FILTER_COUNT - ext_id_num); i++)
        {
            can2_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can2_rx_fifo_filter_acc_info[i].isExtendedFrame = false; /* ׼ID */
            can2_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        /* չIDĹϢ */
        for (uint8_t i = ((uint8_t)CAN2_RX_FIFO_FILTER_COUNT - ext_id_num); i < (uint8_t)CAN2_RX_FIFO_FILTER_COUNT; i++)
        {
            can2_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can2_rx_fifo_filter_acc_info[i].isExtendedFrame = true; /* չID */
            can2_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        FLEXCAN_DRV_Init(CAN_2, &flexcan2_init_config2_State, &flexcan2_init_config2);
        for(uint8_t i = CAN2_TX_START_MAILBOX; i < CAN2_TX_END_MAILBOX; i++)    /* TX  */
        {
            FLEXCAN_DRV_ConfigTxMb(CAN_2, i, &can2_tx_mb_std_info, 0x00U);                
        }
        FLEXCAN_DRV_ConfigRxFifo(CAN_2, FLEXCAN_RX_FIFO_ID_FORMAT_A, can2_rx_fifo_filter_acc_info); /* ýFIFO */
        FLEXCAN_DRV_InstallEventCallback(CAN_2, bsp_can2_callback, NULL);                           /* װcanص */
        FLEXCAN_DRV_RxFifo(CAN_2, &can2_rx_msg);                                                    /* ʹRX FIFO  CAN ֡ */
    }
#endif /* CAN2_SWITCH */

#if CAN3_SWITCH
    if (can_id == CAN_3)
    {
        /* ñ׼IDĹϢ */
        for (uint8_t i = 0; i < ((uint8_t)CAN3_RX_FIFO_FILTER_COUNT - ext_id_num); i++)
        {
            can3_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can3_rx_fifo_filter_acc_info[i].isExtendedFrame = false; /* ׼ID */
            can3_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        /* չIDĹϢ */
        for (uint8_t i = ((uint8_t)CAN3_RX_FIFO_FILTER_COUNT - ext_id_num); i < (uint8_t)CAN3_RX_FIFO_FILTER_COUNT; i++)
        {
            can3_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can3_rx_fifo_filter_acc_info[i].isExtendedFrame = true; /* չID */
            can3_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        FLEXCAN_DRV_Init(CAN_3, &flexcan3_init_config3_State, &flexcan3_init_config3);
        for(uint8_t i = CAN3_TX_START_MAILBOX; i < CAN3_TX_END_MAILBOX; i++)    /* TX  */
        {
            FLEXCAN_DRV_ConfigTxMb(CAN_3, i, &can3_tx_mb_std_info, 0x00U);                
        }
        FLEXCAN_DRV_ConfigRxFifo(CAN_3, FLEXCAN_RX_FIFO_ID_FORMAT_A, can3_rx_fifo_filter_acc_info); /* ýFIFO */
        FLEXCAN_DRV_InstallEventCallback(CAN_3, bsp_can3_callback, NULL);                           /* װcanص */
        FLEXCAN_DRV_RxFifo(CAN_3, &can3_rx_msg);                                                    /* ʹRX FIFO  CAN ֡ */
    }
#endif /* CAN3_SWITCH */

#if CAN4_SWITCH
    if (can_id == CAN_4)
    {
        /* ñ׼IDĹϢ */
        for (uint8_t i = 0; i < ((uint8_t)CAN4_RX_FIFO_FILTER_COUNT - ext_id_num); i++)
        {
            can4_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can4_rx_fifo_filter_acc_info[i].isExtendedFrame = false; /* ׼ID */
            can4_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        /* չIDĹϢ */
        for (uint8_t i = ((uint8_t)CAN4_RX_FIFO_FILTER_COUNT - ext_id_num); i < (uint8_t)CAN4_RX_FIFO_FILTER_COUNT; i++)
        {
            can4_rx_fifo_filter_acc_info[i].isRemoteFrame = false;
            can4_rx_fifo_filter_acc_info[i].isExtendedFrame = true; /* չID */
            can4_rx_fifo_filter_acc_info[i].id = id_buf[i];
        }
        FLEXCAN_DRV_Init(CAN_4, &flexcan4_init_config4_State, &flexcan4_init_config4);
        for(uint8_t i = CAN4_TX_START_MAILBOX; i < CAN4_TX_END_MAILBOX; i++)    /* TX  */
        {
            FLEXCAN_DRV_ConfigTxMb(CAN_4, i, &can4_tx_mb_std_info, 0x00U);                
        }
        FLEXCAN_DRV_ConfigRxFifo(CAN_4, FLEXCAN_RX_FIFO_ID_FORMAT_A, can4_rx_fifo_filter_acc_info); /* ýFIFO */
        FLEXCAN_DRV_InstallEventCallback(CAN_4, bsp_can4_callback, NULL);                           /* װcanص */
        FLEXCAN_DRV_RxFifo(CAN_4, &can4_rx_msg);                                                    /* ʹRX FIFO  CAN ֡ */
    }
#endif /* CAN4_SWITCH */

#if CAN5_SWITCH
    if (can_id == CAN_5)
    {
        FLEXCAN_DRV_Init(CAN_5, &flexcan5_init_config5_State, &flexcan5_init_config5);
        for (uint8_t i = 0; i < ((uint8_t)CAN5_RX_FILTER_COUNT - ext_id_num); i++)
        {
            FLEXCAN_DRV_ConfigRxMb(CAN_5, i, &can5_rx_mb_std_info, id_buf[i]);
            FLEXCAN_DRV_Receive(CAN_5, i, &can5_rx_msg);
        }
        /* չIDĹϢ */
        for (uint8_t i = ((uint8_t)CAN5_RX_FILTER_COUNT - ext_id_num); i < (uint8_t)CAN5_RX_FILTER_COUNT; i++)
        {
            FLEXCAN_DRV_ConfigRxMb(CAN_5, i, &can5_rx_mb_exd_info, id_buf[i]);
            FLEXCAN_DRV_Receive(CAN_5, i, &can5_rx_msg);
        }
        for (uint8_t i = CAN5_TX_START_MAILBOX; i < CAN5_TX_END_MAILBOX; i++) /* TX  */
        {
            FLEXCAN_DRV_ConfigTxMb(CAN_5, i, &can5_tx_mb_std_info, 0x00U);
        }        
        FLEXCAN_DRV_InstallEventCallback(CAN_5, bsp_can5_callback, NULL); /* װcanص */
    }
#endif /* CAN5_SWITCH */
}

/**
 * @brief   CANöд
 * @param   can_queue:canݶл
 * @param   can_id: canϢID
 * @param   can_data: canϢ
 * @param   data_len: ݳ
 * @param   queue_handle: о
 * @param   queue_count: ݶл
 * @author  Samir
 * @version 1.0
 * @date    2024-11-26
 */
void bsp_can_queue_send(can_data_t *can_queue, uint32_t can_id, uint8_t *can_data, 
                uint8_t data_len, QueueHandle_t queue_handle, __IO uint8_t *queue_count)
{
    can_data_t *p_can_data = NULL;            /* canݽṹָ */
    BaseType_t task_switching_flag = pdFALSE; /* ȼл־ */
    uint8_t can_queue_count = *queue_count;

    
    can_queue[can_queue_count].can_id = can_id;
    memcpy(can_queue[can_queue_count].buffer, can_data, data_len);
    can_queue[can_queue_count].size = data_len;
    p_can_data = &can_queue[can_queue_count]; /* Ҫ͵ݶ */
    can_queue_count++;
    can_queue_count %= CAN_QUEUE_QUANTITY;            /* ȡֹԽ */
    memset(can_queue[can_queue_count].buffer, 0, 64); /* һ */
    *queue_count = can_queue_count;                   /* ¼ֵ */
    if (xQueueSendToBackFromISR(queue_handle, &p_can_data, &task_switching_flag) != pdTRUE)
    {
        LOG_ERROR(15, "Queue handle %p is full\r\n", (void *)queue_handle);
    }
    if (task_switching_flag == pdTRUE)
    {
        portYIELD_FROM_ISR(task_switching_flag);
    }
}

/**
 * @brief   CANϢ
 * @param   can_id:CANʵ
 * @param   id:CANϢID
 * @param   data:͵can
 * @param   id_type:CAN ID, 0:׼ID, 1:չID
 * @return  0:ɹ, 0:ʧ
 * @author  Samir
 * @version 2.0
 * @date    2025-03-10
 */
uint8_t bsp_can_send_msg(can_number_t can_id, uint32_t id, uint8_t *data, uint8_t id_type)
{
    status_t status = STATUS_SUCCESS;

#if CAN0_SWITCH
    if (can_id == CAN_0)
    {
        can0_tx_mb_std_info.msg_id_type = id_type;

        for (uint8_t i = 0; i < CAN0_DATA_LENGTH; i++)
        {
            can0_tx_msg.data[i] = data[i];
        }

        for(uint8_t mailbox_num = CAN0_TX_START_MAILBOX; mailbox_num < CAN0_TX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_0, mailbox_num) != STATUS_BUSY)
            {
                status &= 0;
                status |= FLEXCAN_DRV_Send(CAN_0, mailbox_num, &can0_tx_mb_std_info, id, can0_tx_msg.data);
                break;
            }
            else
            {
                status |= STATUS_BUSY;
            }
        }
    }
#endif

#if CAN1_SWITCH
    if (can_id == CAN_1)
    {
        can1_tx_mb_std_info.msg_id_type = id_type;

        for (uint8_t i = 0; i < CAN1_DATA_LENGTH; i++)
        {
            can1_tx_msg.data[i] = data[i];
        }
        for(uint8_t mailbox_num = CAN1_TX_START_MAILBOX; mailbox_num < CAN1_TX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_1, mailbox_num) != STATUS_BUSY)
            {
                status &= 0;
                status |= FLEXCAN_DRV_Send(CAN_1, mailbox_num, &can1_tx_mb_std_info, id, can1_tx_msg.data);
                break;
            }
            else
            {
                status |= STATUS_BUSY;
            }
        }
    }
#endif

#if CAN2_SWITCH
    if (can_id == CAN_2)
    {
        can2_tx_mb_std_info.msg_id_type = id_type;

        for (uint8_t i = 0; i < CAN2_DATA_LENGTH; i++)
        {
            can2_tx_msg.data[i] = data[i];
        }
        for(uint8_t mailbox_num = CAN2_TX_START_MAILBOX; mailbox_num < CAN2_TX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_2, mailbox_num) != STATUS_BUSY)
            {
                status &= 0;
                status |= FLEXCAN_DRV_Send(CAN_2, mailbox_num, &can2_tx_mb_std_info, id, can2_tx_msg.data);
                break;
            }
            else
            {
                status |= STATUS_BUSY;
            }
        }
    }
#endif

#if CAN3_SWITCH
   if (can_id == CAN_3)
    {
        can3_tx_mb_std_info.msg_id_type = id_type;

        for (uint8_t i = 0; i < CAN3_DATA_LENGTH; i++)
        {
            can3_tx_msg.data[i] = data[i];
        }
        for(uint8_t mailbox_num = CAN3_TX_START_MAILBOX; mailbox_num < CAN3_TX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_3, mailbox_num) != STATUS_BUSY)
            {
                status &= 0;
                status |= FLEXCAN_DRV_Send(CAN_3, mailbox_num, &can3_tx_mb_std_info, id, can3_tx_msg.data);
                break;
            }
            else
            {
                status |= STATUS_BUSY;
            }
        }
    }
#endif

#if CAN4_SWITCH
   if (can_id == CAN_4)
    {
        can4_tx_mb_std_info.msg_id_type = id_type;

        for (uint8_t i = 0; i < CAN4_DATA_LENGTH; i++)
        {
            can4_tx_msg.data[i] = data[i];
        }
        for(uint8_t mailbox_num = CAN4_TX_START_MAILBOX; mailbox_num < CAN4_TX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_4, mailbox_num) != STATUS_BUSY)
            {
                status &= 0;
                status |= FLEXCAN_DRV_Send(CAN_4, mailbox_num, &can4_tx_mb_std_info, id, can4_tx_msg.data);
                break;
            }
            else
            {
                status |= STATUS_BUSY;
            }
        }
    }
#endif

#if CAN5_SWITCH
    if (can_id == CAN_5)
    {
        can5_tx_mb_std_info.msg_id_type = id_type;
        
        for (uint8_t i = 0; i < CAN5_DATA_LENGTH; i++)
        {
            can5_tx_msg.data[i] = data[i];
        }
        for(uint8_t mailbox_num = CAN5_TX_START_MAILBOX; mailbox_num < CAN5_TX_END_MAILBOX; mailbox_num++)
        {
            if (FLEXCAN_DRV_GetTransferStatus(CAN_5, mailbox_num) != STATUS_BUSY)
            {
                status &= 0;
                status |= FLEXCAN_DRV_Send(CAN_5, mailbox_num, &can5_tx_mb_std_info, id, can5_tx_msg.data);
                break;
            }
            else
            {
                status |= STATUS_BUSY;
            }
        }
    }
#endif

    return status;
}

/************************************* END OF FILE ************************************/