/**
****************************************************************************************
* @file    : task_u0_tx.c
* @author  : Samir
* @version : V1.0
* @date    : 2024-11-25
* @brief   : 0
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include "task_u0_tx.h"
#include "./uart/bsp_uart.h"
#include "./reel/bsp_reel.h"
#include "flash_driver.h"


/**
 * @brief   0
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void u0_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    uart_data_t *p_uart_data = NULL;
    TickType_t xLastWakeTime;
    char c = 0;

//    bsp_reel_erase_sector(); /*  */

    bsp_reel_init(); /* ʼ */

    LOG_INFO(5, "---u0_tx_task_fun start---\r\n");

    while (1)
    {
        if (g_u0_rx_timeout_flag == true)
        {
            g_u0_rx_timeout_flag = false;
        }

        c = SEGGER_RTT_GetKey();
        switch (c)
        {
        case 'a':         
            bsp_reel_erase_sector(); /* д */
            break;

        case 'q':
            reel_encoder_data++;            
            bsp_reel_write_data(&reel_encoder_data); /* д */
            break;

        case 'w':
            reel_encoder_data--;
            bsp_reel_write_data(&reel_encoder_data); /* д */
            break;

        case 'c':
            LOG_INFO(5, "---c---\r\n");
            uint32_t pre_timing2;
            pre_timing2 = EFM->TIMING2;
            FLASH_DRV_EraseSector(0,
                                  (0x02019100) & ~(FEATURE_EFM_MAIN_ARRAY_SECTOR_SIZE - 1),
                                  FEATURE_EFM_MAIN_ARRAY_SECTOR_SIZE);
            FLASH_DRV_Program(0, (0x02019100), FEATURE_EFM_MAIN_ARRAY_SECTOR_SIZE, (const void *)0x20000000);
            /* It's only for test by modify timing. MUST NOT use in production environment. */
            EFM->TIMING2 = 0x40;
            FLASH_DRV_EraseSector(0,
                                  (0x02019100) & ~(FEATURE_EFM_MAIN_ARRAY_SECTOR_SIZE - 1),
                                  FEATURE_EFM_MAIN_ARRAY_SECTOR_SIZE);
            EFM->TIMING2 = pre_timing2;
            break;

        default:
            break;
        }

        LOG_INFO(5, "---u0_tx_task_fun run---\r\n");
        vTaskDelay(30);
    }
}


/**
 * @brief   5
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void u5_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    uart_data_t *p_uart_data = NULL;

    LOG_INFO(7, "---u5_tx_task_fun start---\n");

    while (1)
    {
        if (g_u5_rx_timeout_flag == true)
        {
            g_u5_rx_timeout_flag = false;
        }
        vTaskDelay(30);
    }
}

/************************************* END OF FILE ************************************/