/**
****************************************************************************************
* @file    : task_u0_rx.c
* @author  : Samir
* @version : V1.0
* @date    : 2024-11-25
* @brief   : 0
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include "task_u0_rx.h"
#include "./uart/bsp_uart.h"



/**
 * @brief   0
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void u0_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    uart_data_t *p_uart_data = NULL;   /* ݽṹָ */

    LOG_INFO(5, "---u0_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(u0_rx_queue_handle, &(p_uart_data), 100) == pdTRUE)
        {
            LOG_INFO(5, "---u0_rx_task_fun---\n");
            LOG_INFO(5, "buffer=%s\n", p_uart_data->buffer);
            LOG_INFO(5, "size=%d\n", p_uart_data->size);
            bsp_uart_send(UART_0, p_uart_data->buffer, p_uart_data->size);
        }
    }
}

/**
 * @brief   5
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void u5_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    uart_data_t *p_uart_data = NULL;   /* ݽṹָ */

    LOG_INFO(7, "---u5_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(u5_rx_queue_handle, &p_uart_data, 100) == pdTRUE)
        {
            LOG_INFO(7, "---u5_rx_task_fun---\n");
            LOG_INFO(7, "buffer=%s\n", p_uart_data->buffer);
            LOG_INFO(7, "size=%d\n", p_uart_data->size);
            bsp_uart_send(UART_5, p_uart_data->buffer, p_uart_data->size);
        }
    }
}

/************************************* END OF FILE ************************************/
