                                                                                                                                  /**
****************************************************************************************
* @file    : task_input.c
* @author  : Samir
* @version : V1.0
* @date    : 2025-02-14
* @brief   : 
****************************************************************************************
* @attention
*
*
*
****************************************************************************************
*/
#include "task_input.h"
#include "./input/bsp_input.h"
#include "./input/bsp_key_fifo.h"
#include "./output/bsp_output.h"
#include "./fan/bsp_fan.h"


uint16_t speed1 = 0;
uint8_t speed2 = 0;


/**
 * @brief  
 * @param  
 * @retval 
 */
void input_task_fun(void)
{
    uint8_t key_code; /*  */
    TickType_t xLastWakeTime;

    bsp_input_init(); /* ʼֵ */

    xLastWakeTime = xTaskGetTickCount();

    LOG_INFO(6, "---input_task_fun start---\n");

    while (1)
    {
        key_scan10ms();

        /* ˲ͼɺ̨systickжϷʵֻ֣Ҫkey_getȡֵɡ */
        key_code = key_get(); /* ȡֵ, ޼ʱ KEY_NONE = 0 */
        if (key_code != KEY_NONE)
        {
            switch (key_code)
            {
            case DI1_DOWN:
                LOG_INFO(6, "DI1_DOWN\r\n");
                break;

            case DI1_LONG_DOWN:
                LOG_INFO(6, "DI1_LONG_DOWN\r\n");
                break;

            case DI2_DOWN:
                LOG_INFO(6, "DI2_DOWN\r\n");
                break;

            case KEY_LONG_DOWN_K2:
                LOG_INFO(6, "KEY_LONG_DOWN_K2\r\n");
                break;

            case DI3_DOWN:
                LOG_INFO(6, "DI3_DOWN\r\n");
                break;

            case DI4_DOWN:
                LOG_INFO(6, "DI4_DOWN\r\n");
                break;

            case DI5_DOWN:
                LOG_INFO(6, "DI5_DOWN\r\n");
                break;

            case DI6_DOWN:
                LOG_INFO(6, "DI6_DOWN\r\n");
                break;

            case DI7_DOWN:
                LOG_INFO(6, "DI7_DOWN\r\n");
                break;

            case DI8_DOWN:
                LOG_INFO(6, "DI8_DOWN\r\n");
                break;

            case DI9_DOWN:
                LOG_INFO(6, "DI9_DOWN\r\n");                
                if (speed2 <= 0)
                {
                    speed2 = 0;
                }
                {
                    speed2--;
                }
                LOG_INFO(6, "speed2=%d\r\n", speed2);
                bsp_fan_speed_set(FAN2_PWM_INST, speed2);
                break;

            case DI10_DOWN:
                LOG_INFO(6, "DI10_DOWN\r\n");            
                if (speed2 >= 100)
                {
                    speed2 = 100;
                }
                {
                    speed2 += 10;
                }
                LOG_INFO(6, "speed2=%d\r\n", speed2);
                bsp_fan_speed_set(FAN2_PWM_INST, speed2);
                break;

            case DI11_DOWN:
                LOG_INFO(6, "DI11_DOWN\r\n");                
                if (speed1 <= 0)
                {
                    speed1 = 0;
                }
                else
                {
                    speed1 -= 10;
                }
                LOG_INFO(6, "speed1=%d\r\n", speed1);
                bsp_fan_speed_set(FAN1_PWM_INST, speed1);
                break;

            case DI12_DOWN:
                LOG_INFO(6, "DI12_DOWN\r\n");
                if (speed1 >= 100)
                {
                    speed1 = 100;
                }
                else
                {
                    speed1 += 10;
                }
                LOG_INFO(6, "speed1=%d\r\n", speed1);
                bsp_fan_speed_set(FAN1_PWM_INST, speed1);
                break;

            case FAN1_FB_DOWN:
                LOG_INFO(6, "FAN1_FB_DOWN\r\n");
              break;  

            case FAN2_FB_DOWN:
                LOG_INFO(6, "FAN2_FB_DOWN\r\n");
                break;
        
            default:
                /* ļֵ */
                break;
            }
        }
        vTaskDelayUntil(&xLastWakeTime, 10);
    }
}

/************************************* END OF FILE ************************************/