/**
****************************************************************************************
* @file    : task_c0_tx.c
* @author  : Samir
* @version : V1.0
* @date    : 2024-11-25
* @brief   : can0 
****************************************************************************************
* @attention
*            
*
*
****************************************************************************************
*/
#include "task_c0_tx.h"
#include "./can/bsp_can.h"


/**
 * @brief   can0 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c0_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint8_t data[8] = {0x81, 0x02, 0x83, 0x04, 0x05, 0x06, 0x07, 0x08};

    TickType_t xLastWakeTime;

    xLastWakeTime = xTaskGetTickCount();

    LOG_INFO(0, "---c0_tx_task_fun start---\n");

    while (1)
    {
        bsp_can_send_msg(CAN_0, 0x01, data, 0);
        bsp_can_send_msg(CAN_0, 0x02, data, 0);
        bsp_can_send_msg(CAN_0, 0x03, data, 0);
        bsp_can_send_msg(CAN_0, 0x04, data, 0);

        bsp_can_send_msg(CAN_0, 0x05, data, 0);
        bsp_can_send_msg(CAN_0, 0x06, data, 0);
        bsp_can_send_msg(CAN_0, 0x07, data, 0);
        bsp_can_send_msg(CAN_0, 0x08, data, 0);

        bsp_can_send_msg(CAN_0, 0x20, data, 0);
        bsp_can_send_msg(CAN_0, 0x21, data, 0);
        bsp_can_send_msg(CAN_0, 0x22, data, 0);
        bsp_can_send_msg(CAN_0, 0x23, data, 0);

        bsp_can_send_msg(CAN_0, 0x24, data, 0);
        bsp_can_send_msg(CAN_0, 0x25, data, 0);
        bsp_can_send_msg(CAN_0, 0x26, data, 0);
        bsp_can_send_msg(CAN_0, 0x27, data, 0);

        bsp_can_send_msg(CAN_0, 0x34, data, 0);
        bsp_can_send_msg(CAN_0, 0x35, data, 0);
        bsp_can_send_msg(CAN_0, 0x36, data, 0);
        bsp_can_send_msg(CAN_0, 0x37, data, 0);

        bsp_can_send_msg(CAN_0, 0x40, data, 0);
        bsp_can_send_msg(CAN_0, 0x41, data, 0);
        bsp_can_send_msg(CAN_0, 0x42, data, 0);    /* 21 ͬʱ23xan֡ */
        
        vTaskDelayUntil(&xLastWakeTime, 100);
    }
}

/**
 * @brief   can1 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c1_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint8_t data[8] = {0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18};

    TickType_t xLastWakeTime;

    xLastWakeTime = xTaskGetTickCount();
    LOG_INFO(1, "---c1_tx_task_fun start---\n");

    while (1)
    {
        bsp_can_send_msg(CAN_1, 0xA1, data, 0);
        bsp_can_send_msg(CAN_1, 0xA2, data, 0);
        vTaskDelayUntil(&xLastWakeTime, 100);
    }
}

/**
 * @brief   can2 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c2_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint8_t data[8] = {0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28};

    TickType_t xLastWakeTime;

    xLastWakeTime = xTaskGetTickCount();
    LOG_INFO(2, "---c2_tx_task_fun start---\n");

    while (1)
    {
        bsp_can_send_msg(CAN_2, 0xB3, data, 0);
        bsp_can_send_msg(CAN_2, 0xB4, data, 0);
        vTaskDelayUntil(&xLastWakeTime, 100);
    }
}

/**
 * @brief   can3 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c3_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    
    uint8_t data[8] = {0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38};

    TickType_t xLastWakeTime = xTaskGetTickCount();

    LOG_INFO(3, "---c3_tx_task_fun start---\n");

    while (1)
    {
        bsp_can_send_msg(CAN_3, 0xC1, data, 0);
        bsp_can_send_msg(CAN_3, 0xC2, data, 0);
        bsp_can_send_msg(CAN_3, 0xC3, data, 0);
        bsp_can_send_msg(CAN_3, 0xC4, data, 0);
        vTaskDelayUntil(&xLastWakeTime, 100);
    }
}

/**
 * @brief   can4 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2025-3-19
 */
void c4_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint8_t data[8] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
   
    LOG_INFO(4, "---c4_tx_task_fun start---\n");

    while (1)
    {
        bsp_can_send_msg(CAN_4, 0x10, data, 0); /* CAN5Ϣ */
        bsp_can_send_msg(CAN_4, 0x20, data, 0); /* CAN5Ϣ */
        bsp_can_send_msg(CAN_4, 0x30, data, 0); /* CAN5Ϣ */
        bsp_can_send_msg(CAN_4, 0x40, data, 0); /* CAN5Ϣ */
        vTaskDelay(100);
    }
}


/**
 * @brief   ʱص
 * @param   xTimer:
 * @author  Samir
 * @version 1.0
 * @date    2025-03-06
 */
void software_timer_callback(TimerHandle_t xTimer)
{

    uint8_t data[8] = {0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38};

    if (xTimer == cycle_timer_handle)
    {
        bsp_can_send_msg(CAN_2, 0xB1, data, 0);
        bsp_can_send_msg(CAN_2, 0xB2, data, 0);
    }
}

/************************************* END OF FILE ************************************/