/**
****************************************************************************************
* @file    : app_main.c
* @author  : Samir
* @version : V1.0
* @date    : 2024-09-05
* @brief   : д
****************************************************************************************
* @attention
*
*   еʱ,оƬڲRAMʹõĿռΪ:  RW-data + ZI-data
*   дʱFLASHеıռõĿռΪ:      Code + RO-data + RW-data
*
****************************************************************************************
*/
#include "./app_main/app_main.h"


TaskHandle_t input_task_handle = NULL; /*  */
TaskHandle_t c0_rx_task_handle = NULL; /* CAN0 */
TaskHandle_t c0_tx_task_handle = NULL; /* CAN0 */
TaskHandle_t c1_rx_task_handle = NULL; /* CAN1 */
TaskHandle_t c1_tx_task_handle = NULL; /* CAN1 */
TaskHandle_t c2_rx_task_handle = NULL; /* CAN2 */
TaskHandle_t c2_tx_task_handle = NULL; /* CAN2 */
TaskHandle_t c3_rx_task_handle = NULL; /* CAN3 */
TaskHandle_t c3_tx_task_handle = NULL; /* CAN3 */
TaskHandle_t c4_rx_task_handle = NULL; /* CAN4 */
TaskHandle_t c4_tx_task_handle = NULL; /* CAN4 */
TaskHandle_t u0_rx_task_handle = NULL; /* 3 */
TaskHandle_t u0_tx_task_handle = NULL; /* 3 */
TaskHandle_t u5_rx_task_handle = NULL; /* 3 */
TaskHandle_t u5_tx_task_handle = NULL; /* 3 */


QueueHandle_t c0_rx_queue_handle = NULL; /* CAN0նо */
QueueHandle_t c0_tx_queue_handle = NULL; /* CAN0Ͷо */
QueueHandle_t c1_rx_queue_handle = NULL; /* CAN1նо */
QueueHandle_t c1_tx_queue_handle = NULL; /* CAN1Ͷо */
QueueHandle_t c2_rx_queue_handle = NULL; /* CAN2նо */
QueueHandle_t c2_tx_queue_handle = NULL; /* CAN2Ͷо */
QueueHandle_t c3_rx_queue_handle = NULL; /* CAN3նо */
QueueHandle_t c3_tx_queue_handle = NULL; /* CAN3Ͷо */
QueueHandle_t c4_rx_queue_handle = NULL; /* CAN4նо */
QueueHandle_t c4_tx_queue_handle = NULL; /* CAN4Ͷо */

QueueHandle_t u0_rx_queue_handle = NULL; /* 0նо */
QueueHandle_t u0_tx_queue_handle = NULL; /* 0Ͷо */
QueueHandle_t u5_rx_queue_handle = NULL; /* 5նо */
QueueHandle_t u5_tx_queue_handle = NULL; /* 5Ͷо */

TimerHandle_t cycle_timer_handle = NULL; /* ڶʱ */


/**
 * @brief   д
 * @author  Samir
 * @version 1.0
 * @date    2024-09-17
 * @note    FreeRTOS ȼΧ: 0~31
 */
void app_main(void)
{
    BaseType_t returned;

    /* can֡ID */
    uint32_t c0_rx_fifo_id[CAN0_RX_FIFO_FILTER_COUNT] = {0x10U, 0x11U, 0x12U, 0x13U, 0x14U, 0x15U, 0x801U, 0x802U};

    uint32_t c1_rx_fifo_id[CAN1_RX_FIFO_FILTER_COUNT] = {0x20U, 0x21U, 0x22U, 0x23U, 0x24U, 0x25U, 0x26U, 0x27U,
                                                         0x28U, 0x29U, 0x2aU, 0x2bU, 0x2cU, 0x2dU, 0x901U, 0x902U};

    uint32_t c2_rx_fifo_id[CAN2_RX_FIFO_FILTER_COUNT] = {0x30U, 0x31U, 0x32U, 0x33U, 0x34U, 0x35U, 0x36U, 0x37U,
                                                         0x38U, 0x39U, 0x3aU, 0x3bU, 0x3cU, 0x3dU, 0x40U, 0x41U,
                                                         0x53U, 0x54U, 0x55U, 0x56U, 0x57U, 0x58U, 0xA01U, 0xA02U};

    uint32_t c3_rx_fifo_id[CAN3_RX_FIFO_FILTER_COUNT] = {0x40U, 0x41U, 0x42U, 0x43U, 0x44U, 0x45U, 0x46U, 0x47U,
                                                         0x48U, 0x49U, 0x4aU, 0x4bU, 0x4cU, 0x4dU, 0xB01U, 0xB02U};

    uint32_t c4_rx_fifo_id[CAN4_RX_FIFO_FILTER_COUNT] = {0x50U, 0x51U, 0x52U, 0x53U, 0x54U, 0x55U, 0xC01U, 0xC02U};

    SEGGER_RTT_DUBUG_INIT();    /* ʼRTT */
    LOG_INFO(15, "*** Love Conquers All ***\r\n");
    
    x_init();                              /* ȼΪ4 ʱĬʱ1ms */
    bsp_dwt_init();                        /* ʼDWT ϵͳʽʱ */
    bsp_uart_init(UART_0);                 /* ʼ0 */
    bsp_uart_init(UART_5);                 /* ʼ5 */
    bsp_fan_init();                        /* ʼ */
    bsp_can_init(CAN_0, c0_rx_fifo_id, 2); /* ʼCAN0 */
    bsp_can_init(CAN_1, c1_rx_fifo_id, 2); /* ʼCAN1 */
    bsp_can_init(CAN_2, c2_rx_fifo_id, 2); /* ʼCAN2 */
    bsp_can_init(CAN_3, c3_rx_fifo_id, 2); /* ʼCAN3 */
    bsp_can_init(CAN_4, c4_rx_fifo_id, 2); /* ʼCAN4 */
            
    returned = xTaskCreate(input_task_fun,      /* ʵĺ */
                           "input_tx_task",     /* ıơ */
                           512,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           26,                  /* ȼ */
                           &input_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "input_tx_task error\r\n");
    }

    returned = xTaskCreate(c0_rx_task_fun,      /* ʵĺ */
                           "c0_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           21,                  /* ȼ */
                           &c0_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c0_rx_task error\r\n");
    }

    returned = xTaskCreate(c0_tx_task_fun,      /* ʵĺ */
                           "c0_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           20,                  /* ȼ */
                           &c0_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c0_tx_task error\r\n");
    }

    returned = xTaskCreate(c1_rx_task_fun,      /* ʵĺ */
                           "c1_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           19,                  /* ȼ */
                           &c1_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c1_rx_task error\r\n");
    }

    returned = xTaskCreate(c1_tx_task_fun,      /* ʵĺ */
                           "c1_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           18,                  /* ȼ */
                           &c1_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c1_tx_task error\r\n");
    }

    returned = xTaskCreate(c2_rx_task_fun,      /* ʵĺ */
                           "c2_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           17,                  /* ȼ */
                           &c2_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c2_rx_task error\r\n");
    }

    returned = xTaskCreate(c2_tx_task_fun,      /* ʵĺ */
                           "c2_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           15,                  /* ȼ */
                           &c2_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c2_tx_task error\r\n");
    }

    returned = xTaskCreate(c3_rx_task_fun,      /* ʵĺ */
                           "c3_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           14,                  /* ȼ */
                           &c3_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c3_rx_task error\r\n");
    }

    returned = xTaskCreate(c3_tx_task_fun,      /* ʵĺ */
                           "c3_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           13,                  /* ȼ */
                           &c3_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c3_tx_task error\r\n");
    }

    returned = xTaskCreate(c4_rx_task_fun,      /* ʵĺ */
                           "c4_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           12,                  /* ȼ */
                           &c4_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c4_rx_task error\r\n");
    }

    returned = xTaskCreate(c4_tx_task_fun,      /* ʵĺ */
                           "c4_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           11,                  /* ȼ */
                           &c4_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "c5_tx_task error\r\n");
    }

    returned = xTaskCreate(u0_rx_task_fun,      /* ʵĺ */
                           "u0_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           4,                   /* ȼ */
                           &u0_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "u0_rx_task error\r\n");
    }

    returned = xTaskCreate(u0_tx_task_fun,      /* ʵĺ */
                           "u0_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           3,                   /* ȼ */
                           &u0_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "u0_tx_task error\r\n");
    }

    returned = xTaskCreate(u5_rx_task_fun,      /* ʵĺ */
                           "u5_rx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           2,                   /* ȼ */
                           &u5_rx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "u5_rx_task error\r\n");
    }

    returned = xTaskCreate(u5_tx_task_fun,      /* ʵĺ */
                           "u5_tx_task",        /* ıơ */
                           256,                 /* ջСΪλ*/
                           NULL,                /* ݵС */
                           1,                   /* ȼ */
                           &u5_tx_task_handle); /*ڴݴľ */
    if (returned != pdPASS)
    {
        LOG_ERROR(15, "u5_tx_task error\r\n");
    }

    /* ʱȼΪ 16 YT-Config Tool ޸ */
    cycle_timer_handle = xTimerCreate("cycle_timer",            /* ʱƣã */
                                      pdMS_TO_TICKS(100),       /* ʱmsתΪTick */
                                      pdTRUE,                   /* pdTRUEʾԶ */
                                      (void *)0,                /* ʱID */
                                      software_timer_callback); /* ص */
    if (cycle_timer_handle != NULL) /* ʱָʱ䣬ʱȴ */
    {
        xTimerStart(cycle_timer_handle, 0); /* 0ʾ */
    }
    else
    {
        LOG_ERROR(15, "cycle_timer_create_failed\r\n");  /* ʱʧ */
    }

    c0_rx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c0_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c0_rx_queue_handle error\r\n");
    }

    c0_tx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c0_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c0_tx_queue_handle error\r\n");
    }

    c1_rx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c1_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c1_rx_queue_handle error\r\n");
    }

    c1_tx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c1_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c1_tx_queue_handle error\r\n");
    }

    c2_rx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c2_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c2_rx_queue_handle error\r\n");
    }

    c2_tx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c2_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c2_tx_queue_handle error\r\n");
    }

    c3_rx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c3_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c3_rx_queue_handle error\r\n");
    }

    c3_tx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c3_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c3_tx_queue_handle error\r\n");
    }

    c4_rx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c4_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c4_rx_queue_handle error\r\n");
    }

    c4_tx_queue_handle = xQueueCreate(CAN_QUEUE_QUANTITY, sizeof(void *));
    if (c4_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "c4_tx_queue_handle error\r\n");
    }

    u0_rx_queue_handle = xQueueCreate(UART_QUEUE_QUANTITY, sizeof(void *));
    if (u0_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "u0_rx_queue_handle error\r\n");
    }

    u0_tx_queue_handle = xQueueCreate(UART_QUEUE_QUANTITY, sizeof(void *));
    if (u0_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "u0_tx_queue_handle error\r\n");
    }

    u5_rx_queue_handle = xQueueCreate(UART_QUEUE_QUANTITY, sizeof(void *));
    if (u5_rx_queue_handle == NULL)
    {
        LOG_ERROR(15, "u5_rx_queue_handle error\r\n");
    }

    u5_tx_queue_handle = xQueueCreate(UART_QUEUE_QUANTITY, sizeof(void *));
    if (u5_tx_queue_handle == NULL)
    {
        LOG_ERROR(15, "u5_tx_queue_handle error\r\n");
    }

    vTaskStartScheduler(); /* ȳ */

    while (1)
    {
    }
}


__weak void input_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c0_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c0_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c1_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c1_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c2_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c2_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c3_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c3_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c4_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void c4_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void u0_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void u0_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void u5_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}

__weak void u5_tx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        vTaskDelay(500);
    }
}
__weak void software_timer_callback(TimerHandle_t xTimer)
{
    (void)xTimer;
}

/************************************* END OF FILE ************************************/