/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file dma_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "dma_config.h"


/*dma_ingress*/


const dma_channel_config_t dma_ingress = {
    .virtChnConfig=0,
    .source=DMA_REQ_HCU_INGRESS,
    .callback=NULL,
    .callbackParam=NULL,
};
/*dma_egress*/


const dma_channel_config_t dma_egress = {
    .virtChnConfig=1,
    .source=DMA_REQ_HCU_EGRESS,
    .callback=NULL,
    .callbackParam=NULL,
};


const dma_channel_config_t *const dmaChnConfigArray[NUM_OF_CONFIGURED_DMA_CHANNEL] = {
    &dma_ingress,
    &dma_egress,
};

const dma_user_config_t dmaController_InitConfig = {
    .haltOnError = false
};

dma_chn_state_t dma_ingress_State;
dma_chn_state_t dma_egress_State;



dma_chn_state_t *const dmaChnState[NUM_OF_CONFIGURED_DMA_CHANNEL]={
    &dma_ingress_State,
    &dma_egress_State,
};

dma_state_t dmaState;

