/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file mbedtls_config.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

#include "mbedtls_config_yuntu.h"

#if defined(MBEDTLS_MEMORY_BUFFER_ALLOC_C)
#include "mbedtls/memory_buffer_alloc.h"
static uint8_t mbedtls_mem_buf[CRYPTO_ENGINE_BUF_SIZE] = {0};
#endif

#if defined(MBEDTLS_PSA_CRYPTO_EXTERNAL_RNG)
#include "psa/crypto.h"
#include <stdlib.h>

/* This function is called by the library when it needs random bytes.
 * It must fill the output buffer with random bytes and return 0 on success.
 * It must return a non-zero value on failure.
 @note TODO:
 */
__attribute__ ((weak))
psa_status_t mbedtls_psa_external_get_random(
    mbedtls_psa_external_random_context_t *context,
    uint8_t *output, size_t output_size, size_t *output_length)
{
    
    // Example implementation:
    for (size_t i = 0; i < output_size; i++) {
        // TODO: Implement your hardware RNG here
        output[i] = rand() % 256;
    }
    *output_length = output_size;
    return 0;
}
#endif

void mbedtls_config_init()
{
#if defined(MBEDTLS_MEMORY_BUFFER_ALLOC_C)
    mbedtls_memory_buffer_alloc_init(mbedtls_mem_buf, CRYPTO_ENGINE_BUF_SIZE);
#endif
}

#ifdef __cplusplus
}
#endif


