/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"


void INT_SYS_ConfigInit()
{
    INT_SYS_DisableIRQGlobal();
    /* SysTick_IRQn(-1) SysTick_Handler*/
    INT_SYS_SetPriority(SysTick_IRQn,0);
    INT_SYS_EnableIRQ(SysTick_IRQn);
    /* DMA0_IRQn(0) DMA0_IRQHandler*/
    INT_SYS_SetPriority(DMA0_IRQn,0);
    INT_SYS_EnableIRQ(DMA0_IRQn);
    /* DMA1_IRQn(1) DMA1_IRQHandler*/
    INT_SYS_SetPriority(DMA1_IRQn,0);
    INT_SYS_EnableIRQ(DMA1_IRQn);
    /* HCU_IRQn(157) HCU_IRQHandler*/
    INT_SYS_SetPriority(HCU_IRQn,0);
    INT_SYS_EnableIRQ(HCU_IRQn);
    INT_SYS_EnableIRQGlobal();
}
