# -*- coding: utf-8 -*-
from cryptography.hazmat.primitives.asymmetric import rsa
from cryptography.hazmat.primitives import serialization
from cryptography.hazmat.backends import default_backend

# ----------------------------
# 📌 你的 RSA 私钥参数（十六进制大整数）
# ----------------------------
n = int("85EF373C4FF983240BEB6E32FCCE2F0691A07A3B62F39BA1D9D796DE7B12B2893C7CEAD38FC80A16B8993250CDEBDE4DC70ED434B8ECB4F4FA78FDED242860A42387C8D197E0D287966BD72BE824DD5E85006690A161598B2E2E9AB215C4842F30BC0A4E37CA92C4CE3D3B511ABCCDC986AEC400783F1A62EEA43D25B0A76F7BCF2CB430402DF308CE7A6ADB5E9AD5CB821435C007792D537AF7D801512BE6F5C696C69CB71B3C54A81E59EE9B7BCBB8D202A5B674020D599D016CFAF9607BA088F283C1E15678DC1AB28F1CDAEBA2757792265B760E0818EFA6E32B78DEC22644579ED25DF32AF30E51024E8C8B21A923E240C83E880EDE5284392D280B793BC73F0FA98BE30DAE72311AA3372640BCA172534A09A65A059EC67CDD0034C30D04F65034E4217A7E55166026FFFF96D2049F460C18F3F1EFA0A809003BB6EA41C13511B48A42C15A0BC2570AC15B1849D7591F387B2BE1C9933B4DD667733CB17E4C83E6EF7F2CD4B1C1D414A95C78809B1F97DED266C66D5C22BE70940F28FD", 16)
e = int("26F5", 16)  # 通常是 0x10001 (65537)
d = int("08CF54ABD82F6BBC3E1514FB51C080C529621D23EA7A58A194E9CEBAFA5CC44131074459CB63A3547BC0A9A5918FF03AEB3C593886C2B0C04EE73AEDBDA2CE86AD3E4C4DF5B62061A1BA71E7864C67607F085E6ECDF5690CEDA7BBEF7A4EFFC99AD5909B0DC202D378C95F911AAF022A28D7D2C6F7D09B573CCC598D6033435282031833057AB7EA32155959AA955D19456B0FAD58C4B104F3BB9806DD0345D78A407D99359A581CC6089E7E6EB26EE47255C16F43B8FACB64EA185DED56D1D746F56163B8DFB99EC6BD705F79A8CF184907D6F599FF5EBEC953E4DA3CC689885026DD467A59171390ED6FB628AB2C588E2F41D2D634C96F245713CDE048793DAFA6A5F1BD9575108D5A755354F77E6E9164142ECA1F1DA19694D91A4A58A33CA49AD8D5C15D394815A93453786D77B08C3EE211D27C7D8AD0060E96AA174EC0FA5236311E1C5AAD1BFA7D0F65CD6012540C5076E45168BA1F4A7BB9D4D0C721DA5B6E1EFB4A7BD321A626A103C3C1658A02B853FD92122D2F2D0883A8FA6A1D", 16)
p = int("EA83CF221F5C1A9F00CA4098EB668F6A65CBB7F6BF2548A26D293A2ADEE6992F61AA30ACE219E5B4E0F2FB4DF2E012C2F4CF95BD74A919247E74F4C2DD814E1C65EE71E79CD45428E920BE5F161D63B34B2AC09034A70C2027B7B16A60E9D467144DAD4C4B1F368978BEE65E9A6B3A70734937345F77BE7184410B9A41C706614D499D4A60C40807DC5C5C1AA97C9AEDA48CD4B712FBA9FE4229AA07027CBC2EB44061C3A57CD94C331847AA662817E7EAE39C4F3DD55F6053ACF87986A2C9F7", 16)
q = int("923471E3B50BAB6C889C9B810915BD446737710E1DD252FA3A3EBACACB4862C6BF5E95DCA8FE7732C469CE6FAD0D3E47CD162E70CF01EB14D93F8CCCE5B3014B0B8608698BB14BABD92DA241416772BABE15B5BEFD8FA01A8A1974F09825D5F9A8A6ED594589C9FF51798B29456233E462AE5AF095392A9D0C04A9C24B036762133AC841C7EC8A4E59F386A7F52BD4E7E634FB6BAE338D507AD2F2A44C1E8DEF59D58F05426149729EB6EA83C3564EF935E62495D0EA937FAB41BAC4AD7787AB", 16)
dp = int("7F132F7965E19014A65AC0755C69E2ABAD0EF98A667F2419125C9F3FD02F88BB2F81358F24CE58E44F1341C2FEDE80B5013391BF8D463EDB888531D7F1501A348177F018C6A4CCDB000E5AAE11AE892422FAF48C76FD3577DEB11BEE7B9E2608ACB7E3345A4C846F25866CA8361A530E57C776DB833A711A4439523E1343EDB08701EC8CED266DF47F9E9A12E9E47DBD52DFE8DA831602BB8536FF21B3FAFF1CB8A3A4B69C5C4B226FA002B0C8F382080CFF7AB6F03EF1FE3D3452606599E5A5", 16)
dq = int("4BF7EDF6CACE979A52A3423EF0AC3E0C21D09F0212A0855E5D41BBCC7B496BAB2A454586B410B58E04DF787C0C72BE61A18588203A46D13823AB676CA5A8EA6AA86C4D459A088B467A30A97A982A67F867639BCFA40472C37A3272AAF629E3A4D039FC7828CDD8981F176484E692ED4C2FE2F9FD1F83054700293C26942CA2EA57763440E1664B6816D0ADB918D7C1C4F6E2777F9818A15ED31C36340CF55C1A76F67FE951F42C94BB679773842C2DC20C8076EA2BC3A266E3E865B797753859", 16)
qi = int("711D4592F9B38E58E6823A7B50273A34A5DEA9FD25A020F7B525E149DC6F4E3E534182CB1127461BC97EC7B8D9B3E98A748A53E18791B615607575270B520573B973C2E6DD19A929D1F8AA10924F699A956AC4600C3B0BB1CA8A6B1E77F4FAF428384E3825EFB8861862F22883A59F3A46B37B4DCA75E25DFF331760DE912D881DE0B2B35E12DF11D1037035C873F27C5988B34DA8F4CB6E334F52EC890C263DF4F45E7D73EDA8995895F32F52A2EA6F7756851DCF8A679D0E2CD385CA31358B", 16)

# ----------------------------
# 🛠 构造 RSA 私钥对象
# ----------------------------
private_key = rsa.RSAPrivateNumbers(
    p=p,
    q=q,
    d=d,
    dmp1=dp,
    dmq1=dq,
    iqmp=qi,
    public_numbers=rsa.RSAPublicNumbers(e=e, n=n)
).private_key(default_backend())

# ----------------------------
# 📤 1. 导出为 PKCS#1 PEM 格式（传统 OpenSSL 格式）
# ----------------------------
pem_pkcs1 = private_key.private_bytes(
    encoding=serialization.Encoding.PEM,
    format=serialization.PrivateFormat.TraditionalOpenSSL,
    encryption_algorithm=serialization.NoEncryption()  # 不加密
)

with open("rsa_private_key.pem", "wb") as pem_file:
    pem_file.write(pem_pkcs1)

# ----------------------------
# 📤 2. 导出为 PKCS#1 DER 格式（二进制格式）
# ----------------------------
der_pkcs1 = private_key.private_bytes(
    encoding=serialization.Encoding.DER,
    format=serialization.PrivateFormat.TraditionalOpenSSL,
    encryption_algorithm=serialization.NoEncryption()  # 不加密
)

with open("rsa_private_key.der", "wb") as der_file:
    der_file.write(der_pkcs1)

# ----------------------------
# ✅ 完成提示
# ----------------------------
print("✅ RSA 私钥已成功生成：")
print("     - PEM 格式文件：rsa_private_key.pem（文本，可打开查看）")
print("     - DER 格式文件：rsa_private_key.der（二进制，用于程序/Java等）")